/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.MenuItemIconFactory;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyDefaultTheme;
import de.muntjak.tinylookandfeel.borders.TinyButtonBorder;
import de.muntjak.tinylookandfeel.borders.TinyFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyInternalFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyPopupMenuBorder;
import de.muntjak.tinylookandfeel.borders.TinyProgressBarBorder;
import de.muntjak.tinylookandfeel.borders.TinyScrollPaneBorder;
import de.muntjak.tinylookandfeel.borders.TinyTableHeaderBorder;
import de.muntjak.tinylookandfeel.borders.TinyTableScrollPaneBorder;
import de.muntjak.tinylookandfeel.borders.TinyTextFieldBorder;
import de.muntjak.tinylookandfeel.borders.TinyToolBarBorder;
import de.muntjak.tinylookandfeel.borders.TinyToolTipBorder;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class TinyLookAndFeel
extends MetalLookAndFeel {
    static final int MINIMUM_FRAME_WIDTH = 104;
    static final int MINIMUM_INTERNAL_FRAME_WIDTH = 32;
    public static final String VERSION_STRING = "1.3.03";
    protected static TinyDefaultTheme defaultTheme;
    private static boolean isInstalled;
    private static boolean themeHasBeenSet;
    static /* synthetic */ Class class$0;

    static {
        isInstalled = false;
        themeHasBeenSet = false;
    }

    public void initialize() {
        if (!isInstalled) {
            isInstalled = true;
            this.searchDefaultTheme();
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("TinyLookAndFeel", "de.muntjak.tinylookandfeel.TinyLookAndFeel"));
        }
    }

    private void searchDefaultTheme() {
        URL defaultURL;
        if (ControlPanel.isInstantiated) {
            return;
        }
        String loadedFrom = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.muntjak.tinylookandfeel.TinyLookAndFeel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (Theme.loadTheme(defaultURL = clazz.getResource("/Default.theme"), 3)) {
            Theme.style = 3;
            loadedFrom = defaultURL.toExternalForm();
        } else {
            defaultURL = Thread.currentThread().getContextClassLoader().getResource("Default.theme");
            if (Theme.loadTheme(defaultURL, 3)) {
                Theme.style = 3;
                loadedFrom = defaultURL.toExternalForm();
            } else {
                try {
                    defaultURL = new File(System.getProperty("user.home"), "Default.theme").toURL();
                    if (Theme.loadTheme(defaultURL, 3)) {
                        Theme.style = 3;
                        loadedFrom = defaultURL.toExternalForm();
                    } else {
                        defaultURL = new File(System.getProperty("user.dir"), "Default.theme").toURL();
                        if (Theme.loadTheme(defaultURL, 3)) {
                            Theme.style = 3;
                            loadedFrom = defaultURL.toExternalForm();
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (AccessControlException accessControlException) {}
            }
        }
        String info = "TinyLaF v1.3.03\n";
        if (loadedFrom == null) {
            System.out.println(String.valueOf(info) + "'Default.theme' not found - using YQ default theme.");
        } else {
            System.out.println(String.valueOf(info) + "Theme: " + loadedFrom);
        }
    }

    public String getID() {
        return "TinyLookAndFeel";
    }

    public String getName() {
        return "TinyLookAndFeel";
    }

    public String getDescription() {
        return "TinyLookAndFeel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public final boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.putDefaults(new Object[]{"ButtonUI", "de.muntjak.tinylookandfeel.TinyButtonUI", "CheckBoxUI", "de.muntjak.tinylookandfeel.TinyCheckBoxUI", "TextFieldUI", "de.muntjak.tinylookandfeel.TinyTextFieldUI", "TextAreaUI", "de.muntjak.tinylookandfeel.TinyTextAreaUI", "FormattedTextFieldUI", "de.muntjak.tinylookandfeel.TinyTextFieldUI", "PasswordFieldUI", "de.muntjak.tinylookandfeel.TinyPasswordFieldUI", "EditorPaneUI", "de.muntjak.tinylookandfeel.TinyEditorPaneUI", "TextPaneUI", "de.muntjak.tinylookandfeel.TinyTextPaneUI", "SliderUI", "de.muntjak.tinylookandfeel.TinySliderUI", "SpinnerUI", "de.muntjak.tinylookandfeel.TinySpinnerUI", "ToolBarUI", "de.muntjak.tinylookandfeel.TinyToolBarUI", "ToolBarSeparatorUI", "de.muntjak.tinylookandfeel.TinyToolBarSeparatorUI", "MenuBarUI", "de.muntjak.tinylookandfeel.TinyMenuBarUI", "MenuUI", "de.muntjak.tinylookandfeel.TinyMenuUI", "MenuItemUI", "de.muntjak.tinylookandfeel.TinyMenuItemUI", "CheckBoxMenuItemUI", "de.muntjak.tinylookandfeel.TinyCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "de.muntjak.tinylookandfeel.TinyRadioButtonMenuItemUI", "ScrollBarUI", "de.muntjak.tinylookandfeel.TinyScrollBarUI", "TabbedPaneUI", "de.muntjak.tinylookandfeel.TinyTabbedPaneUI", "ToggleButtonUI", "de.muntjak.tinylookandfeel.TinyButtonUI", "ScrollPaneUI", "de.muntjak.tinylookandfeel.TinyScrollPaneUI", "ProgressBarUI", "de.muntjak.tinylookandfeel.TinyProgressBarUI", "InternalFrameUI", "de.muntjak.tinylookandfeel.TinyInternalFrameUI", "RadioButtonUI", "de.muntjak.tinylookandfeel.TinyRadioButtonUI", "ComboBoxUI", "de.muntjak.tinylookandfeel.TinyComboBoxUI", "PopupMenuSeparatorUI", "de.muntjak.tinylookandfeel.TinyPopupMenuSeparatorUI", "SeparatorUI", "de.muntjak.tinylookandfeel.TinySeparatorUI", "SplitPaneUI", "de.muntjak.tinylookandfeel.TinySplitPaneUI", "FileChooserUI", "de.muntjak.tinylookandfeel.TinyFileChooserUI", "ListUI", "de.muntjak.tinylookandfeel.TinyListUI", "TreeUI", "de.muntjak.tinylookandfeel.TinyTreeUI", "LabelUI", "de.muntjak.tinylookandfeel.TinyLabelUI", "TableUI", "de.muntjak.tinylookandfeel.TinyTableUI", "TableHeaderUI", "de.muntjak.tinylookandfeel.TinyTableHeaderUI", "ToolTipUI", "de.muntjak.tinylookandfeel.TinyToolTipUI", "RootPaneUI", "de.muntjak.tinylookandfeel.TinyRootPaneUI", "DesktopPaneUI", "de.muntjak.tinylookandfeel.TinyDesktopPaneUI"});
    }

    protected void createDefaultTheme() {
        defaultTheme = new TinyDefaultTheme();
        TinyLookAndFeel.setCurrentTheme(defaultTheme);
    }

    public static void setCurrentTheme(MetalTheme theme) {
        MetalLookAndFeel.setCurrentTheme(theme);
        themeHasBeenSet = true;
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", MetalLookAndFeel.getTextHighlightColor());
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        AbstractBorder border = new EmptyBorder(0, 0, 0, 0);
        table.put("Button.border", new BorderUIResource.CompoundBorderUIResource(new TinyButtonBorder(), new BasicBorders.MarginBorder()));
        table.put("TextField.border", new TinyTextFieldBorder());
        table.put("PasswordField.border", new TinyTextFieldBorder());
        table.put("ComboBox.border", border);
        table.put("Table.scrollPaneBorder", new TinyTableScrollPaneBorder());
        table.put("TableHeader.cellBorder", new TinyTableHeaderBorder());
        table.put("Spinner.border", new TinyTextFieldBorder(new Insets(2, 2, 2, 2)));
        table.put("ProgressBar.border", new TinyProgressBarBorder());
        table.put("ToolBar.border", new TinyToolBarBorder());
        table.put("ToolTip.border", new BorderUIResource(new TinyToolTipBorder(true)));
        table.put("ToolTip.borderInactive", new BorderUIResource(new TinyToolTipBorder(false)));
        border = new TinyInternalFrameBorder();
        table.put("InternalFrame.border", border);
        table.put("InternalFrame.paletteBorder", border);
        table.put("InternalFrame.optionDialogBorder", border);
        border = new EmptyBorder(2, 4, 2, 4);
        table.put("Menu.border", border);
        table.put("MenuItem.border", border);
        table.put("CheckBoxMenuItem.border", border);
        table.put("RadioButtonMenuItem.border", border);
        table.put("PopupMenu.border", new TinyPopupMenuBorder());
        table.put("ScrollPane.border", new TinyScrollPaneBorder());
        table.put("Slider.trackWidth", new Integer(4));
        table.put("CheckBox.border", new BasicBorders.MarginBorder());
        table.put("RadioButton.border", new BasicBorders.MarginBorder());
        table.put("RadioButton.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("CheckBox.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("SplitPane.dividerSize", new Integer(7));
        table.put("InternalFrame.paletteTitleHeight", new Integer(10));
        table.put("InternalFrame.frameTitleHeight", new Integer(21));
        table.put("InternalFrame.normalTitleFont", new Font("dialog", 1, 13));
        table.put("TabbedPane.tabInsets", new Insets(1, 6, 4, 6));
        table.put("TabbedPane.selectedTabPadInsets", new Insets(2, 2, 1, 2));
        table.put("TabbedPane.unselected", new ColorUIResource(0, 0, 0));
        table.put("TabbedPane.tabAreaInsets", new Insets(6, 2, 0, 0));
        table.put("TabbedPane.contentBorderInsets", new Insets(1, 1, 3, 3));
        table.put("PopupMenu.foreground", new Color(255, 0, 0));
        table.put("RootPane.colorChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.errorDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.fileChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.frameBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.informationDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.plainDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.questionDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.warningDialogBorder", TinyFrameBorder.getInstance());
        table.put("CheckBoxMenuItem.checkIcon", MenuItemIconFactory.getCheckBoxMenuItemIcon());
        table.put("RadioButtonMenuItem.checkIcon", MenuItemIconFactory.getRadioButtonMenuItemIcon());
        table.put("Menu.arrowIcon", MenuItemIconFactory.getMenuArrowIcon());
        table.put("InternalFrame.frameTitleHeight", new Integer(25));
        table.put("InternalFrame.paletteTitleHeight", new Integer(16));
        table.put("InternalFrame.icon", TinyLookAndFeel.loadIcon("InternalFrameIcon.png", this));
        table.put("Tree.expandedIcon", TinyLookAndFeel.loadIcon("TreeMinusIcon.png", this));
        table.put("Tree.collapsedIcon", TinyLookAndFeel.loadIcon("TreePlusIcon.png", this));
        table.put("Tree.openIcon", TinyLookAndFeel.loadIcon("TreeFolderOpenedIcon.png", this));
        table.put("Tree.closedIcon", TinyLookAndFeel.loadIcon("TreeFolderClosedIcon.png", this));
        table.put("Tree.leafIcon", TinyLookAndFeel.loadIcon("TreeLeafIcon.png", this));
        table.put("FileView.directoryIcon", TinyLookAndFeel.loadIcon("DirectoryIcon.png", this));
        table.put("FileView.computerIcon", TinyLookAndFeel.loadIcon("ComputerIcon.png", this));
        table.put("FileView.fileIcon", TinyLookAndFeel.loadIcon("FileIcon.png", this));
        table.put("FileView.floppyDriveIcon", TinyLookAndFeel.loadIcon("FloppyIcon.png", this));
        table.put("FileView.hardDriveIcon", TinyLookAndFeel.loadIcon("HarddiskIcon.png", this));
        table.put("FileChooser.detailsViewIcon", TinyLookAndFeel.loadIcon("FileDetailsIcon.png", this));
        table.put("FileChooser.homeFolderIcon", TinyLookAndFeel.loadIcon("HomeFolderIcon.png", this));
        table.put("FileChooser.listViewIcon", TinyLookAndFeel.loadIcon("FileListIcon.png", this));
        table.put("FileChooser.newFolderIcon", TinyLookAndFeel.loadIcon("NewFolderIcon.png", this));
        table.put("FileChooser.upFolderIcon", TinyLookAndFeel.loadIcon("ParentDirectoryIcon.png", this));
        table.put("OptionPane.errorIcon", TinyLookAndFeel.loadIcon("ErrorIcon.png", this));
        table.put("OptionPane.informationIcon", TinyLookAndFeel.loadIcon("InformationIcon.png", this));
        table.put("OptionPane.warningIcon", TinyLookAndFeel.loadIcon("WarningIcon.png", this));
        table.put("OptionPane.questionIcon", TinyLookAndFeel.loadIcon("QuestionIcon.png", this));
    }

    public static ImageIcon loadIcon(String fileName, Object invoker) {
        URL url = Thread.currentThread().getContextClassLoader().getResource("de/muntjak/tinylookandfeel/icons/" + fileName);
        if (url == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.muntjak.tinylookandfeel.TinyLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((url = clazz.getResource("/de/muntjak/tinylookandfeel/icons/" + fileName)) == null) {
                System.err.println("TinyLaF: Icon directory could not be resolved.");
                return null;
            }
        }
        return new ImageIcon(url);
    }

    public static Color getLightControl() {
        return defaultTheme.getControlHighlight();
    }

    public static ColorUIResource getControl() {
        return null;
    }

    public static Color getDarkControl() {
        return defaultTheme.getDarkControl();
    }
}

