/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar.layout;

import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.docking.Dockable;
import org.flexdock.util.RootWindow;

public class DockbarLayoutManager {
    private static final Object LOCK = new Object();
    private static final DockbarLayoutManager DEFAULT_INSTANCE;
    private static DockbarLayoutManager viewAreaManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DockbarLayoutManager getManager() {
        Object object = LOCK;
        synchronized (object) {
            return viewAreaManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setManager(DockbarLayoutManager mgr) {
        Object object = LOCK;
        synchronized (object) {
            viewAreaManager = mgr == null ? DEFAULT_INSTANCE : mgr;
        }
    }

    public Rectangle getViewArea(DockbarManager mgr, Dockable dockable) {
        if (mgr == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle leftBar = mgr.getLeftBar().getBounds();
        Rectangle bottomBar = mgr.getBottomBar().getBounds();
        return new Rectangle(leftBar.x + leftBar.width, leftBar.y, bottomBar.width, leftBar.height);
    }

    public Rectangle getLayoutArea(DockbarManager mgr) {
        RootWindow window;
        Rectangle rect = new Rectangle();
        RootWindow rootWindow = window = mgr == null ? null : mgr.getWindow();
        if (window == null) {
            return rect;
        }
        JLayeredPane layeredPane = window.getLayeredPane();
        JComponent leftEdge = this.getEdgeGuide(mgr, 2);
        JComponent rightEdge = this.getEdgeGuide(mgr, 4);
        JComponent bottomEdge = this.getEdgeGuide(mgr, 3);
        JComponent topEdge = this.getEdgeGuide(mgr, 1);
        Rectangle leftBounds = SwingUtilities.convertRectangle(leftEdge.getParent(), leftEdge.getBounds(), layeredPane);
        Rectangle rightBounds = SwingUtilities.convertRectangle(rightEdge.getParent(), rightEdge.getBounds(), layeredPane);
        Rectangle bottomBounds = SwingUtilities.convertRectangle(bottomEdge.getParent(), bottomEdge.getBounds(), layeredPane);
        Rectangle topBounds = SwingUtilities.convertRectangle(topEdge.getParent(), topEdge.getBounds(), layeredPane);
        int rightX = rightBounds.x + rightBounds.width;
        int bottomY = bottomBounds.y + bottomBounds.height;
        rect.x = leftBounds.x;
        rect.y = topBounds.y;
        rect.width = rightX - rect.x;
        rect.height = bottomY - rect.y;
        return rect;
    }

    public JComponent getEdgeGuide(DockbarManager mgr, int edge) {
        RootWindow window = mgr == null ? null : mgr.getWindow();
        Container comp = window == null ? null : window.getContentPane();
        return comp instanceof JComponent ? (JComponent)comp : null;
    }

    static {
        viewAreaManager = DEFAULT_INSTANCE = new DockbarLayoutManager();
    }
}

