/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.type.Type;

public class ResolvedFunCall
extends ExpBase
implements FunCall {
    private final Exp[] args;
    private final Type returnType;
    private final FunDef funDef;

    public ResolvedFunCall(FunDef funDef, Exp[] args, Type returnType) {
        assert (funDef != null);
        assert (args != null);
        assert (returnType != null);
        this.funDef = funDef;
        this.args = args;
        this.returnType = returnType;
    }

    public String toString() {
        return Util.unparse(this);
    }

    public ResolvedFunCall clone() {
        return new ResolvedFunCall(this.funDef, ExpBase.cloneArray(this.args), this.returnType);
    }

    public Exp getArg(int index) {
        return this.args[index];
    }

    public Exp[] getArgs() {
        return this.args;
    }

    public final int getArgCount() {
        return this.args.length;
    }

    public String getFunName() {
        return this.funDef.getName();
    }

    public Syntax getSyntax() {
        return this.funDef.getSyntax();
    }

    public Object[] getChildren() {
        return this.args;
    }

    public FunDef getFunDef() {
        return this.funDef;
    }

    public final int getCategory() {
        return this.funDef.getReturnCategory();
    }

    public final Type getType() {
        return this.returnType;
    }

    public Exp accept(Validator validator) {
        Exp[] newArgs = new Exp[this.args.length];
        FunUtil.resolveFunArgs(validator, this.args, newArgs, this.getFunName(), this.getSyntax());
        return this;
    }

    public void unparse(PrintWriter pw) {
        this.funDef.unparse(this.args, pw);
    }

    public Calc accept(ExpCompiler compiler) {
        return this.funDef.compileCall(this, compiler);
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        for (Exp arg : this.args) {
            arg.accept(visitor);
        }
        return o;
    }
}

