/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.SetType;
import mondrian.resource.MondrianResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ToggleDrillStateFunDef
extends FunDefBase {
    static final String[] ReservedWords = new String[]{"RECURSIVE"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("ToggleDrillState", "ToggleDrillState(<Set1>, <Set2>[, RECURSIVE])", "Toggles the drill state of members. This function is a combination of DrillupMember and DrilldownMember.", new String[]{"fxxx", "fxxxy"}, ToggleDrillStateFunDef.class, ReservedWords);

    public ToggleDrillStateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        if (call.getArgCount() > 2) {
            throw MondrianResource.instance().ToggleDrillStateRecursiveNotSupported.ex();
        }
        final ListCalc listCalc0 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc1 = compiler.compileList(call.getArg(1));
        if (((SetType)call.getType()).getArity() == 1) {
            return new AbstractListCalc(call, new Calc[]{listCalc0, listCalc1}){

                public List evaluateList(Evaluator evaluator) {
                    List list0 = listCalc0.evaluateList(evaluator);
                    List list1 = listCalc1.evaluateList(evaluator);
                    return ToggleDrillStateFunDef.this.toggleDrillStateMembers(evaluator, list0, list1);
                }
            };
        }
        return new AbstractListCalc(call, new Calc[]{listCalc0, listCalc1}){

            public List evaluateList(Evaluator evaluator) {
                List list0 = listCalc0.evaluateList(evaluator);
                List list1 = listCalc1.evaluateList(evaluator);
                return ToggleDrillStateFunDef.this.toggleDrillStateTuples(evaluator, list0, list1);
            }
        };
    }

    List<Member> toggleDrillStateMembers(Evaluator evaluator, List<Member> v0, List<Member> list1) {
        if (list1.isEmpty()) {
            return v0;
        }
        if (v0.isEmpty()) {
            return v0;
        }
        HashSet<Member> set = new HashSet<Member>();
        set.addAll(list1);
        ArrayList<Member> result = new ArrayList<Member>();
        int i = 0;
        int n = v0.size();
        while (i < n) {
            Member[] children;
            boolean strict;
            Member nextMember;
            Member m = v0.get(i++);
            result.add(m);
            if (!set.contains(m)) continue;
            boolean isDrilledDown = false;
            if (i < n && FunUtil.isAncestorOf(m, nextMember = v0.get(i), strict = true)) {
                isDrilledDown = true;
            }
            if (isDrilledDown) {
                while (FunUtil.isAncestorOf(m, nextMember = v0.get(i), strict = true) && ++i < n) {
                }
                continue;
            }
            for (Member child : children = evaluator.getSchemaReader().getMemberChildren(m)) {
                result.add(child);
            }
        }
        return result;
    }

    List<Member[]> toggleDrillStateTuples(Evaluator evaluator, List<Member[]> v0, List<Member> list1) {
        if (list1.isEmpty()) {
            return v0;
        }
        if (v0.isEmpty()) {
            return v0;
        }
        HashSet<Member> set = new HashSet<Member>();
        set.addAll(list1);
        ArrayList<Member[]> result = new ArrayList<Member[]>();
        int i = 0;
        int n = v0.size();
        while (i < n) {
            Member[] children;
            boolean strict;
            Member[] next;
            Member nextMember;
            Member[] o = v0.get(i++);
            result.add(o);
            Member m = null;
            int k = -1;
            for (int j = 0; j < o.length; ++j) {
                Member member = o[j];
                if (!set.contains(member)) continue;
                k = j;
                m = member;
                break;
            }
            if (k == -1) continue;
            boolean isDrilledDown = false;
            if (i < n && FunUtil.isAncestorOf(m, nextMember = (next = v0.get(i))[k], strict = true)) {
                isDrilledDown = true;
            }
            if (isDrilledDown) {
                while (FunUtil.isAncestorOf(m, nextMember = (next = v0.get(i))[k], strict = true) && ++i < n) {
                }
                continue;
            }
            for (Member child : children = evaluator.getSchemaReader().getMemberChildren(m)) {
                Member[] members = (Member[])o.clone();
                members[k] = child;
                result.add(members);
            }
        }
        return result;
    }
}

