/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Hierarchy;
import mondrian.olap.Util;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.CubeType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

public class TypeUtil {
    public static Hierarchy typeToHierarchy(Type type) {
        if (type instanceof MemberType) {
            return ((MemberType)type).getHierarchy();
        }
        if (type instanceof LevelType) {
            return ((LevelType)type).getHierarchy();
        }
        if (type instanceof HierarchyType) {
            return ((HierarchyType)type).getHierarchy();
        }
        if (type instanceof DimensionType) {
            return ((DimensionType)type).getHierarchy();
        }
        throw Util.newInternal("not an mdx object");
    }

    public static Type stripSetType(Type type) {
        while (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        return type;
    }

    public static Type toMemberOrTupleType(Type type) {
        if ((type = TypeUtil.stripSetType(type)) instanceof TupleType) {
            return (TupleType)type;
        }
        return TypeUtil.toMemberType(type);
    }

    public static MemberType toMemberType(Type type) {
        if ((type = TypeUtil.stripSetType(type)) instanceof MemberType) {
            return (MemberType)type;
        }
        if (type instanceof DimensionType || type instanceof HierarchyType || type instanceof LevelType) {
            return MemberType.forType(type);
        }
        return null;
    }

    public static boolean isUnionCompatible(Type type1, Type type2) {
        if (type1 instanceof TupleType) {
            TupleType tupleType1 = (TupleType)type1;
            if (type2 instanceof TupleType) {
                TupleType tupleType2 = (TupleType)type2;
                if (tupleType1.elementTypes.length == tupleType2.elementTypes.length) {
                    for (int i = 0; i < tupleType1.elementTypes.length; ++i) {
                        if (TypeUtil.isUnionCompatible(tupleType1.elementTypes[i], tupleType2.elementTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        MemberType memberType1 = TypeUtil.toMemberType(type1);
        if (memberType1 == null) {
            return false;
        }
        MemberType memberType2 = TypeUtil.toMemberType(type2);
        if (memberType2 == null) {
            return false;
        }
        Hierarchy hierarchy1 = memberType1.getHierarchy();
        Hierarchy hierarchy2 = memberType2.getHierarchy();
        return TypeUtil.equal(hierarchy1, hierarchy2);
    }

    private static boolean equal(Hierarchy hierarchy1, Hierarchy hierarchy2) {
        return hierarchy1 == null || hierarchy2 == null || hierarchy2.getUniqueName().equals(hierarchy1.getUniqueName());
    }

    public static boolean canEvaluate(Type type) {
        return !(type instanceof SetType) && !(type instanceof CubeType) && !(type instanceof LevelType);
    }

    public static boolean isSet(Type type) {
        return type instanceof SetType;
    }

    public static boolean couldBeMember(Type type) {
        return type instanceof MemberType || type instanceof HierarchyType || type instanceof DimensionType;
    }

    public static int typeToCategory(Type type) {
        if (type instanceof NumericType) {
            return 7;
        }
        if (type instanceof BooleanType) {
            return 5;
        }
        if (type instanceof DimensionType) {
            return 2;
        }
        if (type instanceof HierarchyType) {
            return 3;
        }
        if (type instanceof MemberType) {
            return 6;
        }
        if (type instanceof LevelType) {
            return 4;
        }
        if (type instanceof SymbolType) {
            return 11;
        }
        if (type instanceof StringType) {
            return 9;
        }
        if (type instanceof ScalarType) {
            return 13;
        }
        if (type instanceof SetType) {
            return 8;
        }
        if (type instanceof TupleType) {
            return 10;
        }
        throw Util.newInternal("Unknown type " + type);
    }
}

