/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRDesignImage
extends JRDesignGraphicElement
implements JRImage {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EXPRESSION = "expression";
    protected Byte scaleImage;
    protected Byte horizontalAlignment;
    protected Byte verticalAlignment;
    protected Boolean isUsingCache = null;
    protected boolean isLazy = false;
    protected byte onErrorType = 1;
    protected byte evaluationTime = 1;
    protected byte hyperlinkType = 0;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    private List hyperlinkParameters = new ArrayList();
    protected JRLineBox lineBox = new JRBaseLineBox(this);
    protected JRGroup evaluationGroup = null;
    protected JRExpression expression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;
    static /* synthetic */ Class class$java$lang$String;

    public JRDesignImage(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getScaleImage() {
        return JRStyleResolver.getScaleImage(this);
    }

    public Byte getOwnScaleImage() {
        return this.scaleImage;
    }

    public void setScaleImage(byte scaleImage) {
        this.setScaleImage(new Byte(scaleImage));
    }

    public void setScaleImage(Byte scaleImage) {
        Byte old = this.scaleImage;
        this.scaleImage = scaleImage;
        this.getEventSupport().firePropertyChange("scaleImage", old, this.scaleImage);
    }

    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    public Byte getOwnHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.setHorizontalAlignment(new Byte(horizontalAlignment));
    }

    public void setHorizontalAlignment(Byte horizontalAlignment) {
        Byte old = this.horizontalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.getEventSupport().firePropertyChange("horizontalAlignment", old, this.horizontalAlignment);
    }

    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    public Byte getOwnVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(byte verticalAlignment) {
        this.setVerticalAlignment(new Byte(verticalAlignment));
    }

    public void setVerticalAlignment(Byte verticalAlignment) {
        Byte old = this.verticalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.getEventSupport().firePropertyChange("verticalAlignment", old, this.verticalAlignment);
    }

    public boolean isUsingCache() {
        if (this.isUsingCache == null) {
            if (this.getExpression() != null) {
                return (class$java$lang$String == null ? (class$java$lang$String = JRDesignImage.class$("java.lang.String")) : class$java$lang$String).getName().equals(this.getExpression().getValueClassName());
            }
            return true;
        }
        return this.isUsingCache;
    }

    public Boolean isOwnUsingCache() {
        return this.isUsingCache;
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setBox(JRBox box) {
        JRBoxUtil.setBoxToLineBox(box, this.lineBox);
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setUsingCache(boolean isUsingCache) {
        this.setUsingCache(isUsingCache ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange("usingCache", old, this.isUsingCache);
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public void setLazy(boolean isLazy) {
        boolean old = this.isLazy;
        this.isLazy = isLazy;
        this.getEventSupport().firePropertyChange("lazy", old, this.isLazy);
    }

    public byte getOnErrorType() {
        return this.onErrorType;
    }

    public void setOnErrorType(byte onErrorType) {
        byte old = this.onErrorType;
        this.onErrorType = onErrorType;
        this.getEventSupport().firePropertyChange("onErrorType", old, this.onErrorType);
    }

    public void setEvaluationTime(byte evaluationTime) {
        byte old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    public void setHyperlinkType(byte hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public void setHyperlinkTarget(byte hyperlinkTarget) {
        byte old = this.hyperlinkTarget;
        this.hyperlinkTarget = hyperlinkTarget;
        this.getEventSupport().firePropertyChange("hyperlinkTarget", old, this.hyperlinkTarget);
    }

    public void setEvaluationGroup(JRGroup evaluationGroup) {
        JRGroup old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    public void setExpression(JRExpression expression) {
        JRExpression old = this.expression;
        this.expression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_EXPRESSION, old, this.expression);
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        JRExpression old = this.anchorNameExpression;
        this.anchorNameExpression = anchorNameExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, old, this.anchorNameExpression);
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", old, this.hyperlinkReferenceExpression);
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", old, this.hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", old, this.hyperlinkPageExpression);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        int old = this.bookmarkLevel;
        this.bookmarkLevel = bookmarkLevel;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, old, this.bookmarkLevel);
    }

    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_0;
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public void setBorderColor(Color borderColor) {
        this.lineBox.getPen().setLineColor(borderColor);
    }

    public int getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public void setPadding(int padding) {
        this.lineBox.setPadding(padding);
    }

    public void setPadding(Integer padding) {
        this.lineBox.setPadding(padding);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.lineBox.getTopPen().setLineColor(topBorderColor);
    }

    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.lineBox.getLeftPen().setLineColor(leftBorderColor);
    }

    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.lineBox.getBottomPen().setLineColor(bottomBorderColor);
    }

    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.lineBox.getRightPen().setLineColor(rightBorderColor);
    }

    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String type) {
        String old = this.linkType;
        this.linkType = type;
        this.getEventSupport().firePropertyChange("linkType", old, this.linkType);
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", parameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParameters.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator it = this.hyperlinkParameters.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = (JRHyperlinkParameter)it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, it.nextIndex());
        }
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", old, this.hyperlinkTooltipExpression);
    }

    public Object clone() {
        JRDesignImage clone = (JRDesignImage)super.clone();
        if (this.hyperlinkParameters != null) {
            clone.hyperlinkParameters = new ArrayList(this.hyperlinkParameters.size());
            for (int i = 0; i < this.hyperlinkParameters.size(); ++i) {
                clone.hyperlinkParameters.add(((JRHyperlinkParameter)this.hyperlinkParameters.get(i)).clone());
            }
        }
        if (this.expression != null) {
            clone.expression = (JRExpression)this.expression.clone();
        }
        if (this.anchorNameExpression != null) {
            clone.anchorNameExpression = (JRExpression)this.anchorNameExpression.clone();
        }
        if (this.hyperlinkReferenceExpression != null) {
            clone.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            clone.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            clone.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            clone.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        this.normalizeLinkType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

