/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import antlr.ANTLRException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.olap.mapping.Axis;
import net.sf.jasperreports.olap.mapping.AxisPosition;
import net.sf.jasperreports.olap.mapping.DataMapping;
import net.sf.jasperreports.olap.mapping.Mapping;
import net.sf.jasperreports.olap.mapping.MappingLexer;
import net.sf.jasperreports.olap.mapping.MappingMetadata;
import net.sf.jasperreports.olap.mapping.MappingParser;
import net.sf.jasperreports.olap.mapping.Member;
import net.sf.jasperreports.olap.mapping.MemberDepth;
import net.sf.jasperreports.olap.mapping.MemberMapping;
import net.sf.jasperreports.olap.mapping.MemberProperty;
import net.sf.jasperreports.olap.mapping.Tuple;
import net.sf.jasperreports.olap.mapping.TuplePosition;
import net.sf.jasperreports.olap.result.JROlapCell;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapHierarchyLevel;
import net.sf.jasperreports.olap.result.JROlapMember;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JROlapDataSource
implements JRDataSource,
MappingMetadata {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$olap$JROlapDataSource == null ? (class$net$sf$jasperreports$olap$JROlapDataSource = JROlapDataSource.class$("net.sf.jasperreports.olap.JROlapDataSource")) : class$net$sf$jasperreports$olap$JROlapDataSource));
    protected final JROlapResult olapResult;
    protected JROlapResultAxis[] axes;
    protected final JROlapHierarchy[][] queryHierarchies;
    protected final int hierarchiesCount;
    protected Map fieldMatchers;
    protected int[][] fieldsMaxDepths;
    protected boolean[] iteratePositions;
    protected boolean iterate;
    protected boolean dataField;
    protected Map fieldValues;
    protected int[] axisPositions;
    protected boolean first;
    protected int[][] maxDepths;
    static /* synthetic */ Class class$net$sf$jasperreports$olap$JROlapDataSource;

    public JROlapDataSource(JRDataset dataset, JROlapResult result) {
        this.olapResult = result;
        this.axes = result.getAxes();
        this.queryHierarchies = new JROlapHierarchy[this.axes.length][];
        this.fieldsMaxDepths = new int[this.axes.length][];
        this.maxDepths = new int[this.axes.length][];
        int hCount = 0;
        for (int i = 0; i < this.axes.length; ++i) {
            this.queryHierarchies[i] = this.axes[i].getHierarchiesOnAxis();
            hCount += this.queryHierarchies[i].length;
            this.fieldsMaxDepths[i] = new int[this.queryHierarchies[i].length];
            this.maxDepths[i] = new int[this.queryHierarchies[i].length];
        }
        this.hierarchiesCount = hCount;
        this.axisPositions = new int[this.axes.length];
        this.init(dataset);
    }

    public boolean next() throws JRException {
        boolean next;
        boolean matchMaxLevel;
        block0: do {
            if (this.iterate) {
                next = this.nextPositions();
            } else {
                next = this.first;
                this.first = false;
            }
            if (!next) break;
            this.resetMaxDepths();
            Iterator it = this.fieldMatchers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object fieldName = entry.getKey();
                FieldMatcher matcher = (FieldMatcher)entry.getValue();
                if (!matcher.matches()) continue;
                Object value = matcher.value();
                this.fieldValues.put(fieldName, value);
            }
            matchMaxLevel = true;
            for (int i = 0; i < this.axes.length; ++i) {
                if (!this.iteratePositions[i]) continue;
                for (int j = 0; j < this.fieldsMaxDepths[i].length; ++j) {
                    if (this.maxDepths[i][j] >= this.fieldsMaxDepths[i][j]) continue;
                    matchMaxLevel = false;
                    continue block0;
                }
            }
        } while (!matchMaxLevel);
        return next;
    }

    private void resetMaxDepths() {
        for (int i = 0; i < this.axes.length; ++i) {
            if (!this.iteratePositions[i]) continue;
            for (int j = 0; j < this.maxDepths[i].length; ++j) {
                this.maxDepths[i][j] = 0;
            }
        }
    }

    protected boolean nextPositions() {
        int i;
        for (i = 0; i < this.axes.length; ++i) {
            if (!this.iteratePositions[i]) continue;
            int n = i;
            this.axisPositions[n] = this.axisPositions[n] + 1;
            if (this.axisPositions[i] < this.axes[i].getTupleCount()) break;
            this.axisPositions[i] = 0;
        }
        boolean next = i < this.axes.length;
        return next;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        return this.fieldValues.get(jrField.getName());
    }

    private void init(JRDataset dataset) {
        this.iteratePositions = new boolean[this.axes.length];
        this.fieldMatchers = new HashMap();
        this.dataField = false;
        JRField[] fields = dataset.getFields();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                Mapping mapping;
                JRField field = fields[i];
                String fieldMapping = this.getFieldMapping(field);
                MappingLexer lexer = new MappingLexer(new StringReader(fieldMapping));
                MappingParser parser = new MappingParser(lexer);
                parser.setMappingMetadata(this);
                try {
                    mapping = parser.mapping();
                }
                catch (ANTLRException e) {
                    log.error((Object)"Error parsing field mapping", (Throwable)e);
                    throw new JRRuntimeException(e);
                }
                if (mapping == null) {
                    throw new JRRuntimeException("Invalid field mapping \"" + fieldMapping + "\".");
                }
                this.processMappingMembers(mapping);
                FieldMatcher fieldMatcher = this.createFieldMatcher(mapping);
                this.fieldMatchers.put(field.getName(), fieldMatcher);
            }
        }
        if (!this.dataField) {
            Arrays.fill(this.iteratePositions, true);
        }
        this.initIterate();
    }

    private void processMappingMembers(Mapping mapping) {
        Iterator it = mapping.memberMappings();
        while (it.hasNext()) {
            Member member = (Member)it.next();
            this.processMemberInfo(member);
        }
    }

    private FieldMatcher createFieldMatcher(Mapping mapping) {
        FieldMatcher fieldMatcher;
        if (mapping instanceof MemberMapping) {
            fieldMatcher = new MemberFieldMatcher((MemberMapping)mapping);
        } else if (mapping instanceof DataMapping) {
            this.dataField = true;
            fieldMatcher = new DataFieldMatcher((DataMapping)mapping);
        } else {
            throw new JRRuntimeException("internal error");
        }
        return fieldMatcher;
    }

    protected String getFieldMapping(JRField field) {
        return field.getDescription();
    }

    private void initIterate() {
        int firstPos;
        for (firstPos = 0; firstPos < this.axes.length && !this.iteratePositions[firstPos]; ++firstPos) {
        }
        if (firstPos < this.axes.length) {
            this.iterate = true;
            this.axisPositions[firstPos] = -1;
        } else {
            this.iterate = false;
            this.first = true;
        }
        this.fieldValues = new HashMap();
    }

    protected void processMemberInfo(Member member) {
        int idx;
        int axis;
        int depth;
        MemberDepth memberDepth = member.getDepth();
        if (memberDepth != null && (depth = memberDepth.getDepth()) > this.fieldsMaxDepths[axis = member.getAxis().getIdx()][idx = member.getPosition().getIdx()]) {
            this.fieldsMaxDepths[axis][idx] = depth;
        }
    }

    public int getDimensionIndex(Axis axis, String dimension) {
        JROlapHierarchy[] hierarchies = this.axes[axis.getIdx()].getHierarchiesOnAxis();
        int dimensionIndex = -1;
        for (int i = 0; i < hierarchies.length; ++i) {
            JROlapHierarchy hierarchy = hierarchies[i];
            if (!dimension.equals(hierarchy.getDimensionName())) continue;
            dimensionIndex = i;
        }
        if (dimensionIndex == -1) {
            throw new JRRuntimeException("Could not find dimension \"" + dimension + "\" on axis " + axis.getIdx() + ".");
        }
        return dimensionIndex;
    }

    public int getLevelDepth(TuplePosition pos, String levelName) {
        JROlapHierarchy hierarchy = this.axes[pos.getAxis().getIdx()].getHierarchiesOnAxis()[pos.getIdx()];
        JROlapHierarchyLevel[] levels = hierarchy.getLevels();
        int levelIndex = -1;
        for (int i = 0; i < levels.length; ++i) {
            JROlapHierarchyLevel level = levels[i];
            if (level == null || !level.getName().equals(levelName)) continue;
            levelIndex = level.getDepth();
            break;
        }
        if (levelIndex == -1) {
            throw new JRRuntimeException("Could not find level \"" + levelName + "\" on hierarchy #" + pos.getIdx() + " (dimension " + hierarchy.getDimensionName() + ") on axis #" + pos.getAxis().getIdx());
        }
        return levelIndex;
    }

    protected void setMatchMemberDepth(Member memberInfo, JROlapMember member) {
        int pos;
        int memberDepth = member.getDepth();
        int axis = memberInfo.getAxis().getIdx();
        if (this.maxDepths[axis][pos = memberInfo.getPosition().getIdx()] < memberDepth) {
            this.maxDepths[axis][pos] = memberDepth;
        }
    }

    public int getTuplePosition(int axisIndex, Tuple tuple) {
        if (axisIndex > this.axes.length) {
            throw new JRRuntimeException("OLAP result doesn't contain Axis(" + axisIndex + ").");
        }
        String[] memberUniqueNames = tuple.getMemberUniqueNames();
        JROlapResultAxis axis = this.axes[axisIndex];
        int tupleCount = axis.getTupleCount();
        int pos = -1;
        for (int i = 0; i < tupleCount; ++i) {
            JROlapMemberTuple memberTuple = axis.getTuple(i);
            JROlapMember[] resMembers = memberTuple.getMembers();
            if (resMembers.length != memberUniqueNames.length) continue;
            boolean eq = true;
            for (int j = 0; eq && j < resMembers.length; ++j) {
                if (memberUniqueNames[j].equals(resMembers[j].getUniqueName())) continue;
                eq = false;
            }
            if (!eq) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            for (int i = 0; i < memberUniqueNames.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(memberUniqueNames[i]);
            }
            throw new JRRuntimeException("No such tuple " + sb + " on axis " + axisIndex + ".");
        }
        return pos;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class DataFieldMatcher
    extends FieldMatcher {
        private final boolean formatted;
        private final int[] dataPositions;
        private final Member[] members;
        private int[] positions;

        public DataFieldMatcher(DataMapping mapping) {
            this.formatted = mapping.isFormatted();
            List mappingPositions = mapping.getPositions();
            if (mappingPositions == null) {
                this.dataPositions = null;
                this.positions = JROlapDataSource.this.axisPositions;
            } else {
                if (mappingPositions.size() != JROlapDataSource.this.axes.length) {
                    throw new JRRuntimeException("Incorrect data mapping: the number of positions doesn't match the number of axes.");
                }
                this.dataPositions = new int[JROlapDataSource.this.axes.length];
                int c = 0;
                Iterator iter = mappingPositions.iterator();
                while (iter.hasNext()) {
                    int pos;
                    AxisPosition position = (AxisPosition)iter.next();
                    if (position.isSpecified()) {
                        pos = position.getPosition();
                    } else {
                        pos = -1;
                        JROlapDataSource.this.iteratePositions[c] = true;
                    }
                    this.dataPositions[c] = pos;
                    ++c;
                }
            }
            List filter = mapping.getFilter();
            if (filter == null || filter.isEmpty()) {
                this.members = null;
            } else {
                this.members = new Member[filter.size()];
                filter.toArray(this.members);
            }
        }

        public boolean matches() {
            if (this.dataPositions != null) {
                this.setPositions();
            }
            boolean matches = true;
            if (this.members != null) {
                for (int i = 0; i < this.members.length; ++i) {
                    Member memberInfo = this.members[i];
                    JROlapMember member = this.member(memberInfo, this.positions);
                    JROlapDataSource.this.setMatchMemberDepth(memberInfo, member);
                    if (memberInfo.matches(member)) continue;
                    matches = false;
                    break;
                }
            }
            return matches;
        }

        public Object value() {
            JROlapCell cell = JROlapDataSource.this.olapResult.getCell(this.positions);
            if (cell != null && cell.isError()) {
                throw new JRRuntimeException("OLAP cell calculation returned error.");
            }
            Object value = cell == null || cell.isNull() ? null : (this.formatted ? cell.getFormattedValue() : cell.getValue());
            return value;
        }

        void setPositions() {
            this.positions = new int[JROlapDataSource.this.axes.length];
            for (int i = 0; i < JROlapDataSource.this.axes.length; ++i) {
                int dataPosition = this.dataPositions[i];
                this.positions[i] = dataPosition == -1 ? JROlapDataSource.this.axisPositions[i] : dataPosition;
            }
        }
    }

    protected class MemberFieldMatcher
    extends FieldMatcher {
        final Member memberInfo;
        final MemberProperty property;
        JROlapMember member;

        MemberFieldMatcher(MemberMapping mapping) {
            this.memberInfo = mapping.getMember();
            this.property = mapping.getProperty();
        }

        public boolean matches() {
            this.member = this.member(this.memberInfo, JROlapDataSource.this.axisPositions);
            JROlapDataSource.this.setMatchMemberDepth(this.memberInfo, this.member);
            this.member = this.memberInfo.ancestorMatch(this.member);
            return this.member != null;
        }

        public Object value() {
            Object value = this.property != null ? this.member.getPropertyValue(this.property.getName()) : (this.memberInfo.getDepth() == null ? this.member.getMondrianMember() : this.member.getName());
            return value;
        }
    }

    protected abstract class FieldMatcher {
        protected FieldMatcher() {
        }

        public abstract boolean matches();

        public abstract Object value();

        public final JROlapMember member(Member memberInfo, int[] positions) {
            int axisIdx = memberInfo.getAxis().getIdx();
            JROlapResultAxis axis = JROlapDataSource.this.axes[axisIdx];
            JROlapMemberTuple tuple = axis.getTuple(positions[axisIdx]);
            JROlapMember[] members = tuple.getMembers();
            int pos = memberInfo.getPosition().getIdx();
            return members[pos];
        }
    }
}

