/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.renderers.JFreeChartRenderer;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;

public abstract class JRAbstractChartImageMapRenderer
extends JFreeChartRenderer
implements JRImageMapRenderer {
    private static final long serialVersionUID = 10200L;

    public JRAbstractChartImageMapRenderer(JFreeChart chart) {
        super(chart);
    }

    public List getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
        this.getChart().createBufferedImage((int)renderingArea.getWidth(), (int)renderingArea.getHeight(), renderingInfo);
        EntityCollection entityCollection = renderingInfo.getEntityCollection();
        ArrayList<JRPrintImageAreaHyperlink> areaHyperlinks = null;
        if (entityCollection != null && entityCollection.getEntityCount() > 0) {
            areaHyperlinks = new ArrayList<JRPrintImageAreaHyperlink>(entityCollection.getEntityCount());
            Iterator it = entityCollection.iterator();
            while (it.hasNext()) {
                ChartEntity entity = (ChartEntity)it.next();
                JRPrintHyperlink printHyperlink = this.getEntityHyperlink(entity);
                if (printHyperlink == null) continue;
                JRPrintImageArea area = this.getImageArea(entity);
                JRPrintImageAreaHyperlink areaHyperlink = new JRPrintImageAreaHyperlink();
                areaHyperlink.setArea(area);
                areaHyperlink.setHyperlink(printHyperlink);
                areaHyperlinks.add(areaHyperlink);
            }
        }
        return areaHyperlinks;
    }

    protected JRPrintImageArea getImageArea(ChartEntity entity) {
        JRPrintImageArea area = new JRPrintImageArea();
        area.setShape(JRPrintImageArea.getShape(entity.getShapeType()));
        int[] coordinates = this.getCoordinates(entity);
        if (coordinates != null) {
            area.setCoordinates(coordinates);
        }
        return area;
    }

    protected int[] getCoordinates(ChartEntity entity) {
        int[] coordinates = null;
        String shapeCoords = entity.getShapeCoords();
        if (shapeCoords != null && shapeCoords.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(shapeCoords, ",");
            coordinates = new int[tokens.countTokens()];
            int idx = 0;
            while (tokens.hasMoreTokens()) {
                String coord = tokens.nextToken();
                coordinates[idx] = Integer.parseInt(coord);
                ++idx;
            }
        }
        return coordinates;
    }

    protected abstract JRPrintHyperlink getEntityHyperlink(ChartEntity var1);
}

