/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.babylon;

import com.jaspersoft.babylon.JasperBabylonClient;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import jcmdline.BooleanParam;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.HelpCmdLineHandler;
import jcmdline.Parameter;
import jcmdline.StringParam;
import jcmdline.VersionCmdLineHandler;

public class Tool {
    public static final String helpText = "This command is used to download/upload messages on a JasperBabylon server.\n\n";

    public static void main(String[] args) {
        FileParam localeFileArg = new FileParam("file", "the source/destination locale file - defaults to stdin/stdout", 65535, true, false);
        StringParam appIdArg = new StringParam("appId", "Applicaiton ID", false);
        StringParam languageIdArg = new StringParam("languageId", "Language ID, use 'default' for default language", true);
        BooleanParam downloadOpt = new BooleanParam("download", "Download the requested locale (default operation)");
        BooleanParam uploadOpt = new BooleanParam("upload", "Upload the specified locale file on the server");
        BooleanParam listOpt = new BooleanParam("list", "List locales available for an application id");
        StringParam jasperBabylonURL = new StringParam("url", "jasperBabylonURL - default is http://127.0.0.1/jasperbabylon", true);
        StringParam usernameOpt = new StringParam("username", "Username - (your email address to upload)", true);
        StringParam passwordOpt = new StringParam("password", "Password - (your password to upload)", true);
        VersionCmdLineHandler cl = new VersionCmdLineHandler("JasperBabylonTool 1.0.0", (CmdLineHandler)new HelpCmdLineHandler(helpText, "jb.exe", "upload/download locale files", new Parameter[]{downloadOpt, uploadOpt, listOpt, jasperBabylonURL, usernameOpt, passwordOpt}, new Parameter[]{appIdArg, languageIdArg, localeFileArg}));
        cl.parse(args);
        int ops = 0;
        if (downloadOpt.isTrue()) {
            ++ops;
        }
        if (uploadOpt.isTrue()) {
            ++ops;
        }
        if (listOpt.isTrue()) {
            ++ops;
        }
        if (ops > 1) {
            System.err.println("Download, upload and list are exclusive operations");
            System.exit(1);
        }
        String appId = appIdArg.getValue();
        String languageId = "";
        languageIdArg.getValue();
        String url = "http://127.0.0.1/jasperbabylon";
        JasperBabylonClient jbc = new JasperBabylonClient();
        jbc.setAppId(appId);
        if (jasperBabylonURL.isSet()) {
            url = jasperBabylonURL.getValue();
        }
        jbc.setJasperBabylonUrl(url);
        if (downloadOpt.isTrue()) {
            if (!languageIdArg.isSet()) {
                System.err.println("Language ID required by the download operation");
                System.exit(1);
            }
            languageId = languageIdArg.getValue();
            try {
                OutputStream os = System.out;
                try {
                    if (localeFileArg.isSet()) {
                        os = new FileOutputStream(localeFileArg.getFile());
                    }
                }
                catch (Exception ex) {
                    System.err.println("Unable to open file: " + localeFileArg.getFile() + ": " + ex.getMessage());
                    System.exit(1);
                }
                System.err.println("Getting locale...");
                Properties props = jbc.getLocale(languageId);
                props.store(os, "# Downloaded by JasperBabylon");
            }
            catch (Exception ex) {
                System.err.println("Error downloading locale: " + ex.getMessage());
            }
            System.exit(0);
        } else if (uploadOpt.isTrue()) {
            if (!languageIdArg.isSet()) {
                System.err.println("Language ID required by the upload operation");
                System.exit(1);
            }
            if (!usernameOpt.isSet() || !passwordOpt.isSet()) {
                System.err.println("Username and password required to upload a locale file");
                System.exit(1);
            }
            jbc.setUsername(usernameOpt.getValue());
            jbc.setPassword(passwordOpt.getValue());
            languageId = languageIdArg.getValue();
            try {
                InputStream is = System.in;
                Properties props = new Properties();
                try {
                    if (localeFileArg.isSet()) {
                        is = new FileInputStream(localeFileArg.getFile());
                    }
                }
                catch (Exception ex) {
                    System.err.println("Unable to open file: " + localeFileArg.getFile() + ": " + ex.getMessage());
                    System.exit(1);
                }
                props.load(is);
                System.err.println("Uploading locale...");
                String msg = jbc.putLocale(languageId, props);
                System.out.println(msg);
            }
            catch (Exception ex) {
                System.err.println("Error uploading locale: " + ex.getMessage());
            }
            System.exit(0);
        } else if (listOpt.isTrue()) {
            try {
                System.err.println("Listing locales...");
                List list = jbc.listLocales();
                for (int i = 0; i < list.size(); ++i) {
                    System.out.println(list.get(i));
                }
            }
            catch (Exception ex) {
                System.err.println("Error listing locales: " + ex.getMessage());
            }
            System.exit(0);
        }
    }
}

