/*
 * Decompiled with CFR 0.152.
 */
package be.savat.components;

import be.savat.components.JBookPanel;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;

public class PagesFrame
extends JFrame {
    private JasperPrint jrPrint = null;
    private JRGraphics2DExporter exporter = null;
    private Point pageSize = new Point(350, 472);
    JBookPanel turnerNewsPaper = null;

    public PagesFrame(JasperPrint jrPrint) {
        this.initAll(jrPrint);
        Misc.centerFrame(this);
    }

    public void initAll(JasperPrint jrPrint) {
        this.initComponents();
        this.jrPrint = jrPrint;
        try {
            this.exporter = new JRGraphics2DExporter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTitle("JBookPanel from Pieter-Jan Savat!!! Great job!");
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        this.turnerNewsPaper = new JBookPanel(){

            protected Image loadPage(int index) {
                BufferedImage img = new BufferedImage(PagesFrame.this.getPageSize().x, PagesFrame.this.getPageSize().y, 1);
                Graphics gfx = img.getGraphics();
                PagesFrame.this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)PagesFrame.this.getJrPrint());
                PagesFrame.this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)new Integer(index));
                PagesFrame.this.exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)gfx);
                PagesFrame.this.exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.ZOOM_RATIO, (Object)new Float((float)PagesFrame.this.getPageSize().x / (float)PagesFrame.this.getJrPrint().getPageWidth()));
                try {
                    PagesFrame.this.exporter.exportReport();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return img;
            }
        };
        this.turnerNewsPaper.setMargins(30, 40);
        this.turnerNewsPaper.setBackground(new Color(157, 185, 235));
        this.turnerNewsPaper.setLeftPageIndex(-1);
        this.getContentPane().add((Component)this.turnerNewsPaper, "Center");
        this.updateViewerSize();
    }

    public JasperPrint getJrPrint() {
        return this.jrPrint;
    }

    void updateViewerSize() {
        System.out.println("Updating page size: " + this.getPageSize());
        System.out.flush();
        int imageWidth = this.jrPrint.getPageWidth();
        int imageHeight = this.jrPrint.getPageHeight();
        int width = this.getContentPane().getWidth() / 2 - 40;
        int height = this.getContentPane().getHeight() - 60;
        if (imageWidth <= width && imageHeight <= height) {
            this.getPageSize().x = width;
            this.getPageSize().y = height;
        } else if (width > 0 && height > 0) {
            if ((double)imageWidth / (double)width > (double)imageHeight / (double)height) {
                this.getPageSize().x = width;
                this.getPageSize().y = Math.min(imageHeight * width / imageWidth, height);
            } else {
                this.getPageSize().x = Math.min(imageWidth * height / imageHeight, width);
                this.getPageSize().y = height;
            }
        }
        int index = -1;
        index = this.turnerNewsPaper.getLeftPageIndex();
        this.turnerNewsPaper.setPages("", "", "", this.jrPrint.getPages().size() - 1, this.getPageSize().x, this.getPageSize().y);
        this.turnerNewsPaper.setLeftPageIndex(index);
        System.out.println("New size: " + this.getPageSize());
        System.out.flush();
    }

    public void setJrPrint(JasperPrint jrPrint) {
        this.jrPrint = jrPrint;
    }

    public JRGraphics2DExporter getExporter() {
        return this.exporter;
    }

    public void setExporter(JRGraphics2DExporter exporter) {
        this.exporter = exporter;
    }

    public Point getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Point pageSize) {
        this.pageSize = pageSize;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                PagesFrame.this.formComponentResized(evt);
            }
        });
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.updateViewerSize();
    }
}

