/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.ReportElement;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class EllipseReportElement
extends GraphicReportElement {
    public EllipseReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setKey("ellipse");
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        this.zoom_factor = zoom_factor;
        g.setColor(this.getBgcolor());
        if (!this.getTransparent().equalsIgnoreCase("Transparent")) {
            g.fillOval(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        }
        this.position.x += 10;
        this.position.y += 10;
        this.drawGraphicsElement(g, this.getGraphicElementPen(), zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
    }

    public ReportElement cloneMe() {
        EllipseReportElement newReportElement = new EllipseReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public void drawGraphicsElement(Graphics2D g, String pen, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        Stroke stroke = EllipseReportElement.getPenStroke(pen, zoom_factor);
        g.setColor(this.getFgcolor());
        this.zoom_factor = zoom_factor;
        if (stroke == null || pen.equalsIgnoreCase("None")) {
            return;
        }
        this.position.x -= 10;
        this.position.y -= 10;
        Stroke oldStroke = g.getStroke();
        g.setStroke(stroke);
        g.drawOval(this.getZoomedDim(this.position.x) - (x_shift_origin -= 10), this.getZoomedDim(this.position.y) - (y_shift_origin -= 10), this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        this.position.x += 10;
        this.position.y += 10;
        g.setStroke(oldStroke);
    }
}

