/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.chart.Dataset;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.crosstab.CrosstabColumnGroup;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabRowGroup;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.crosstab.gui.GroupByFieldPanel;
import it.businesslogic.ireport.crosstab.gui.WizardFieldObject;
import it.businesslogic.ireport.gui.subdataset.SubDatasetDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class CrosstabWizardDialog
extends JDialog {
    private CrosstabReportElement crosstabReportElement = null;
    private SubDataset crosstabSubDataset = null;
    private int currentStep = -1;
    private int dialogResult = -1;
    private Report report = null;
    private Vector stepsPanels = new Vector();
    private Vector stepsLabels = new Vector();
    private GroupByFieldPanel groupByFieldPanel1;
    private GroupByFieldPanel groupByFieldPanel2;
    private GroupByFieldPanel groupByFieldPanel3;
    private GroupByFieldPanel groupByFieldPanel4;
    private JButton jButtonCancel;
    private JButton jButtonFinish;
    private JButton jButtonNewSubDataset;
    private JButton jButtonNext;
    private JButton jButtonPrev;
    private JCheckBox jCheckBoxPrintGrid;
    private JCheckBox jCheckBoxTotalColumns;
    private JCheckBox jCheckBoxTotalRows;
    private JComboBox jComboBoxDetailField;
    private JComboBox jComboBoxDetailFieldFunction;
    private JComboBox jComboBoxSubdataset;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelDetailField;
    private JLabel jLabelDetailField1;
    private JLabel jLabelResult;
    private JLabel jLabelStep1;
    private JLabel jLabelStep2;
    private JLabel jLabelStep3;
    private JLabel jLabelStep4;
    private JLabel jLabelStep5;
    private JLabel jLabelStep6;
    private JLabel jLabelStepDescription;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanelBase;
    private JPanel jPanelContent;
    private JPanel jPanelContentButtons;
    private JPanel jPanelStep0;
    private JPanel jPanelStep1;
    private JPanel jPanelStep2;
    private JPanel jPanelStep3;
    private JPanel jPanelStep4;
    private JPanel jPanelStep5;
    private JPanel jPanelStepContainer;
    private JPanel jPanelSteps;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;

    public CrosstabWizardDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.stepsPanels.add(this.jPanelStep0);
        this.stepsPanels.add(this.jPanelStep1);
        this.stepsPanels.add(this.jPanelStep2);
        this.stepsPanels.add(this.jPanelStep3);
        this.stepsPanels.add(this.jPanelStep4);
        this.stepsPanels.add(this.jPanelStep5);
        this.stepsLabels.add(this.jLabelStep1);
        this.stepsLabels.add(this.jLabelStep2);
        this.stepsLabels.add(this.jLabelStep3);
        this.stepsLabels.add(this.jLabelStep4);
        this.stepsLabels.add(this.jLabelStep5);
        this.stepsLabels.add(this.jLabelStep6);
        this.groupByFieldPanel2.addVoidItem();
        this.groupByFieldPanel4.addVoidItem();
        this.groupByFieldPanel1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.groupByFieldPanel1CancelActionPerformed(evt);
            }
        });
        this.groupByFieldPanel2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.groupByFieldPanel2CancelActionPerformed(evt);
            }
        });
        this.groupByFieldPanel3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.groupByFieldPanel3CancelActionPerformed(evt);
            }
        });
        this.groupByFieldPanel4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.groupByFieldPanel4CancelActionPerformed(evt);
            }
        });
        this.applyI18n();
        this.goNext();
        this.pack();
        Misc.centerFrame(this);
    }

    public void groupByFieldPanel1CancelActionPerformed(ActionEvent evt) {
        if (this.getCurrentStep() == 1) {
            this.updateButtons();
        }
    }

    public void groupByFieldPanel2CancelActionPerformed(ActionEvent evt) {
    }

    public void groupByFieldPanel3CancelActionPerformed(ActionEvent evt) {
        if (this.getCurrentStep() == 2) {
            this.updateButtons();
        }
    }

    public void groupByFieldPanel4CancelActionPerformed(ActionEvent evt) {
    }

    private void initComponents() {
        this.jPanelBase = new JPanel();
        this.jPanelSteps = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabelStep1 = new JLabel();
        this.jLabelStep2 = new JLabel();
        this.jLabelStep3 = new JLabel();
        this.jLabelStep4 = new JLabel();
        this.jLabelStep5 = new JLabel();
        this.jLabelStep6 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel7 = new JLabel();
        this.jPanelContent = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabelStepDescription = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.jPanelStepContainer = new JPanel();
        this.jPanelStep0 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxSubdataset = new JComboBox();
        this.jButtonNewSubDataset = new JButton();
        this.jPanelStep1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.groupByFieldPanel1 = new GroupByFieldPanel();
        this.groupByFieldPanel2 = new GroupByFieldPanel();
        this.jPanel3 = new JPanel();
        this.jPanelStep2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.groupByFieldPanel3 = new GroupByFieldPanel();
        this.groupByFieldPanel4 = new GroupByFieldPanel();
        this.jPanel4 = new JPanel();
        this.jPanelStep3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabelDetailField = new JLabel();
        this.jComboBoxDetailField = new JComboBox();
        this.jLabelDetailField1 = new JLabel();
        this.jComboBoxDetailFieldFunction = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jPanelStep4 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jCheckBoxTotalRows = new JCheckBox();
        this.jCheckBoxTotalColumns = new JCheckBox();
        this.jCheckBoxPrintGrid = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jPanelStep5 = new JPanel();
        this.jLabelResult = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jPanelContentButtons = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButtonPrev = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonFinish = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanelBase.setLayout(new GridBagLayout());
        this.jPanelSteps.setLayout(new GridBagLayout());
        this.jLabel1.setText("Steps");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.jPanelSteps.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabelStep1.setText("1. SubDataset selection");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanelSteps.add((Component)this.jLabelStep1, gridBagConstraints);
        this.jLabelStep2.setText("2. Rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanelSteps.add((Component)this.jLabelStep2, gridBagConstraints);
        this.jLabelStep3.setText("3. Columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanelSteps.add((Component)this.jLabelStep3, gridBagConstraints);
        this.jLabelStep4.setText("4. Detail");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanelSteps.add((Component)this.jLabelStep4, gridBagConstraints);
        this.jLabelStep5.setText("5. Layout");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanelSteps.add((Component)this.jLabelStep5, gridBagConstraints);
        this.jLabelStep6.setText("6. Finish");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanelSteps.add((Component)this.jLabelStep6, gridBagConstraints);
        this.jSeparator2.setBackground(new Color(204, 204, 255));
        this.jSeparator2.setForeground(new Color(0, 0, 0));
        this.jSeparator2.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.jSeparator2.setMinimumSize(new Dimension(2, 2));
        this.jSeparator2.setPreferredSize(new Dimension(1, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanelSteps.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabel7.setBackground(new Color(207, 217, 231));
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/wizard.jpg")));
        this.jLabel7.setVerticalAlignment(1);
        this.jLabel7.setOpaque(true);
        this.jLabel7.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelSteps.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanelBase.add((Component)this.jPanelSteps, gridBagConstraints);
        this.jPanelContent.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(40, 40));
        this.jPanel1.setPreferredSize(new Dimension(280, 40));
        this.jLabelStepDescription.setText("Steps");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 8, 0, 0);
        this.jPanel1.add((Component)this.jLabelStepDescription, gridBagConstraints);
        this.jSeparator4.setBackground(new Color(204, 204, 255));
        this.jSeparator4.setForeground(new Color(0, 0, 0));
        this.jSeparator4.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.jSeparator4.setMinimumSize(new Dimension(2, 2));
        this.jSeparator4.setPreferredSize(new Dimension(1, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanelContent.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanelStepContainer.setLayout(new BorderLayout());
        this.jPanelStepContainer.setPreferredSize(new Dimension(220, 180));
        this.jPanelStep0.setLayout(new GridBagLayout());
        this.jLabel2.setText("Available subdataset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanelStep0.add((Component)this.jLabel2, gridBagConstraints);
        this.jComboBoxSubdataset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.jComboBoxSubdatasetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanelStep0.add((Component)this.jComboBoxSubdataset, gridBagConstraints);
        this.jButtonNewSubDataset.setText("Create new subdataset");
        this.jButtonNewSubDataset.setActionCommand("Create a new subdataset");
        this.jButtonNewSubDataset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.jButtonNewSubDatasetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.jPanelStep0.add((Component)this.jButtonNewSubDataset, gridBagConstraints);
        this.jPanelStepContainer.add((Component)this.jPanelStep0, "Center");
        this.jPanelStep1.setLayout(new GridBagLayout());
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/crosstab/wizard_rows.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.jPanelStep1.add((Component)this.jLabel3, gridBagConstraints);
        this.groupByFieldPanel1.setTitle("Row group 1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelStep1.add((Component)this.groupByFieldPanel1, gridBagConstraints);
        this.groupByFieldPanel2.setTitle("Row group 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelStep1.add((Component)this.groupByFieldPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelStep1.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanelStepContainer.add((Component)this.jPanelStep1, "Center");
        this.jPanelStep2.setLayout(new GridBagLayout());
        this.jPanelStep2.setMinimumSize(new Dimension(250, 231));
        this.jPanelStep2.setOpaque(false);
        this.jPanelStep2.setPreferredSize(new Dimension(250, 250));
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/crosstab/wizard_columns.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.jPanelStep2.add((Component)this.jLabel4, gridBagConstraints);
        this.groupByFieldPanel3.setTitle("Column group 1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelStep2.add((Component)this.groupByFieldPanel3, gridBagConstraints);
        this.groupByFieldPanel4.setTitle("Column group 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelStep2.add((Component)this.groupByFieldPanel4, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelStep2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanelStepContainer.add((Component)this.jPanelStep2, "Center");
        this.jPanelStep3.setLayout(new GridBagLayout());
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/crosstab/wizard_details.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.jPanelStep3.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabelDetailField.setText("Detail field");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelStep3.add((Component)this.jLabelDetailField, gridBagConstraints);
        this.jComboBoxDetailField.setPreferredSize(new Dimension(55, 20));
        this.jComboBoxDetailField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.jComboBoxDetailFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelStep3.add((Component)this.jComboBoxDetailField, gridBagConstraints);
        this.jLabelDetailField1.setText("Function");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanelStep3.add((Component)this.jLabelDetailField1, gridBagConstraints);
        this.jComboBoxDetailFieldFunction.setPreferredSize(new Dimension(55, 20));
        this.jComboBoxDetailFieldFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.jComboBoxDetailFieldActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelStep3.add((Component)this.jComboBoxDetailFieldFunction, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelStep3.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanelStepContainer.add((Component)this.jPanelStep3, "Center");
        this.jPanelStep4.setLayout(new GridBagLayout());
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/crosstab/wizard_totals.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelStep4.add((Component)this.jLabel6, gridBagConstraints);
        this.jCheckBoxTotalRows.setSelected(true);
        this.jCheckBoxTotalRows.setText("Add row group totals");
        this.jCheckBoxTotalRows.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxTotalRows.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.jPanelStep4.add((Component)this.jCheckBoxTotalRows, gridBagConstraints);
        this.jCheckBoxTotalColumns.setSelected(true);
        this.jCheckBoxTotalColumns.setText("Add column group totals");
        this.jCheckBoxTotalColumns.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxTotalColumns.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        this.jPanelStep4.add((Component)this.jCheckBoxTotalColumns, gridBagConstraints);
        this.jCheckBoxPrintGrid.setSelected(true);
        this.jCheckBoxPrintGrid.setText("Show grid lines");
        this.jCheckBoxPrintGrid.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxPrintGrid.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.jPanelStep4.add((Component)this.jCheckBoxPrintGrid, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelStep4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanelStepContainer.add((Component)this.jPanelStep4, "Center");
        this.jPanelStep5.setLayout(new GridBagLayout());
        this.jLabelResult.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanelStep5.add((Component)this.jLabelResult, gridBagConstraints);
        this.jPanelStepContainer.add((Component)this.jPanelStep5, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelContent.add((Component)this.jPanelStepContainer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelBase.add((Component)this.jPanelContent, gridBagConstraints);
        this.jSeparator3.setBackground(new Color(204, 204, 255));
        this.jSeparator3.setForeground(new Color(0, 0, 0));
        this.jSeparator3.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.jSeparator3.setMinimumSize(new Dimension(2, 2));
        this.jSeparator3.setPreferredSize(new Dimension(1, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelBase.add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanelContentButtons.setLayout(new GridBagLayout());
        this.jPanelContentButtons.setMinimumSize(new Dimension(10, 30));
        this.jPanelContentButtons.setPreferredSize(new Dimension(10, 40));
        this.jPanel2.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelContentButtons.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonPrev.setText("< Prev");
        this.jButtonPrev.setEnabled(false);
        this.jButtonPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.jButtonPrevActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 8, 2);
        this.jPanelContentButtons.add((Component)this.jButtonPrev, gridBagConstraints);
        this.jButtonNext.setText("Next >");
        this.jButtonNext.setEnabled(false);
        this.jButtonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.jButtonNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 8, 2);
        this.jPanelContentButtons.add((Component)this.jButtonNext, gridBagConstraints);
        this.jButtonFinish.setText("Finish");
        this.jButtonFinish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.jButtonFinishActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 8, 2);
        this.jPanelContentButtons.add((Component)this.jButtonFinish, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabWizardDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 2, 8, 4);
        this.jPanelContentButtons.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelBase.add((Component)this.jPanelContentButtons, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelBase, "Center");
        this.pack();
    }

    public void applyStandardBlackBox(CrosstabCell cell) {
        cell.getBox().setRightBorderColor(Color.BLACK);
        cell.getBox().setRightBorder("1Point");
        cell.getBox().setBottomBorderColor(Color.BLACK);
        cell.getBox().setBottomBorder("1Point");
    }

    public void addTextfieldElement(CrosstabCell cell, String expression, String expressionClass) {
        TextFieldReportElement tf = new TextFieldReportElement(0, 0, cell.getWidth(), cell.getHeight());
        tf.setRelativePosition(new Point(0, 0));
        tf.setCell(cell);
        tf.setText(expression);
        tf.setMatchingClassExpression(expressionClass, true);
        tf.setVerticalAlign("Middle");
        tf.setAlign("Center");
        this.getCrosstabReportElement().getElements().add(tf);
    }

    public String getGroupMeasureName(String baseName, int add) {
        CrosstabGroup cg;
        int i;
        String name = baseName + (add == 0 ? "" : "" + add);
        ++add;
        for (i = 0; i < this.getCrosstabReportElement().getRowGroups().size(); ++i) {
            cg = (CrosstabGroup)this.getCrosstabReportElement().getRowGroups().elementAt(i);
            if (!cg.getName().equals(name)) continue;
            return this.getGroupMeasureName(baseName, add);
        }
        for (i = 0; i < this.getCrosstabReportElement().getColumnGroups().size(); ++i) {
            cg = (CrosstabGroup)this.getCrosstabReportElement().getColumnGroups().elementAt(i);
            if (!cg.getName().equals(name)) continue;
            return this.getGroupMeasureName(baseName, add);
        }
        for (i = 0; i < this.getCrosstabReportElement().getMeasures().size(); ++i) {
            Measure cm = (Measure)this.getCrosstabReportElement().getMeasures().elementAt(i);
            if (!cm.getName().equals(name)) continue;
            return this.getGroupMeasureName(baseName, add);
        }
        return name;
    }

    private void jButtonFinishActionPerformed(ActionEvent evt) {
        try {
            SubDataset sd = (SubDataset)this.jComboBoxSubdataset.getSelectedItem();
            if (!(sd instanceof Report)) {
                Dataset dataset = new Dataset();
                dataset.setSubDataset(sd);
                dataset.setConnectionExpression("$P{REPORT_CONNECTION}");
                dataset.setUseConnection(true);
                this.getCrosstabReportElement().setDataset(dataset);
                this.getCrosstabReportElement().setUseDataset(true);
            }
            CrosstabCell cell = (CrosstabCell)this.getCrosstabReportElement().getCells().elementAt(0);
            cell.setWidth(50);
            cell.setHeight(30);
            if (this.jCheckBoxPrintGrid.isSelected()) {
                this.applyStandardBlackBox(cell);
            }
            CrosstabGroup group = new CrosstabRowGroup();
            group.setName(this.getGroupMeasureName(this.groupByFieldPanel1.getFieldName(), 0));
            group.setBucketExpression(this.groupByFieldPanel1.getExpression());
            group.setBucketExpressionClass(this.groupByFieldPanel1.getExpressionClass());
            CrosstabCell headerCell = new CrosstabCell();
            headerCell.setName(group.getName() + " header");
            headerCell.setType(1);
            headerCell.setWidth(group.getSize());
            headerCell.setHeight(30);
            if (this.jCheckBoxPrintGrid.isSelected()) {
                headerCell.getBox().setLeftBorder("1Point");
                headerCell.getBox().setLeftBorderColor(Color.BLACK);
                this.applyStandardBlackBox(headerCell);
            }
            this.applyStandardBlackBox(headerCell);
            group.setHeaderCell(headerCell);
            this.addTextfieldElement(headerCell, "$V{" + group.getName() + "}", group.getBucketExpressionClass());
            CrosstabCell totalHeaderCell = new CrosstabCell();
            totalHeaderCell.setName(group.getName() + " total header");
            totalHeaderCell.setType(1);
            totalHeaderCell.setWidth(group.getSize());
            if (this.jCheckBoxTotalRows.isSelected()) {
                group.setTotalPosition("End");
                totalHeaderCell.setHeight(30);
                this.addTextfieldElement(totalHeaderCell, "\"" + group.getName() + " total\"", "java.lang.String");
            } else {
                totalHeaderCell.setHeight(0);
            }
            if (this.jCheckBoxPrintGrid.isSelected()) {
                totalHeaderCell.getBox().setLeftBorder("1Point");
                totalHeaderCell.getBox().setLeftBorderColor(Color.BLACK);
                this.applyStandardBlackBox(totalHeaderCell);
            }
            group.setTotalCell(totalHeaderCell);
            this.getCrosstabReportElement().getCells().add(group.getHeaderCell());
            this.getCrosstabReportElement().getCells().add(group.getTotalCell());
            this.getCrosstabReportElement().getRowGroups().add(group);
            if (this.groupByFieldPanel2.getFieldName() != null && !this.groupByFieldPanel2.getFieldName().equals("")) {
                group = new CrosstabRowGroup();
                group.setName(this.getGroupMeasureName(this.groupByFieldPanel2.getFieldName(), 0));
                group.setBucketExpression(this.groupByFieldPanel2.getExpression());
                group.setBucketExpressionClass(this.groupByFieldPanel2.getExpressionClass());
                headerCell = new CrosstabCell();
                headerCell.setName(group.getName() + " header");
                headerCell.setType(1);
                headerCell.setWidth(group.getSize());
                headerCell.setHeight(30);
                group.setHeaderCell(headerCell);
                if (this.jCheckBoxPrintGrid.isSelected()) {
                    this.applyStandardBlackBox(headerCell);
                }
                this.addTextfieldElement(headerCell, "$V{" + group.getName() + "}", group.getBucketExpressionClass());
                totalHeaderCell = new CrosstabCell();
                totalHeaderCell.setName(group.getName() + " total header");
                totalHeaderCell.setType(1);
                totalHeaderCell.setWidth(group.getSize());
                if (this.jCheckBoxTotalRows.isSelected()) {
                    group.setTotalPosition("End");
                    totalHeaderCell.setHeight(30);
                    this.addTextfieldElement(totalHeaderCell, "\"" + group.getName() + " total\"", "java.lang.String");
                } else {
                    totalHeaderCell.setHeight(0);
                }
                group.setTotalCell(totalHeaderCell);
                if (this.jCheckBoxPrintGrid.isSelected()) {
                    this.applyStandardBlackBox(totalHeaderCell);
                }
                this.getCrosstabReportElement().getCells().add(group.getHeaderCell());
                this.getCrosstabReportElement().getCells().add(group.getTotalCell());
                this.getCrosstabReportElement().getRowGroups().add(group);
            }
            group = new CrosstabColumnGroup();
            group.setName(this.getGroupMeasureName(this.groupByFieldPanel3.getFieldName(), 0));
            group.setBucketExpression(this.groupByFieldPanel3.getExpression());
            group.setBucketExpressionClass(this.groupByFieldPanel3.getExpressionClass());
            headerCell = new CrosstabCell();
            headerCell.setName(group.getName() + " header");
            headerCell.setType(1);
            headerCell.setHeight(group.getSize());
            headerCell.setWidth(50);
            if (this.jCheckBoxPrintGrid.isSelected()) {
                headerCell.getBox().setTopBorder("1Point");
                headerCell.getBox().setTopBorderColor(Color.BLACK);
                this.applyStandardBlackBox(headerCell);
            }
            group.setHeaderCell(headerCell);
            this.addTextfieldElement(headerCell, "$V{" + group.getName() + "}", group.getBucketExpressionClass());
            totalHeaderCell = new CrosstabCell();
            totalHeaderCell.setName(group.getName() + " total header");
            totalHeaderCell.setType(1);
            totalHeaderCell.setHeight(group.getSize());
            if (this.jCheckBoxTotalColumns.isSelected()) {
                group.setTotalPosition("End");
                totalHeaderCell.setWidth(50);
                this.addTextfieldElement(totalHeaderCell, "\"" + group.getName() + " total\"", "java.lang.String");
            } else {
                totalHeaderCell.setWidth(0);
            }
            if (this.jCheckBoxPrintGrid.isSelected()) {
                totalHeaderCell.getBox().setTopBorder("1Point");
                totalHeaderCell.getBox().setTopBorderColor(Color.BLACK);
                this.applyStandardBlackBox(totalHeaderCell);
            }
            group.setTotalCell(totalHeaderCell);
            this.getCrosstabReportElement().getCells().add(group.getHeaderCell());
            this.getCrosstabReportElement().getCells().add(group.getTotalCell());
            this.getCrosstabReportElement().getColumnGroups().add(group);
            if (this.groupByFieldPanel4.getFieldName() != null && !this.groupByFieldPanel4.getFieldName().equals("")) {
                group = new CrosstabColumnGroup();
                group.setName(this.getGroupMeasureName(this.groupByFieldPanel4.getFieldName(), 0));
                group.setBucketExpression(this.groupByFieldPanel4.getExpression());
                group.setBucketExpressionClass(this.groupByFieldPanel4.getExpressionClass());
                headerCell = new CrosstabCell();
                headerCell.setName(group.getName() + " header");
                headerCell.setType(1);
                headerCell.setHeight(group.getSize());
                headerCell.setWidth(50);
                if (this.jCheckBoxPrintGrid.isSelected()) {
                    this.applyStandardBlackBox(headerCell);
                }
                group.setHeaderCell(headerCell);
                this.addTextfieldElement(headerCell, "$V{" + group.getName() + "}", group.getBucketExpressionClass());
                totalHeaderCell = new CrosstabCell();
                totalHeaderCell.setName(group.getName() + " total header");
                totalHeaderCell.setType(1);
                totalHeaderCell.setHeight(group.getSize());
                if (this.jCheckBoxTotalColumns.isSelected()) {
                    group.setTotalPosition("End");
                    totalHeaderCell.setWidth(50);
                    this.addTextfieldElement(totalHeaderCell, "\"" + group.getName() + " total\"", "java.lang.String");
                } else {
                    totalHeaderCell.setWidth(0);
                }
                group.setTotalCell(totalHeaderCell);
                if (this.jCheckBoxPrintGrid.isSelected()) {
                    this.applyStandardBlackBox(totalHeaderCell);
                }
                this.getCrosstabReportElement().getCells().add(group.getHeaderCell());
                this.getCrosstabReportElement().getCells().add(group.getTotalCell());
                this.getCrosstabReportElement().getColumnGroups().add(group);
            }
            WizardFieldObject wfo = (WizardFieldObject)this.jComboBoxDetailField.getSelectedItem();
            Measure measure = new Measure(this.getGroupMeasureName(wfo.getName() + "_" + this.jComboBoxDetailFieldFunction.getSelectedItem(), 0));
            measure.setClassType(wfo.getExpressionClass(null));
            measure.setCalculation(this.jComboBoxDetailFieldFunction.getSelectedItem() + "");
            measure.setExpression(wfo.getExpression(""));
            this.getCrosstabReportElement().getMeasures().add(measure);
            this.addTextfieldElement(cell, "$V{" + measure.getName() + "}", measure.getClassType());
            this.setDialogResult(0);
            this.setVisible(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setDialogResult(0);
        this.setVisible(false);
    }

    private void jButtonNewSubDatasetActionPerformed(ActionEvent evt) {
        SubDatasetDialog sds = new SubDatasetDialog((Dialog)this, true);
        sds.setVisible(true);
        this.setReport(this.report);
    }

    private void jComboBoxDetailFieldActionPerformed1(ActionEvent evt) {
    }

    private void jComboBoxDetailFieldActionPerformed(ActionEvent evt) {
        if (this.jComboBoxDetailField.getSelectedIndex() < 0 || !(this.jComboBoxDetailField.getSelectedItem() instanceof WizardFieldObject)) {
            this.jComboBoxDetailFieldFunction.removeAllItems();
        } else {
            WizardFieldObject wfo = (WizardFieldObject)this.jComboBoxDetailField.getSelectedItem();
            Misc.updateComboBox(this.jComboBoxDetailFieldFunction, wfo.getFunctions());
            if (this.jComboBoxDetailFieldFunction.getItemCount() > 0) {
                this.jComboBoxDetailFieldFunction.setSelectedIndex(0);
            }
        }
        if (this.getCurrentStep() == 3) {
            this.updateButtons();
        }
    }

    private void jButtonPrevActionPerformed(ActionEvent evt) {
        this.goPrevious();
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        this.goNext();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dialogResult = -1;
        this.setVisible(false);
        this.dispose();
    }

    private void jComboBoxSubdatasetActionPerformed(ActionEvent evt) {
        if (this.jComboBoxSubdataset.getSelectedItem() != null && this.jComboBoxSubdataset.getSelectedItem() instanceof SubDataset) {
            this.setCrosstabSubDataset((SubDataset)this.jComboBoxSubdataset.getSelectedItem());
        }
        if (this.getCurrentStep() == 0) {
            this.updateButtons();
        }
    }

    public void goNext() {
        if (this.currentStep < this.getStepsPanels().size() - 1) {
            ++this.currentStep;
        }
        this.setCurrentStepLabel(this.currentStep);
        this.jPanelStepContainer.removeAll();
        this.jPanelStepContainer.add((Component)this.getStepsPanels().elementAt(this.currentStep), "Center");
        this.jPanelStepContainer.updateUI();
        if (this.currentStep == 0) {
            this.jLabelStepDescription.setText("Step 1: Choose a subdataset or create a new one");
        } else if (this.currentStep == 1) {
            this.jLabelStepDescription.setText("Step 2: Define row group(s)");
        } else if (this.currentStep == 2) {
            this.jLabelStepDescription.setText("Step 3: Define column group(s)");
        } else if (this.currentStep == 3) {
            this.jLabelStepDescription.setText("Step 4: Define detail");
        } else if (this.currentStep == 4) {
            this.jLabelStepDescription.setText("Step 5: Choose a layout");
        } else if (this.currentStep == 5) {
            this.jLabelStepDescription.setText("Step 6: Finish");
        }
        this.updateButtons();
    }

    public void goPrevious() {
        if (this.currentStep > 0) {
            --this.currentStep;
        }
        this.jPanelStepContainer.removeAll();
        this.jPanelStepContainer.add((Component)this.getStepsPanels().elementAt(this.currentStep), "Center");
        this.jPanelStepContainer.updateUI();
        this.setCurrentStepLabel(this.currentStep);
        this.updateButtons();
    }

    public void setCurrentStepLabel(int step) {
        for (int i = 0; i < this.stepsLabels.size(); ++i) {
            JLabel label = (JLabel)this.stepsLabels.get(i);
            label.setFont(new Font(label.getFont().getName(), i == step ? 1 : 0, label.getFont().getSize()));
            label.updateUI();
        }
    }

    public void updateButtons() {
        this.jButtonFinish.setEnabled(this.canFinish());
        this.jButtonPrev.setEnabled(this.canGoPrevious());
        this.jButtonNext.setEnabled(this.canGoNext());
    }

    public boolean canGoPrevious() {
        return this.getCurrentStep() > 0;
    }

    public boolean canGoNext() {
        if (this.getCurrentStep() == 0) {
            if (this.jComboBoxSubdataset.getSelectedItem() == null || !(this.jComboBoxSubdataset.getSelectedItem() instanceof SubDataset)) {
                return false;
            }
        } else if (this.getCurrentStep() == 1) {
            if (this.groupByFieldPanel1.getFieldName() == null || this.groupByFieldPanel1.getFieldName().equals("")) {
                return false;
            }
        } else if (this.getCurrentStep() == 2) {
            if (this.groupByFieldPanel3.getFieldName() == null || this.groupByFieldPanel3.getFieldName().equals("")) {
                return false;
            }
        } else if (this.getCurrentStep() == 3) {
            if (this.jComboBoxDetailField.getSelectedIndex() < 0 || !(this.jComboBoxDetailField.getSelectedItem() instanceof WizardFieldObject)) {
                return false;
            }
        } else {
            if (this.getCurrentStep() == 4) {
                return true;
            }
            if (this.getCurrentStep() == 5) {
                return false;
            }
        }
        return true;
    }

    public boolean canFinish() {
        return this.getCurrentStep() > 3 || this.getCurrentStep() == 3 && this.canGoNext();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public SubDataset getCrosstabSubDataset() {
        return this.crosstabSubDataset;
    }

    public void setCrosstabSubDataset(SubDataset crosstabSubDataset) {
        int i;
        this.crosstabSubDataset = crosstabSubDataset;
        this.groupByFieldPanel1.populateBySubdataset(crosstabSubDataset);
        this.groupByFieldPanel2.populateBySubdataset(crosstabSubDataset, true);
        this.groupByFieldPanel3.populateBySubdataset(crosstabSubDataset);
        this.groupByFieldPanel4.populateBySubdataset(crosstabSubDataset, true);
        this.jComboBoxDetailField.removeAllItems();
        for (i = 0; i < crosstabSubDataset.getFields().size(); ++i) {
            this.jComboBoxDetailField.addItem(new WizardFieldObject(crosstabSubDataset.getFields().get(i)));
        }
        for (i = 0; i < crosstabSubDataset.getVariables().size(); ++i) {
            this.jComboBoxDetailField.addItem(new WizardFieldObject(crosstabSubDataset.getVariables().get(i)));
        }
        for (i = 0; i < crosstabSubDataset.getParameters().size(); ++i) {
            this.jComboBoxDetailField.addItem(new WizardFieldObject(crosstabSubDataset.getParameters().get(i)));
        }
        if (this.jComboBoxDetailField.getItemCount() > 0) {
            this.jComboBoxDetailField.setSelectedIndex(0);
        }
    }

    public Vector getStepsPanels() {
        return this.stepsPanels;
    }

    public void setStepsPanels(Vector stepsPanels) {
        this.stepsPanels = stepsPanels;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
        Misc.updateComboBox(this.jComboBoxSubdataset, this.getReport().getSubDatasets(), false);
        this.jComboBoxSubdataset.insertItemAt(report, 0);
        if (this.jComboBoxSubdataset.getItemCount() > 0) {
            this.jComboBoxSubdataset.setSelectedIndex(0);
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public CrosstabReportElement getCrosstabReportElement() {
        return this.crosstabReportElement;
    }

    public void setCrosstabReportElement(CrosstabReportElement crosstabReportElement) {
        this.crosstabReportElement = crosstabReportElement;
    }

    public void applyI18n() {
        this.jCheckBoxPrintGrid.setText(I18n.getString("crosstabWizardDialog.checkBoxPrintGrid", "Show grid lines"));
        this.jCheckBoxTotalColumns.setText(I18n.getString("crosstabWizardDialog.checkBoxTotalColumns", "Add column group totals"));
        this.jCheckBoxTotalRows.setText(I18n.getString("crosstabWizardDialog.checkBoxTotalRows", "Add row group totals"));
        this.jButtonCancel.setText(I18n.getString("crosstabWizardDialog.buttonCancel", "Cancel"));
        this.jButtonFinish.setText(I18n.getString("crosstabWizardDialog.buttonFinish", "Finish"));
        this.jButtonNewSubDataset.setText(I18n.getString("crosstabWizardDialog.buttonNewSubDataset", "Create new subdataset"));
        this.jButtonNext.setText(I18n.getString("crosstabWizardDialog.buttonNext", "Next >"));
        this.jButtonPrev.setText(I18n.getString("crosstabWizardDialog.buttonPrev", "< Prev"));
        this.jLabel1.setText(I18n.getString("crosstabWizardDialog.label1", "Steps"));
        this.jLabel2.setText(I18n.getString("crosstabWizardDialog.label2", "Available subdataset"));
        this.jLabelDetailField.setText(I18n.getString("crosstabWizardDialog.labelDetailField", "Detail field"));
        this.jLabelDetailField1.setText(I18n.getString("crosstabWizardDialog.labelDetailField1", "Function"));
        this.jLabelStep1.setText(I18n.getString("crosstabWizardDialog.labelStep1", "1. SubDataset selection"));
        this.jLabelStep2.setText(I18n.getString("crosstabWizardDialog.labelStep2", "2. Rows"));
        this.jLabelStep3.setText(I18n.getString("crosstabWizardDialog.labelStep3", "3. Columns"));
        this.jLabelStep4.setText(I18n.getString("crosstabWizardDialog.labelStep4", "4. Detail"));
        this.jLabelStep5.setText(I18n.getString("crosstabWizardDialog.labelStep5", "5. Layout"));
        this.jLabelStep6.setText(I18n.getString("crosstabWizardDialog.labelStep6", "6. Finish"));
        this.jLabelStepDescription.setText(I18n.getString("crosstabWizardDialog.labelStepDescription", "Steps"));
        this.jLabelResult.setText("<html>" + I18n.getString("crosstabWizardDialog.textArea1", "You have successfully entered all the required information to\ncreate a crosstab.\n\nTo save this settings, click Finish"));
        Font f = this.jLabelResult.getFont();
        this.jLabelResult.setFont(new Font(f.getName(), f.getStyle(), f.getSize() + 2));
        this.groupByFieldPanel1.setTitle(I18n.getString("crosstabWizardDialog.groupByFieldPanel1.title", "Row group 1"));
        this.groupByFieldPanel2.setTitle(I18n.getString("crosstabWizardDialog.groupByFieldPanel2.title", "Row group 2"));
        this.groupByFieldPanel3.setTitle(I18n.getString("crosstabWizardDialog.groupByFieldPanel3.title", "Column group 1"));
        this.groupByFieldPanel4.setTitle(I18n.getString("crosstabWizardDialog.groupByFieldPanel4.title", "Column group 2"));
    }
}

