/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.ConditionedStyle;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.JasperTemplate;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.TemplateStyle;
import it.businesslogic.ireport.UndefinedStyle;
import it.businesslogic.ireport.gui.ExpressionEditor;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener;
import it.businesslogic.ireport.gui.event.StyleChangedEvent;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.FontSheetProperty;
import it.businesslogic.ireport.gui.sheet.PatternSheetProperty;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.gui.style.JPanelStyleSample;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StyleDialog
extends JDialog
implements SheetPropertyValueChangedListener {
    private boolean libraryStyle = false;
    private JasperTemplate jasperTemplate = null;
    private boolean readOnly = false;
    private Style style = null;
    private Style masterStyle = null;
    private Style editingStyle = null;
    private boolean init = false;
    JPanelStyleSample panelSample = new JPanelStyleSample();
    private CategorySheetPanel sheetPanel = null;
    private IReportFont ireportFont = null;
    private Report currentReport = null;
    private JButton jButtonAddCondition;
    private JButton jButtonCancel;
    private JButton jButtonDownCondition;
    private JButton jButtonModifyCondition;
    private JButton jButtonOK;
    private JButton jButtonRemoveCondition;
    private JButton jButtonUpCondition;
    private JList jConditionsList;
    private JLabel jLabelSample;
    private JLabel jLabelStyleConditions;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelConditions;
    private JPanel jPanelProperties;
    private JPanel jPanelSample;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private int dialogResult;
    private int openCondition = -1;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.jButtonOK.setEnabled(!readOnly);
    }

    public StyleDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public StyleDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.style = new Style();
        this.setMasterStyle(this.style);
        this.applyI18n();
        this.pack();
        Misc.centerFrame(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, -1, -1, -1);
        this.sheetPanel = new CategorySheetPanel();
        this.sheetPanel.addSheetPropertyValueChangedListener(this);
        this.jPanelProperties.add((Component)this.sheetPanel, gridBagConstraints);
        String category_name = I18n.getString("styleDialog.tabStyle", "Style");
        SheetProperty customizerClassProperty = new SheetProperty("name", I18n.getString("styleDialog.sheetProperty.customizerClass", "Style name"), 0);
        this.sheetPanel.addSheetProperty(category_name, customizerClassProperty);
        SheetProperty isDefaultProperty = new SheetProperty("isDefault", I18n.getString("styleDialog.sheetProperty.isDefault", "Default style"), 4);
        this.sheetPanel.addSheetProperty(category_name, isDefaultProperty);
        ComboBoxSheetProperty styleProperty = new ComboBoxSheetProperty("style", I18n.getString("styleDialog.sheetProperty.style", "Parent style"));
        this.sheetPanel.addSheetProperty(category_name, styleProperty);
        ((JComboBox)styleProperty.getEditor()).setEditable(true);
        category_name = I18n.getString("styleDialog.tabCommon", "Common");
        SheetProperty modeProperty = new SheetProperty("mode", I18n.getString("styleDialog.sheetProperty.mode", "Mode"), 2);
        modeProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.mode.default", "Default")), new Tag("Opaque", I18n.getString("styleDialog.sheetProperty.mode.opaque", "Opaque")), new Tag("Transparent", I18n.getString("styleDialog.sheetProperty.mode.transparent", "Transparent"))});
        this.sheetPanel.addSheetProperty(category_name, modeProperty);
        SheetProperty forecolorProperty = new SheetProperty("forecolor", I18n.getString("styleDialog.sheetProperty.forecolor", "Forecolor"), 3);
        forecolorProperty.setValue(null);
        this.sheetPanel.addSheetProperty(category_name, forecolorProperty);
        SheetProperty backcolorProperty = new SheetProperty("backcolor", I18n.getString("styleDialog.sheetProperty.backcolor", "Backcolor"), 3);
        backcolorProperty.setValue(null);
        this.sheetPanel.addSheetProperty(category_name, backcolorProperty);
        category_name = I18n.getString("styleDialog.tabGraphics", "Graphics");
        SheetProperty penProperty = new SheetProperty("pen", I18n.getString("styleDialog.sheetProperty.pen", "Pen"), 2);
        penProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.pen.default", "Default")), new Tag("Thin", I18n.getString("styleDialog.sheetProperty.pen.thin", "Thin")), new Tag("1Point", I18n.getString("styleDialog.sheetProperty.pen.1Point", "1Point")), new Tag("2Point", I18n.getString("styleDialog.sheetProperty.pen.2Point", "2Point")), new Tag("4Point", I18n.getString("styleDialog.sheetProperty.pen.4Point", "4Point")), new Tag("Dotted", I18n.getString("styleDialog.sheetProperty.pen.dotted", "Dotted"))});
        this.sheetPanel.addSheetProperty(category_name, penProperty);
        SheetProperty fillProperty = new SheetProperty("fill", I18n.getString("styleDialog.sheetProperty.fill", "Fill"), 2);
        fillProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.fill.default", "Default")), new Tag("Solid", I18n.getString("styleDialog.sheetProperty.fill.solid", "Solid"))});
        this.sheetPanel.addSheetProperty(category_name, fillProperty);
        SheetProperty radiusProperty = new SheetProperty("radius", I18n.getString("styleDialog.sheetProperty.radius", "Radius"), 6);
        this.sheetPanel.addSheetProperty(category_name, radiusProperty);
        SheetProperty scaleImageProperty = new SheetProperty("scaleImage", I18n.getString("styleDialog.sheetProperty.scaleImage", "Scale image"), 2);
        scaleImageProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.scaleImage.default", "Default")), new Tag("Clip", I18n.getString("styleDialog.sheetProperty.scaleImage.clip", "Clip")), new Tag("FillFrame", I18n.getString("styleDialog.sheetProperty.scaleImage.fillFrame", "FillFrame")), new Tag("RetainShape", I18n.getString("styleDialog.sheetProperty.scaleImage.retainShape", "RetainShape"))});
        this.sheetPanel.addSheetProperty(category_name, scaleImageProperty);
        SheetProperty hAlignProperty = new SheetProperty("hAlign", I18n.getString("styleDialog.sheetProperty.hAlign", "Horizontal align"), 2);
        hAlignProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.hAlign.default", "Default")), new Tag("Left", I18n.getString("styleDialog.sheetProperty.hAlign.left", "Left")), new Tag("Center", I18n.getString("styleDialog.sheetProperty.hAlign.center", "Center")), new Tag("Right", I18n.getString("styleDialog.sheetProperty.hAlign.right", "Right")), new Tag("Justified", I18n.getString("styleDialog.sheetProperty.hAlign.justified", "Justified"))});
        this.sheetPanel.addSheetProperty(category_name, hAlignProperty);
        SheetProperty vAlignProperty = new SheetProperty("vAlign", I18n.getString("styleDialog.sheetProperty.vAlign", "Vertical align"), 2);
        vAlignProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.vAlign.default", "Default")), new Tag("Top", I18n.getString("styleDialog.sheetProperty.vAlign.top", "Top")), new Tag("Middle", I18n.getString("styleDialog.sheetProperty.vAlign.middle", "Middle")), new Tag("Bottom", I18n.getString("styleDialog.sheetProperty.vAlign.bottom", "Bottom"))});
        this.sheetPanel.addSheetProperty(category_name, vAlignProperty);
        category_name = I18n.getString("styleDialog.tabBorderAndPadding", "Border and padding");
        SheetProperty borderProperty = new SheetProperty("border", I18n.getString("styleDialog.sheetProperty.border", "Border"), 2);
        borderProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.border.default", "Default")), new Tag("Thin", I18n.getString("styleDialog.sheetProperty.border.thin", "Thin")), new Tag("1Point", I18n.getString("styleDialog.sheetProperty.border.1Point", "1Point")), new Tag("2Point", I18n.getString("styleDialog.sheetProperty.border.2Point", "2Point")), new Tag("4Point", I18n.getString("styleDialog.sheetProperty.border.4Point", "4Point")), new Tag("Dotted", I18n.getString("styleDialog.sheetProperty.border.dotted", "Dotted"))});
        this.sheetPanel.addSheetProperty(category_name, borderProperty);
        SheetProperty borderColorProperty = new SheetProperty("borderColor", I18n.getString("styleDialog.sheetProperty.borderColor", "Border color"), 3);
        this.sheetPanel.addSheetProperty(category_name, borderColorProperty);
        SheetProperty paddingProperty = new SheetProperty("padding", I18n.getString("styleDialog.sheetProperty.padding", "Padding"), 6);
        this.sheetPanel.addSheetProperty(category_name, paddingProperty);
        SheetProperty topBorderProperty = new SheetProperty("topBorder", I18n.getString("styleDialog.sheetProperty.topBorder", "Top border"), 2);
        topBorderProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.topBorder.default", "Default")), new Tag("Thin", I18n.getString("styleDialog.sheetProperty.topBorder.thin", "Thin")), new Tag("1Point", I18n.getString("styleDialog.sheetProperty.topBorder.1Point", "1Point")), new Tag("2Point", I18n.getString("styleDialog.sheetProperty.topBorder.2Point", "2Point")), new Tag("4Point", I18n.getString("styleDialog.sheetProperty.topBorder.4Point", "4Point")), new Tag("Dotted", I18n.getString("styleDialog.sheetProperty.topBorder.dotted", "Dotted"))});
        this.sheetPanel.addSheetProperty(category_name, topBorderProperty);
        SheetProperty topBorderColorProperty = new SheetProperty("topBorderColor", I18n.getString("styleDialog.sheetProperty.topBorderColor", "Top border color"), 3);
        this.sheetPanel.addSheetProperty(category_name, topBorderColorProperty);
        SheetProperty topPaddingProperty = new SheetProperty("topPadding", I18n.getString("styleDialog.sheetProperty.topPadding", "Top padding"), 6);
        this.sheetPanel.addSheetProperty(category_name, topPaddingProperty);
        SheetProperty leftBorderProperty = new SheetProperty("leftBorder", I18n.getString("styleDialog.sheetProperty.leftBorder", "Left border"), 2);
        leftBorderProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.leftBorder.default", "Default")), new Tag("Thin", I18n.getString("styleDialog.sheetProperty.leftBorder.thin", "Thin")), new Tag("1Point", I18n.getString("styleDialog.sheetProperty.leftBorder.1Point", "1Point")), new Tag("2Point", I18n.getString("styleDialog.sheetProperty.leftBorder.2Point", "2Point")), new Tag("4Point", I18n.getString("styleDialog.sheetProperty.leftBorder.4Point", "4Point")), new Tag("Dotted", I18n.getString("styleDialog.sheetProperty.leftBorder.dotted", "Dotted"))});
        this.sheetPanel.addSheetProperty(category_name, leftBorderProperty);
        SheetProperty leftBorderColorProperty = new SheetProperty("leftBorderColor", I18n.getString("styleDialog.sheetProperty.leftBorderColor", "Left border color"), 3);
        this.sheetPanel.addSheetProperty(category_name, leftBorderColorProperty);
        SheetProperty leftPaddingProperty = new SheetProperty("leftPadding", I18n.getString("styleDialog.sheetProperty.leftPadding", "Left padding"), 6);
        this.sheetPanel.addSheetProperty(category_name, leftPaddingProperty);
        SheetProperty bottomBorderProperty = new SheetProperty("bottomBorder", I18n.getString("styleDialog.sheetProperty.bottomBorder", "Bottom border"), 2);
        bottomBorderProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.leftBorder.default", "Default")), new Tag("Thin", I18n.getString("styleDialog.sheetProperty.leftBorder.thin", "Thin")), new Tag("1Point", I18n.getString("styleDialog.sheetProperty.leftBorder.1Point", "1Point")), new Tag("2Point", I18n.getString("styleDialog.sheetProperty.leftBorder.2Point", "2Point")), new Tag("4Point", I18n.getString("styleDialog.sheetProperty.leftBorder.4Point", "4Point")), new Tag("Dotted", I18n.getString("styleDialog.sheetProperty.leftBorder.dotted", "Dotted"))});
        this.sheetPanel.addSheetProperty(category_name, bottomBorderProperty);
        SheetProperty bottomBorderColorProperty = new SheetProperty("bottomBorderColor", I18n.getString("styleDialog.sheetProperty.bottomBorderColor", "Bottom border color"), 3);
        this.sheetPanel.addSheetProperty(category_name, bottomBorderColorProperty);
        SheetProperty bottomPaddingProperty = new SheetProperty("bottomPadding", I18n.getString("styleDialog.sheetProperty.bottomPadding", "Bottom padding"), 6);
        this.sheetPanel.addSheetProperty(category_name, bottomPaddingProperty);
        SheetProperty rightBorderProperty = new SheetProperty("rightBorder", I18n.getString("styleDialog.sheetProperty.rightBorder", "Right border"), 2);
        rightBorderProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.rightBorder.default", "Default")), new Tag("Thin", I18n.getString("styleDialog.sheetProperty.rightBorder.thin", "Thin")), new Tag("1Point", I18n.getString("styleDialog.sheetProperty.rightBorder.1Point", "1Point")), new Tag("2Point", I18n.getString("styleDialog.sheetProperty.rightBorder.2Point", "2Point")), new Tag("4Point", I18n.getString("styleDialog.sheetProperty.rightBorder.4Point", "4Point")), new Tag("Dotted", I18n.getString("styleDialog.sheetProperty.rightBorder.dotted", "Dotted"))});
        this.sheetPanel.addSheetProperty(category_name, rightBorderProperty);
        SheetProperty rightBorderColorProperty = new SheetProperty("rightBorderColor", I18n.getString("styleDialog.sheetProperty.rightBorderColor", "Right border color"), 3);
        this.sheetPanel.addSheetProperty(category_name, rightBorderColorProperty);
        SheetProperty rightPaddingProperty = new SheetProperty("rightPadding", I18n.getString("styleDialog.sheetProperty.rightPadding", "Right padding"), 6);
        this.sheetPanel.addSheetProperty(category_name, rightPaddingProperty);
        category_name = I18n.getString("styleDialog.tabTextProperties", "Text properties");
        SheetProperty rotationProperty = new SheetProperty("rotation", I18n.getString("styleDialog.sheetProperty.rotation", "Rotation"), 2);
        rotationProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.rotation.default", "Default")), new Tag("None", I18n.getString("styleDialog.sheetProperty.rotation.none", "None")), new Tag("Left", I18n.getString("styleDialog.sheetProperty.rotation.left", "Left")), new Tag("Right", I18n.getString("styleDialog.sheetProperty.rotation.right", "Right")), new Tag("UpsideDown", I18n.getString("styleDialog.sheetProperty.rotation.upsideDown", "UpsideDown"))});
        this.sheetPanel.addSheetProperty(category_name, rotationProperty);
        PatternSheetProperty patternProperty = new PatternSheetProperty("pattern", I18n.getString("styleDialog.sheetProperty.pattern", "Pattern"));
        this.sheetPanel.addSheetProperty(category_name, patternProperty);
        SheetProperty isBlankWhenNullProperty = new SheetProperty("isBlankWhenNull", I18n.getString("styleDialog.sheetProperty.isBlankWhenNull", "Is Blank when Null"), 4);
        this.sheetPanel.addSheetProperty(category_name, isBlankWhenNullProperty);
        FontSheetProperty theFontSpacingProperty = new FontSheetProperty("style.font", I18n.getString("styleDialog.sheetProperty.theFontSpacing", "Font"));
        theFontSpacingProperty.setFontMode(3);
        this.sheetPanel.addSheetProperty(category_name, theFontSpacingProperty);
        SheetProperty lineSpacingProperty = new SheetProperty("lineSpacing", I18n.getString("styleDialog.sheetProperty.lineSpacing", "Line spacing"), 2);
        lineSpacingProperty.setTags(new Tag[]{new Tag(null, I18n.getString("styleDialog.sheetProperty.lineSpacing.default", "Default")), new Tag("Single", I18n.getString("styleDialog.sheetProperty.lineSpacing.single", "Single")), new Tag("1_1_2", I18n.getString("styleDialog.sheetProperty.lineSpacing.1_1_2", "1_1_2")), new Tag("Double", I18n.getString("styleDialog.sheetProperty.lineSpacing.double", "Double"))});
        this.sheetPanel.addSheetProperty(category_name, lineSpacingProperty);
        SheetProperty isBoldProperty = new SheetProperty("isBold", I18n.getString("styleDialog.sheetProperty.isBold", "Bold"), 4);
        this.sheetPanel.addSheetProperty(category_name, isBoldProperty);
        SheetProperty isItalicProperty = new SheetProperty("isItalic", I18n.getString("styleDialog.sheetProperty.isItalic", "Italic"), 4);
        this.sheetPanel.addSheetProperty(category_name, isItalicProperty);
        SheetProperty isUnderlineProperty = new SheetProperty("isUnderline", I18n.getString("styleDialog.sheetProperty.isUnderline", "Underline"), 4);
        this.sheetPanel.addSheetProperty(category_name, isUnderlineProperty);
        SheetProperty isStrikeThroughProperty = new SheetProperty("isStrikeThrough", I18n.getString("styleDialog.sheetProperty.isStrikeThrough", "StrikeThrough"), 4);
        this.sheetPanel.addSheetProperty(category_name, isStrikeThroughProperty);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.jPanelSample.add((Component)this.panelSample, gridBagConstraints);
        SheetProperty isStyledTextProperty = new SheetProperty("isStyledText", I18n.getString("styleDialog.sheetProperty.isStyledText", "Is Styled Text"), 4);
        this.sheetPanel.addSheetProperty(category_name, isStyledTextProperty);
        this.sheetPanel.recreateSheet();
        this.sheetPanel.collapseCategory(I18n.getString("styleDialog.tabBorderAndPadding", "Border and padding"));
        this.updateStyleValues();
        this.jConditionsList.setModel(new DefaultListModel());
        this.jConditionsList.setSelectionMode(0);
        ((DefaultListModel)this.jConditionsList.getModel()).addElement(I18n.getString("styleDialog.conditionsList.default", "Default"));
        this.jConditionsList.setSelectedIndex(0);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                StyleDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanelProperties = new JPanel();
        this.jPanelConditions = new JPanel();
        this.jLabelStyleConditions = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jConditionsList = new JList();
        this.jPanel2 = new JPanel();
        this.jButtonAddCondition = new JButton();
        this.jButtonModifyCondition = new JButton();
        this.jButtonRemoveCondition = new JButton();
        this.jButtonUpCondition = new JButton();
        this.jButtonDownCondition = new JButton();
        this.jLabelSample = new JLabel();
        this.jPanelSample = new JPanel();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify Style");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StyleDialog.this.closeDialog(evt);
            }

            public void windowOpened(WindowEvent evt) {
                StyleDialog.this.formWindowOpened(evt);
            }
        });
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanelProperties.setLayout(new GridBagLayout());
        this.jPanelProperties.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelProperties.setMinimumSize(new Dimension(100, 4));
        this.jPanelProperties.setPreferredSize(new Dimension(320, 470));
        this.jSplitPane1.setLeftComponent(this.jPanelProperties);
        this.jPanelConditions.setLayout(new GridBagLayout());
        this.jPanelConditions.setMinimumSize(new Dimension(100, 10));
        this.jPanelConditions.setPreferredSize(new Dimension(200, 10));
        this.jLabelStyleConditions.setText("Style conditions");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelConditions.add((Component)this.jLabelStyleConditions, gridBagConstraints);
        this.jConditionsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                StyleDialog.this.jConditionsListValueChanged(evt);
            }
        });
        this.jConditionsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StyleDialog.this.jConditionsListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jConditionsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelConditions.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButtonAddCondition.setText("Add");
        this.jButtonAddCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonAddCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonAddConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonAddCondition, gridBagConstraints);
        this.jButtonModifyCondition.setText("Modify");
        this.jButtonModifyCondition.setEnabled(false);
        this.jButtonModifyCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonModifyCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonModifyConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonModifyCondition, gridBagConstraints);
        this.jButtonRemoveCondition.setText("Remove");
        this.jButtonRemoveCondition.setEnabled(false);
        this.jButtonRemoveCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonRemoveCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonRemoveConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonRemoveCondition, gridBagConstraints);
        this.jButtonUpCondition.setText("up");
        this.jButtonUpCondition.setEnabled(false);
        this.jButtonUpCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonUpCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonUpConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonUpCondition, gridBagConstraints);
        this.jButtonDownCondition.setText("Down");
        this.jButtonDownCondition.setEnabled(false);
        this.jButtonDownCondition.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonDownCondition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonDownConditionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonDownCondition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelConditions.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabelSample.setText("Sample");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelConditions.add((Component)this.jLabelSample, gridBagConstraints);
        this.jPanelSample.setLayout(new GridBagLayout());
        this.jPanelSample.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelSample.setMinimumSize(new Dimension(100, 80));
        this.jPanelSample.setPreferredSize(new Dimension(14, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelConditions.add((Component)this.jPanelSample, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanelConditions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSplitPane1, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void formWindowOpened(WindowEvent evt) {
        if (this.openCondition >= 0) {
            try {
                if (this.jConditionsList.getModel().getSize() > this.openCondition + 1) {
                    this.jConditionsList.setSelectedIndex(this.openCondition + 1);
                    this.jButtonModifyConditionActionPerformed(new ActionEvent(this.jButtonModifyCondition, 0, ""));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jButtonDownConditionActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jConditionsList.getModel();
        this.setInit(true);
        int i = this.jConditionsList.getSelectedIndex();
        Object cs = this.jConditionsList.getSelectedValue();
        dlm.removeElementAt(i);
        dlm.insertElementAt(cs, i + 1);
        this.jConditionsList.setSelectedIndex(i + 1);
        this.jButtonUpCondition.setEnabled(true);
        if (i == dlm.size() - 2) {
            this.jButtonDownCondition.setEnabled(false);
        }
        this.setInit(false);
    }

    private void jButtonUpConditionActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jConditionsList.getModel();
        this.setInit(true);
        int i = this.jConditionsList.getSelectedIndex();
        Object cs = this.jConditionsList.getSelectedValue();
        dlm.removeElementAt(i);
        dlm.insertElementAt(cs, i - 1);
        this.jConditionsList.setSelectedIndex(i - 1);
        if (i == 2) {
            this.jButtonUpCondition.setEnabled(false);
        }
        this.jButtonDownCondition.setEnabled(true);
        this.setInit(false);
    }

    private void jButtonRemoveConditionActionPerformed(ActionEvent evt) {
        if (this.jConditionsList.getSelectedIndex() == 0) {
            return;
        }
        int i = this.jConditionsList.getSelectedIndex();
        this.jConditionsList.setSelectedIndex(i - 1);
        ((DefaultListModel)this.jConditionsList.getModel()).remove(i);
    }

    private void jButtonModifyConditionActionPerformed(ActionEvent evt) {
        String exp;
        if (this.jConditionsList.getSelectedIndex() == 0) {
            return;
        }
        ConditionedStyle s = (ConditionedStyle)this.jConditionsList.getSelectedValue();
        String expression = s.getCondition();
        ExpressionEditor ed = new ExpressionEditor();
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
            ed.setSubDataset(report);
            Vector v = report.getElements();
            for (int i = 0; i < v.size(); ++i) {
                ReportElement re = (ReportElement)v.elementAt(i);
                if (!(re instanceof CrosstabReportElement)) continue;
                ed.addCrosstabReportElement((CrosstabReportElement)re);
            }
        } else {
            ed.setSubDataset(new SubDataset());
        }
        ed.setExpression(expression);
        ed.setVisible(true);
        if (ed.getDialogResult() == 0 && (exp = ed.getExpression()).trim().length() > 0) {
            s.setCondition(exp.trim());
            this.jConditionsList.updateUI();
        }
    }

    private void jConditionsListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonModifyConditionActionPerformed(null);
            }
        }
    }

    private void jButtonAddConditionActionPerformed(ActionEvent evt) {
        String exp;
        ExpressionEditor ed = new ExpressionEditor();
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
            ed.setSubDataset(report);
            Vector v = report.getElements();
            for (int i = 0; i < v.size(); ++i) {
                ReportElement re = (ReportElement)v.elementAt(i);
                if (!(re instanceof CrosstabReportElement)) continue;
                ed.addCrosstabReportElement((CrosstabReportElement)re);
            }
        } else {
            ed.setSubDataset(new SubDataset());
        }
        ed.setVisible(true);
        if (ed.getDialogResult() == 0 && (exp = ed.getExpression()).trim().length() > 0) {
            this.saveCurrentStyle();
            ConditionedStyle s = new ConditionedStyle(this.getMasterStyle());
            s.setConditionedStyles(new Vector());
            s.setCondition(exp.trim());
            DefaultListModel dlm = (DefaultListModel)this.jConditionsList.getModel();
            dlm.addElement(s);
            this.jConditionsList.setSelectedValue(s, true);
        }
    }

    private void jConditionsListValueChanged(ListSelectionEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.saveCurrentStyle();
        if (this.jConditionsList.getSelectedIndex() == 0) {
            this.jButtonModifyCondition.setEnabled(false);
            this.jButtonRemoveCondition.setEnabled(false);
            this.jButtonUpCondition.setEnabled(false);
            this.jButtonDownCondition.setEnabled(false);
            this.setStyle(this.getMasterStyle(), false);
        } else {
            this.jButtonModifyCondition.setEnabled(true);
            this.jButtonRemoveCondition.setEnabled(true);
            this.jButtonUpCondition.setEnabled(this.jConditionsList.getSelectedIndex() > 1);
            this.jButtonDownCondition.setEnabled(this.jConditionsList.getSelectedIndex() < ((DefaultListModel)this.jConditionsList.getModel()).size() - 1);
            this.setStyle((Style)this.jConditionsList.getSelectedValue(), true);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.saveCurrentStyle();
        String newName = this.getMasterStyle().getAttributeString("name", "");
        if (newName.trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.styleDialog.notValidName", "Please insert a valid name for the style!"), I18n.getString("messages.styleDialog.notValidNameCaption", "Invalid name!"), 2);
            this.jConditionsList.setSelectedIndex(0);
            return;
        }
        Enumeration<Object> e = null;
        e = this.jasperTemplate != null ? new Vector<TemplateStyle>(this.jasperTemplate.getStyles()).elements() : (this.isLibraryStyle() ? MainFrame.getMainInstance().getStyleLibrarySet().elements() : MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().elements());
        while (e.hasMoreElements()) {
            Style st = (Style)e.nextElement();
            if (!st.getAttributeString("name", "").equals(newName) || st == this.getEditingStyle()) continue;
            JOptionPane.showMessageDialog(this, "The name \"" + newName + "\" is already in use!\nPlease change it.", "Invalid name!", 2);
            return;
        }
        DefaultListModel dlm = (DefaultListModel)this.jConditionsList.getModel();
        Vector conditionedStyles = new Vector();
        for (int k = 1; k < dlm.size(); ++k) {
            conditionedStyles.add(dlm.getElementAt(k));
        }
        this.getMasterStyle().setConditionedStyles(conditionedStyles);
        String oldName = "";
        boolean newStyle = false;
        if (this.getEditingStyle() == null) {
            newStyle = true;
            this.setEditingStyle(this.getMasterStyle());
            if (!this.isLibraryStyle() && this.jasperTemplate == null) {
                MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().add(this.getMasterStyle());
            } else if (this.jasperTemplate == null) {
                MainFrame.getMainInstance().getStyleLibrarySet().add(this.getMasterStyle());
            }
        } else {
            oldName = this.getEditingStyle().getAttributeString("name", "");
            this.getEditingStyle().getAttributes().clear();
            this.getEditingStyle().copyStyleFrom(this.getMasterStyle());
        }
        if (!this.isLibraryStyle() || this.jasperTemplate == null) {
            MainFrame.getMainInstance().getActiveReportFrame().getReport().fireStyleChangedListenerStyleChanged(new StyleChangedEvent(MainFrame.getMainInstance().getActiveReportFrame().getReport(), newStyle ? 0 : 1, this.getEditingStyle(), this.getEditingStyle()));
        }
        this.style = this.getEditingStyle();
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public CategorySheetPanel getSheetPanel() {
        return this.sheetPanel;
    }

    public void setSheetPanel(CategorySheetPanel sheetPanel) {
        this.sheetPanel = sheetPanel;
    }

    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (evt.getPropertyName() != null && evt.getPropertyName().equals("style.font")) {
            this.setIreportFont((IReportFont)evt.getNewValue());
            boolean initNow = this.isInit();
            this.setInit(true);
            if (this.getIreportFont() != null) {
                HashMap hashMap = this.getIreportFont().getBeanProperties();
                this.getIreportFont();
                this.sheetPanel.setPropertyValue("isBold", hashMap.get("bold"));
                HashMap hashMap2 = this.getIreportFont().getBeanProperties();
                this.getIreportFont();
                this.sheetPanel.setPropertyValue("isItalic", hashMap2.get("italic"));
                HashMap hashMap3 = this.getIreportFont().getBeanProperties();
                this.getIreportFont();
                this.sheetPanel.setPropertyValue("isStrikeThrough", hashMap3.get("strikeTrought"));
                HashMap hashMap4 = this.getIreportFont().getBeanProperties();
                this.getIreportFont();
                this.sheetPanel.setPropertyValue("isUnderline", hashMap4.get("underline"));
            } else {
                this.sheetPanel.setPropertyValue("isBold", null);
                this.sheetPanel.setPropertyValue("isItalic", null);
                this.sheetPanel.setPropertyValue("isStrikeThrough", null);
                this.sheetPanel.setPropertyValue("isUnderline", null);
            }
            this.setInit(initNow);
        } else if (evt.getPropertyName() != null && evt.getPropertyName().equals("isBold")) {
            IReportFont ifont = this.getIreportFont();
            ifont.getBeanProperties().put("bold", evt.getNewValue());
            this.sheetPanel.setPropertyValue("style.font", ifont);
        } else if (evt.getPropertyName() != null && evt.getPropertyName().equals("isItalic")) {
            IReportFont ifont = this.getIreportFont();
            ifont.getBeanProperties().put("italic", evt.getNewValue());
            this.sheetPanel.setPropertyValue("style.font", ifont);
        } else if (evt.getPropertyName() != null && evt.getPropertyName().equals("isUnderline")) {
            IReportFont ifont = this.getIreportFont();
            ifont.getBeanProperties().put("underline", evt.getNewValue());
            this.sheetPanel.setPropertyValue("style.font", ifont);
        } else if (evt.getPropertyName() != null && evt.getPropertyName().equals("isStrikeThrough")) {
            IReportFont ifont = this.getIreportFont();
            ifont.getBeanProperties().put("strikeTrought", evt.getNewValue());
            this.sheetPanel.setPropertyValue("style.font", ifont);
        }
        if (!this.isInit() && this.panelSample != null && this.panelSample.getStyle() != null) {
            Vector properties = this.sheetPanel.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                SheetProperty sp = (SheetProperty)properties.get(i);
                this.panelSample.getStyle().getAttributes().put(sp.getKeyName(), sp.getValue());
            }
            this.panelSample.invalidate();
            this.panelSample.repaint();
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void updateStyleValues() {
        this.setInit(true);
        this.sheetPanel.setPropertyValue("name", this.getStyle().getAttribute("name"));
        this.sheetPanel.setPropertyValue("backcolor", this.getStyle().getAttribute("backcolor"));
        this.sheetPanel.setPropertyValue("borderColor", this.getStyle().getAttribute("borderColor"));
        this.sheetPanel.setPropertyValue("border", this.getStyle().getAttribute("border"));
        this.sheetPanel.setPropertyValue("bottomBorderColor", this.getStyle().getAttribute("bottomBorderColor"));
        this.sheetPanel.setPropertyValue("bottomBorder", this.getStyle().getAttribute("bottomBorder"));
        this.sheetPanel.setPropertyValue("bottomPadding", this.getStyle().getAttribute("bottomPadding"));
        this.sheetPanel.setPropertyValue("fill", this.getStyle().getAttribute("fill"));
        this.sheetPanel.setPropertyValue("forecolor", this.getStyle().getAttribute("forecolor"));
        this.sheetPanel.setPropertyValue("hAlign", this.getStyle().getAttribute("hAlign"));
        this.sheetPanel.setPropertyValue("isBlankWhenNull", this.getStyle().getAttribute("isBlankWhenNull"));
        this.sheetPanel.setPropertyValue("isDefault", this.getStyle().getAttribute("isDefault"));
        this.sheetPanel.setPropertyValue("leftBorderColor", this.getStyle().getAttribute("leftBorderColor"));
        this.sheetPanel.setPropertyValue("leftBorder", this.getStyle().getAttribute("leftBorder"));
        this.sheetPanel.setPropertyValue("leftPadding", this.getStyle().getAttribute("leftPadding"));
        this.sheetPanel.setPropertyValue("lineSpacing", this.getStyle().getAttribute("lineSpacing"));
        this.sheetPanel.setPropertyValue("mode", this.getStyle().getAttribute("mode"));
        this.sheetPanel.setPropertyValue("padding", this.getStyle().getAttribute("padding"));
        this.sheetPanel.setPropertyValue("pattern", this.getStyle().getAttribute("pattern"));
        this.sheetPanel.setPropertyValue("pen", this.getStyle().getAttribute("pen"));
        this.sheetPanel.setPropertyValue("radius", this.getStyle().getAttribute("radius"));
        this.sheetPanel.setPropertyValue("rightBorderColor", this.getStyle().getAttribute("rightBorderColor"));
        this.sheetPanel.setPropertyValue("rightBorder", this.getStyle().getAttribute("rightBorder"));
        this.sheetPanel.setPropertyValue("rightPadding", this.getStyle().getAttribute("rightPadding"));
        this.sheetPanel.setPropertyValue("rotation", this.getStyle().getAttribute("rotation"));
        this.sheetPanel.setPropertyValue("scaleImage", this.getStyle().getAttribute("scaleImage"));
        this.sheetPanel.setPropertyValue("style", this.getStyle().getAttribute("style"));
        this.sheetPanel.setPropertyValue("isStyledText", this.getStyle().getAttribute("isStyledText"));
        this.sheetPanel.setPropertyValue("style.font", this.getIreportFont());
        this.sheetPanel.setPropertyValue("topBorderColor", this.getStyle().getAttribute("topBorderColor"));
        this.sheetPanel.setPropertyValue("topBorder", this.getStyle().getAttribute("topBorder"));
        this.sheetPanel.setPropertyValue("topPadding", this.getStyle().getAttribute("topPadding"));
        this.sheetPanel.setPropertyValue("vAlign", this.getStyle().getAttribute("vAlign"));
        this.sheetPanel.setPropertyValue("isBold", this.getStyle().getAttribute("isBold"));
        this.sheetPanel.setPropertyValue("isUnderline", this.getStyle().getAttribute("isUnderline"));
        this.sheetPanel.setPropertyValue("isItalic", this.getStyle().getAttribute("isItalic"));
        this.sheetPanel.setPropertyValue("isStrikeThrough", this.getStyle().getAttribute("isStrikeThrough"));
        this.setInit(false);
    }

    public void setJasperTemplate(JasperTemplate jt) {
        this.jasperTemplate = jt;
        this.jButtonAddCondition.setEnabled(false);
    }

    public void setStyle(Style myStyle) {
        Style copyStyle = new Style(myStyle);
        copyStyle.setName(myStyle.getName());
        this.setMasterStyle(copyStyle);
        if (myStyle instanceof TemplateStyle) {
            this.setJasperTemplate(((TemplateStyle)myStyle).getJasperTemplate());
        } else if (myStyle instanceof UndefinedStyle) {
            this.jButtonAddCondition.setEnabled(false);
        }
        if (myStyle.getAttributeBoolean("isDefault", false)) {
            this.getMasterStyle().getAttributes().put("isDefault", new Boolean(true));
        }
        this.setStyle(this.getMasterStyle(), false);
        this.setEditingStyle(myStyle);
        this.updateParentStylesList();
        this.setInit(true);
        ((DefaultListModel)this.jConditionsList.getModel()).removeAllElements();
        ((DefaultListModel)this.jConditionsList.getModel()).addElement(I18n.getString("styleDialog.conditionsList.default", "Default"));
        for (int i = 0; i < this.getMasterStyle().getConditionedStyles().size(); ++i) {
            ((DefaultListModel)this.jConditionsList.getModel()).addElement(this.getMasterStyle().getConditionedStyles().elementAt(i));
        }
        this.jConditionsList.setSelectedIndex(0);
        this.setInit(false);
    }

    public void updateParentStylesList() {
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            this.currentReport = MainFrame.getMainInstance().getActiveReportFrame().getReport();
            Enumeration enum_styles = this.currentReport.getStyles().elements();
            Vector<Style> tags = new Vector<Style>();
            while (enum_styles.hasMoreElements()) {
                Style s = (Style)enum_styles.nextElement();
                if (s == this.getMasterStyle() || s.getName().equals(this.getMasterStyle().getName())) continue;
                tags.add(s);
            }
            ComboBoxSheetProperty sp = (ComboBoxSheetProperty)this.getSheetPanel().getSheetProperty("style");
            Object s = sp.getValue();
            sp.updateValues(tags, true);
            ((JComboBox)sp.getEditor()).setSelectedItem(s);
        }
    }

    private void setStyle(Style myStyle, boolean conditionalStyle) {
        this.style = myStyle;
        ((SheetProperty)this.sheetPanel.getSheetProperty("name")).setReadOnly(conditionalStyle);
        ((SheetProperty)this.sheetPanel.getSheetProperty("isDefault")).setReadOnly(conditionalStyle);
        ((SheetProperty)this.sheetPanel.getSheetProperty("style")).setReadOnly(conditionalStyle);
        this.setIreportFont(new IReportFont());
        if (myStyle.getAttributes().get("isBold") != null) {
            this.getIreportFont().setBold(myStyle.getAttributeBoolean("isBold", false));
        }
        if (myStyle.getAttributes().get("fontName") != null) {
            this.getIreportFont().setFontName(myStyle.getAttributeString("fontName", this.getIreportFont().getFontName()));
        }
        if (myStyle.getAttributes().get("fontSize") != null) {
            this.getIreportFont().setFontSize(myStyle.getAttributeInteger("fontSize", this.getIreportFont().getFontSize()));
        }
        if (myStyle.getAttributes().get("isItalic") != null) {
            this.getIreportFont().setItalic(myStyle.getAttributeBoolean("isItalic", false));
        }
        if (myStyle.getAttributes().get("isPdfEmbedded") != null) {
            this.getIreportFont().setPdfEmbedded(myStyle.getAttributeBoolean("isPdfEmbedded", false));
        }
        if (myStyle.getAttributes().get("pdfEncoding") != null) {
            this.getIreportFont().setPdfEncoding(myStyle.getAttributeString("pdfEncoding", this.getIreportFont().getPdfEncoding()));
        }
        if (myStyle.getAttributes().get("isStrikeThrough") != null) {
            this.getIreportFont().setStrikeTrought(myStyle.getAttributeBoolean("isStrikeThrough", false));
        }
        if (myStyle.getAttributes().get("pdfFontName") != null) {
            this.getIreportFont().setPDFFontName(myStyle.getAttributeString("pdfFontName", this.getIreportFont().getPDFFontName()));
        }
        if (myStyle.getAttributes().get("isUnderline") != null) {
            this.getIreportFont().setUnderline(myStyle.getAttributeBoolean("isUnderline", false));
        }
        this.updateParentStylesList();
        this.updateStyleValues();
        this.panelSample.setStyle(myStyle);
    }

    public IReportFont getIreportFont() {
        if (this.ireportFont == null) {
            this.ireportFont = new IReportFont();
        }
        return this.ireportFont;
    }

    public void setIreportFont(IReportFont ireportFont) {
        this.ireportFont = ireportFont;
    }

    private Style getMasterStyle() {
        return this.masterStyle;
    }

    private void setMasterStyle(Style masterStyle) {
        this.masterStyle = masterStyle;
    }

    private void saveCurrentStyle() {
        Vector properties = this.sheetPanel.getProperties();
        if (this.getStyle() instanceof ConditionedStyle) {
            String condition = ((ConditionedStyle)this.getStyle()).getCondition();
            this.getStyle().getAttributes().clear();
            ((ConditionedStyle)this.getStyle()).setCondition(condition);
        } else {
            this.getStyle().getAttributes().clear();
        }
        for (int i = 0; i < properties.size(); ++i) {
            SheetProperty sp = (SheetProperty)properties.get(i);
            if (sp.getValue() == null) continue;
            this.getStyle().getAttributes().put(sp.getKeyName(), sp.getValue());
        }
        HashMap hashMap = this.getStyle().getAttributes();
        this.getStyle();
        if (hashMap.get("style") != null) {
            HashMap hashMap2 = this.getStyle().getAttributes();
            this.getStyle();
            if (!(hashMap2.get("style") instanceof Style)) {
                StringBuilder stringBuilder = new StringBuilder().append("");
                HashMap hashMap3 = this.getStyle().getAttributes();
                this.getStyle();
                String sname = stringBuilder.append(hashMap3.get("style")).toString();
                if (sname.trim().length() == 0) {
                    HashMap hashMap4 = this.getStyle().getAttributes();
                    this.getStyle();
                    hashMap4.remove("style");
                } else if (this.currentReport != null) {
                    for (int j = 0; j < this.currentReport.getStyles().size(); ++j) {
                        Style sparent = (Style)this.currentReport.getStyles().elementAt(j);
                        if (!sparent.getName().equals(sname)) continue;
                        HashMap hashMap5 = this.getStyle().getAttributes();
                        this.getStyle();
                        hashMap5.put("style", sparent);
                    }
                }
            }
        }
        Style style = this.getStyle();
        this.getStyle();
        if (style.getAttributeBoolean("isDefault", false) && !this.isLibraryStyle() && !this.isReadOnly() && this.jasperTemplate != null) {
            Enumeration enum_s = MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().elements();
            while (enum_s.hasMoreElements()) {
                Style tmp_s = (Style)enum_s.nextElement();
                if (tmp_s == this.getStyle()) continue;
                HashMap hashMap6 = tmp_s.getAttributes();
                this.getStyle();
                hashMap6.remove("isDefault");
            }
        }
        if (this.ireportFont != null) {
            this.getStyle().getAttributes().put("fontName", this.ireportFont.getBeanProperties().get("fontName"));
            if (this.ireportFont.getBeanProperties().get("fontSize") != null) {
                this.getStyle().getAttributes().put("fontSize", new Integer(this.ireportFont.getFontSize()));
            }
            if (this.ireportFont.getBeanProperties().get("bold") != null) {
                this.getStyle().getAttributes().put("isBold", new Boolean(this.ireportFont.isBold()));
            }
            if (this.ireportFont.getBeanProperties().get("italic") != null) {
                this.getStyle().getAttributes().put("isItalic", new Boolean(this.ireportFont.isItalic()));
            }
            if (this.ireportFont.getBeanProperties().get("underline") != null) {
                this.getStyle().getAttributes().put("isUnderline", new Boolean(this.ireportFont.isUnderline()));
            }
            if (this.ireportFont.getBeanProperties().get("strikeTrought") != null) {
                this.getStyle().getAttributes().put("isStrikeThrough", new Boolean(this.ireportFont.isStrikeTrought()));
            }
            if (this.ireportFont.getBeanProperties().get("pdfEmbedded") != null) {
                this.getStyle().getAttributes().put("isPdfEmbedded", new Boolean(this.ireportFont.isPdfEmbedded()));
            }
            if (this.ireportFont.getBeanProperties().get("PDFFontName") != null) {
                this.getStyle().getAttributes().put("pdfFontName", this.ireportFont.getPDFFontName());
            }
            if (this.ireportFont.getBeanProperties().get("pdfEncoding") != null) {
                this.getStyle().getAttributes().put("pdfEncoding", this.ireportFont.getPdfEncoding());
            }
        }
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public Style getEditingStyle() {
        return this.editingStyle;
    }

    public void setEditingStyle(Style editingStyle) {
        this.editingStyle = editingStyle;
    }

    public boolean isLibraryStyle() {
        return this.libraryStyle;
    }

    public void setLibraryStyle(boolean libraryStyle) {
        this.libraryStyle = libraryStyle;
    }

    public void applyI18n() {
        this.jButtonAddCondition.setText(I18n.getString("styleDialog.buttonAddCondition", "Add"));
        this.jButtonCancel.setText(I18n.getString("styleDialog.buttonCancel", "Cancel"));
        this.jButtonDownCondition.setText(I18n.getString("styleDialog.buttonDownCondition", "Down"));
        this.jButtonModifyCondition.setText(I18n.getString("styleDialog.buttonModifyCondition", "Modify"));
        this.jButtonOK.setText(I18n.getString("styleDialog.buttonOK", "OK"));
        this.jButtonRemoveCondition.setText(I18n.getString("styleDialog.buttonRemoveCondition", "Remove"));
        this.jButtonUpCondition.setText(I18n.getString("styleDialog.buttonUpCondition", "up"));
        this.jLabelSample.setText(I18n.getString("styleDialog.labelSample", "Sample"));
        this.jLabelStyleConditions.setText(I18n.getString("styleDialog.labelStyleConditions", "Style conditions"));
        this.setTitle(I18n.getString("styleDialog.title", "Add/modify style"));
        this.jButtonCancel.setMnemonic(I18n.getString("styleDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOK.setMnemonic(I18n.getString("styleDialog.buttonOKMnemonic", "o").charAt(0));
    }

    public void setOpenCondition(int itemIndex) {
        this.openCondition = itemIndex;
    }
}

