/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Cube;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeAccess {
    private boolean hasRestrictions;
    private Hierarchy[] noAccessHierarchies;
    private Member[] limitedMembers;
    private final List<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
    private final List<Member> memberList = new ArrayList<Member>();
    private final Cube mdxCube;

    public CubeAccess(Cube mdxCube) {
        this.mdxCube = mdxCube;
        this.noAccessHierarchies = null;
        this.limitedMembers = null;
        this.hasRestrictions = false;
    }

    public boolean hasRestrictions() {
        return this.hasRestrictions;
    }

    public Hierarchy[] getNoAccessHierarchies() {
        return this.noAccessHierarchies;
    }

    public Member[] getLimitedMembers() {
        return this.limitedMembers;
    }

    public List<Hierarchy> getNoAccessHierarchyList() {
        return this.hierarchyList;
    }

    public List<Member> getLimitedMemberList() {
        return this.memberList;
    }

    public boolean isHierarchyAllowed(Hierarchy mdxHierarchy) {
        String hierName = mdxHierarchy.getUniqueName();
        if (this.noAccessHierarchies == null || hierName == null) {
            return true;
        }
        for (Hierarchy noAccessHierarchy : this.noAccessHierarchies) {
            if (!hierName.equalsIgnoreCase(noAccessHierarchy.getUniqueName())) continue;
            return false;
        }
        return true;
    }

    public Member getLimitedMemberForHierarchy(Hierarchy mdxHierarchy) {
        String hierName = mdxHierarchy.getUniqueName();
        if (this.limitedMembers == null || hierName == null) {
            return null;
        }
        for (Member limitedMember : this.limitedMembers) {
            Hierarchy limitedHierarchy = limitedMember.getHierarchy();
            if (!hierName.equalsIgnoreCase(limitedHierarchy.getUniqueName())) continue;
            return limitedMember;
        }
        return null;
    }

    public void addGrantCubeSlicer(String sHierarchy, String sMember, boolean bMember) {
        if (bMember) {
            boolean fail = false;
            String[] sMembers = Util.explode(sMember);
            SchemaReader schemaReader = this.mdxCube.getSchemaReader(null);
            Member member = schemaReader.getMemberByUniqueName(sMembers, fail);
            if (member == null) {
                throw MondrianResource.instance().MdxCubeSlicerMemberError.ex(sMember, sHierarchy, this.mdxCube.getUniqueName());
            }
            if (this.getLimitedMemberForHierarchy(member.getHierarchy()) == null) {
                this.memberList.add(member);
            }
        } else {
            boolean fail = false;
            Hierarchy hierarchy = this.mdxCube.lookupHierarchy(sHierarchy, fail);
            if (hierarchy == null) {
                throw MondrianResource.instance().MdxCubeSlicerHierarchyError.ex(sHierarchy, this.mdxCube.getUniqueName());
            }
            this.hierarchyList.add(hierarchy);
        }
    }

    public void normalizeCubeAccess() {
        if (this.memberList.size() > 0) {
            this.limitedMembers = this.memberList.toArray(new Member[this.memberList.size()]);
            this.hasRestrictions = true;
        }
        if (this.hierarchyList.size() > 0) {
            this.noAccessHierarchies = this.hierarchyList.toArray(new Hierarchy[this.hierarchyList.size()]);
            this.hasRestrictions = true;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof CubeAccess)) {
            return false;
        }
        CubeAccess cubeAccess = (CubeAccess)object;
        List<Hierarchy> hierarchyList = cubeAccess.getNoAccessHierarchyList();
        List<Member> limitedMemberList = cubeAccess.getLimitedMemberList();
        if (this.hierarchyList.size() != hierarchyList.size() || this.memberList.size() != limitedMemberList.size()) {
            return false;
        }
        for (Hierarchy o : hierarchyList) {
            if (this.hierarchyList.contains(o)) continue;
            return false;
        }
        for (Member member : limitedMemberList) {
            if (this.memberList.contains(member)) continue;
            return false;
        }
        return true;
    }
}

