/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.EllipseDrawer;
import net.sf.jasperreports.engine.export.draw.FrameDrawer;
import net.sf.jasperreports.engine.export.draw.ImageDrawer;
import net.sf.jasperreports.engine.export.draw.LineDrawer;
import net.sf.jasperreports.engine.export.draw.RectangleDrawer;
import net.sf.jasperreports.engine.export.draw.TextDrawer;

public class DrawVisitor
implements JRVisitor {
    private TextRenderer textRenderer = new TextRenderer(false);
    private ConvertVisitor convertVisitor = null;
    private Graphics2D grx = null;
    private LineDrawer lineDrawer = new LineDrawer();
    private RectangleDrawer rectangleDrawer = new RectangleDrawer();
    private EllipseDrawer ellipseDrawer = new EllipseDrawer();
    private ImageDrawer imageDrawer = new ImageDrawer();
    private TextDrawer textDrawer = new TextDrawer(this.textRenderer);
    private FrameDrawer frameDrawer = new FrameDrawer(null, this.textRenderer);

    public DrawVisitor(JRReport report, Graphics2D grx) {
        this(new ReportConverter(report, true), grx);
    }

    public DrawVisitor(ReportConverter reportConverter, Graphics2D grx) {
        this.convertVisitor = new ConvertVisitor(reportConverter);
        this.setGraphics2D(grx);
        this.frameDrawer.setClip(true);
    }

    public void setGraphics2D(Graphics2D grx) {
        this.grx = grx;
    }

    public void visitBreak(JRBreak breakElement) {
    }

    public void visitChart(JRChart chart) {
        try {
            this.imageDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(chart), -chart.getX(), -chart.getY());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void visitCrosstab(JRCrosstab crosstab) {
        try {
            this.frameDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(crosstab), -crosstab.getX(), -crosstab.getY());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void visitElementGroup(JRElementGroup elementGroup) {
    }

    public void visitEllipse(JREllipse ellipse) {
        this.ellipseDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(ellipse), -ellipse.getX(), -ellipse.getY());
    }

    public void visitFrame(JRFrame frame) {
        try {
            this.frameDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(frame), -frame.getX(), -frame.getY());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void visitImage(JRImage image) {
        try {
            this.imageDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(image), -image.getX(), -image.getY());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void visitLine(JRLine line) {
        this.lineDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(line), -line.getX(), -line.getY());
    }

    public void visitRectangle(JRRectangle rectangle) {
        this.rectangleDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(rectangle), -rectangle.getX(), -rectangle.getY());
    }

    public void visitStaticText(JRStaticText staticText) {
        this.textDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(staticText), -staticText.getX(), -staticText.getY());
    }

    public void visitSubreport(JRSubreport subreport) {
        try {
            this.imageDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(subreport), -subreport.getX(), -subreport.getY());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void visitTextField(JRTextField textField) {
        this.textDrawer.draw(this.grx, this.convertVisitor.getVisitPrintElement(textField), -textField.getX(), -textField.getY());
    }
}

