/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionSnapshot;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.def.AbstractVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.EntityType;

public abstract class ProxyVisitor
extends AbstractVisitor {
    public ProxyVisitor(SessionImplementor session) {
        super(session);
    }

    Object processEntity(Object value, EntityType entityType) throws HibernateException {
        if (value != null) {
            this.getSession().getPersistenceContext().reassociateIfUninitializedProxy(value);
        }
        return null;
    }

    protected static boolean isOwnerUnchanged(CollectionSnapshot snapshot, CollectionPersister persister, Serializable id) {
        return ProxyVisitor.isCollectionSnapshotValid(snapshot) && persister.getRole().equals(snapshot.getRole()) && id.equals(snapshot.getKey());
    }

    private static boolean isCollectionSnapshotValid(CollectionSnapshot snapshot) {
        return snapshot != null && snapshot.getRole() != null && snapshot.getKey() != null;
    }

    protected void reattachCollection(PersistentCollection collection, CollectionSnapshot snapshot) throws HibernateException {
        if (collection.wasInitialized()) {
            this.getSession().getPersistenceContext().addInitializedDetachedCollection(collection, snapshot, this.getSession().getEntityMode());
        } else {
            if (!ProxyVisitor.isCollectionSnapshotValid(snapshot)) {
                throw new HibernateException("could not reassociate uninitialized transient collection");
            }
            this.getSession().getPersistenceContext().addUninitializedDetachedCollection(collection, this.getSession().getFactory().getCollectionPersister(snapshot.getRole()), snapshot.getKey(), this.getSession().getEntityMode());
        }
    }
}

