/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.def.ProxyVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class WrapVisitor
extends ProxyVisitor {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$def$WrapVisitor == null ? (class$org$hibernate$event$def$WrapVisitor = WrapVisitor.class$("org.hibernate.event.def.WrapVisitor")) : class$org$hibernate$event$def$WrapVisitor));
    boolean substitute = false;
    static /* synthetic */ Class class$org$hibernate$event$def$WrapVisitor;

    boolean isSubstitutionRequired() {
        return this.substitute;
    }

    WrapVisitor(SessionImplementor session) {
        super(session);
    }

    Object processCollection(Object collection, CollectionType collectionType) throws HibernateException {
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)collection;
            SessionImplementor session = this.getSession();
            if (coll.setCurrentSession(session)) {
                this.reattachCollection(coll, coll.getCollectionSnapshot());
            }
            return null;
        }
        return this.processArrayOrNewCollection(collection, collectionType);
    }

    final Object processArrayOrNewCollection(Object collection, CollectionType collectionType) throws HibernateException {
        SessionImplementor session = this.getSession();
        if (collection == null) {
            return null;
        }
        CollectionPersister persister = session.getFactory().getCollectionPersister(collectionType.getRole());
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (collectionType.hasHolder(session.getEntityMode())) {
            if (collection == CollectionType.UNFETCHED_COLLECTION) {
                return null;
            }
            PersistentCollection ah = persistenceContext.getCollectionHolder(collection);
            if (ah == null) {
                ah = collectionType.wrap(session, collection);
                persistenceContext.addNewCollection(ah, persister);
                persistenceContext.addCollectionHolder(ah);
            }
            return null;
        }
        PersistentCollection persistentCollection = collectionType.wrap(session, collection);
        persistenceContext.addNewCollection(persistentCollection, persister);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Wrapped collection in role: " + collectionType.getRole()));
        }
        return persistentCollection;
    }

    void processValue(int i, Object[] values, Type[] types) {
        Object result = this.processValue(values[i], types[i]);
        if (result != null) {
            this.substitute = true;
            values[i] = result;
        }
    }

    Object processComponent(Object component, AbstractComponentType componentType) throws HibernateException {
        if (component != null) {
            Object[] values = componentType.getPropertyValues(component, this.getSession());
            Type[] types = componentType.getSubtypes();
            boolean substituteComponent = false;
            for (int i = 0; i < types.length; ++i) {
                Object result = this.processValue(values[i], types[i]);
                if (result == null) continue;
                values[i] = result;
                substituteComponent = true;
            }
            if (substituteComponent) {
                componentType.setPropertyValues(component, values, this.getSession().getEntityMode());
            }
        }
        return null;
    }

    void process(Object object, EntityPersister persister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        Object[] values = persister.getPropertyValues(object, entityMode);
        Type[] types = persister.getPropertyTypes();
        this.processEntityPropertyValues(values, types);
        if (this.isSubstitutionRequired()) {
            persister.setPropertyValues(object, values, entityMode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

