/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.eigenbase.xom.CdataDef;
import org.eigenbase.xom.CommentDef;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.TextDef;
import org.eigenbase.xom.WrapperElementDef;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public abstract class ElementDef
implements NodeDef,
Serializable,
Cloneable {
    static /* synthetic */ Class class$org$eigenbase$xom$DOMWrapper;

    public static Class getElementClass(DOMWrapper dOMWrapper, Class clazz, String string) throws XOMException {
        if (clazz == null) {
            return null;
        }
        if (dOMWrapper.getType() != 2) {
            throw new XOMException("DOMWrapper must be of ELEMENT type.");
        }
        String string2 = dOMWrapper.getTagName();
        if (string == null) {
            string = "";
        } else if (!string2.startsWith(string)) {
            throw new XOMException("Element names must start \"" + string + "\": " + string2 + " is invalid.");
        }
        String string3 = string2.substring(string.length(), string2.length());
        string3 = XOMUtil.capitalize(string3);
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(clazz.getName() + "$" + string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        return clazz2;
    }

    public static NodeDef constructElement(DOMWrapper dOMWrapper, Class clazz) throws XOMException {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != 1 || classArray[0] != (class$org$eigenbase$xom$DOMWrapper == null ? ElementDef.class$("org.eigenbase.xom.DOMWrapper") : class$org$eigenbase$xom$DOMWrapper)) continue;
            constructor = constructorArray[i];
            break;
        }
        if (constructor == null) {
            throw new XOMException("No constructor taking class DOMWrapper could be found in class " + clazz.getName());
        }
        Object[] objectArray = new Object[]{dOMWrapper};
        try {
            return (ElementDef)constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new XOMException("Unable to instantiate object of class " + clazz.getName() + ": " + instantiationException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof XOMException) {
                throw (XOMException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new XOMException("Unexpected exception while instantiating object: " + throwable.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XOMException("Unable to instantiate object of class " + clazz.getName() + ": " + illegalAccessException.getMessage());
        }
    }

    public static NodeDef constructElement(DOMWrapper dOMWrapper, Class clazz, String string) throws XOMException {
        switch (dOMWrapper.getType()) {
            case 2: {
                Class clazz2 = ElementDef.getElementClass(dOMWrapper, clazz, string);
                if (clazz2 == null) {
                    return new WrapperElementDef(dOMWrapper, clazz, string);
                }
                return ElementDef.constructElement(dOMWrapper, clazz2);
            }
            case 3: {
                return new CommentDef(dOMWrapper.getText());
            }
            case 4: {
                return new CdataDef(dOMWrapper.getText());
            }
            case 1: {
                return new TextDef(dOMWrapper.getText());
            }
        }
        throw new XOMException("Unknown type: " + dOMWrapper.getText());
    }

    public void displayXML(XMLOutput xMLOutput, int n) {
    }

    public void displayXML(XMLOutput xMLOutput) {
        this.displayXML(xMLOutput, 0);
    }

    public boolean displayDiff(ElementDef elementDef, PrintWriter printWriter, int n) {
        return false;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public int getType() {
        return 2;
    }

    public String getText() {
        return null;
    }

    protected static void displayIndent(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.print("   ");
        }
    }

    protected static void displayString(PrintWriter printWriter, String string, String string2, int n) {
        ElementDef.displayIndent(printWriter, n);
        if (string2 == null) {
            printWriter.println(string + ": null");
        } else {
            printWriter.println(string + ": \"" + string2 + "\"");
        }
    }

    protected static void displayAttribute(PrintWriter printWriter, String string, Object object, int n) {
        ElementDef.displayIndent(printWriter, n);
        if (object == null) {
            printWriter.println(string + " = null");
        } else {
            printWriter.println(string + " = \"" + object.toString() + "\"");
        }
    }

    protected static void displayElement(PrintWriter printWriter, String string, ElementDef elementDef, int n) {
        ElementDef.displayIndent(printWriter, n);
        if (elementDef == null) {
            printWriter.println(string + ": null");
        } else {
            printWriter.print(string + ": ");
            elementDef.display(printWriter, n);
        }
    }

    protected static void displayElementArray(PrintWriter printWriter, String string, NodeDef[] nodeDefArray, int n) {
        ElementDef.displayIndent(printWriter, n);
        if (nodeDefArray == null) {
            printWriter.println(string + ": null array");
        } else {
            printWriter.println(string + ": array of " + nodeDefArray.length + " values");
            for (int i = 0; i < nodeDefArray.length; ++i) {
                ElementDef.displayIndent(printWriter, n);
                if (nodeDefArray[i] == null) {
                    printWriter.println(string + "[" + i + "]: null");
                    continue;
                }
                printWriter.print(string + "[" + i + "]: ");
                nodeDefArray[i].display(printWriter, n);
            }
        }
    }

    protected static void displayStringArray(PrintWriter printWriter, String string, String[] stringArray, int n) {
        ElementDef.displayIndent(printWriter, n);
        if (stringArray == null) {
            printWriter.println(string + ": null array");
        } else {
            printWriter.println(string + ": array of " + stringArray.length + " values");
            for (int i = 0; i < stringArray.length; ++i) {
                ElementDef.displayIndent(printWriter, n);
                if (stringArray[i] == null) {
                    printWriter.println(string + "[" + i + "]: null");
                    continue;
                }
                printWriter.println(string + "[" + i + "]: " + stringArray[i]);
            }
        }
    }

    protected static void displayXMLString(XMLOutput xMLOutput, String string, String string2) {
        if (string2 != null) {
            xMLOutput.stringTag(string, string2);
        }
    }

    protected static void displayXMLElement(XMLOutput xMLOutput, ElementDef elementDef) {
        if (elementDef != null) {
            elementDef.displayXML(xMLOutput, 0);
        }
    }

    protected static void displayXMLElementArray(XMLOutput xMLOutput, NodeDef[] nodeDefArray) {
        if (nodeDefArray != null) {
            for (int i = 0; i < nodeDefArray.length; ++i) {
                nodeDefArray[i].displayXML(xMLOutput, 0);
            }
        }
    }

    protected static void displayXMLStringArray(XMLOutput xMLOutput, String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            xMLOutput.stringTag(string, stringArray[i]);
        }
    }

    protected static boolean displayStringDiff(String string, String string2, String string3, PrintWriter printWriter, int n) {
        if (string2 == null && string3 == null) {
            return true;
        }
        if (string3 == null) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("String " + string + ": mismatch: " + string2.toString() + " vs null.");
            }
            return false;
        }
        if (string2 == null) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("String " + string + ": mismatch: " + "null vs " + string3.toString() + ".");
            }
            return false;
        }
        if (string2.equals(string3)) {
            return true;
        }
        if (printWriter != null) {
            ElementDef.displayIndent(printWriter, n);
            printWriter.println("String " + string + ": mismatch: " + string2.toString() + " vs " + string3.toString() + ".");
        }
        return false;
    }

    protected static boolean displayAttributeDiff(String string, Object object, Object object2, PrintWriter printWriter, int n) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object2 == null) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("Attribute " + string + ": mismatch: " + object.toString() + " vs null.");
            }
            return false;
        }
        if (object == null) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("Attribute " + string + ": mismatch: " + "null vs " + object2.toString() + ".");
            }
            return false;
        }
        if (object.getClass() != object2.getClass()) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("Attribute " + string + ": class mismatch: " + object.getClass().getName() + " vs " + object2.getClass().getName() + ".");
            }
            return false;
        }
        if (object.equals(object2)) {
            return true;
        }
        if (printWriter != null) {
            ElementDef.displayIndent(printWriter, n);
            printWriter.println("Attribute " + string + ": mismatch: " + object.toString() + " vs " + object2.toString() + ".");
        }
        return false;
    }

    protected static boolean displayElementDiff(String string, NodeDef nodeDef, NodeDef nodeDef2, PrintWriter printWriter, int n) {
        if (nodeDef == null && nodeDef2 == null) {
            return true;
        }
        if (nodeDef2 == null) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("Object " + string + ": mismatch: " + "(...) vs null.");
            }
            return false;
        }
        if (nodeDef == null) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("Object " + string + ": mismatch: " + "null vs (...).");
            }
            return false;
        }
        if (nodeDef.getClass() != nodeDef2.getClass()) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("Object " + string + ": class mismatch: " + nodeDef.getClass().getName() + " vs " + nodeDef2.getClass().getName() + ".");
            }
            return false;
        }
        return ((ElementDef)nodeDef).displayDiff((ElementDef)nodeDef2, printWriter, n);
    }

    protected static boolean displayElementArrayDiff(String string, NodeDef[] nodeDefArray, NodeDef[] nodeDefArray2, PrintWriter printWriter, int n) {
        int n2 = 0;
        int n3 = 0;
        if (nodeDefArray != null) {
            n2 = nodeDefArray.length;
        }
        if (nodeDefArray2 != null) {
            n3 = nodeDefArray2.length;
        }
        if (n2 != n3) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("Array " + string + ": size mismatch: " + n2 + " vs " + n3 + ".");
            }
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            bl = bl && ElementDef.displayElementDiff(string + "[" + i + "]", nodeDefArray[i], nodeDefArray2[i], printWriter, n);
        }
        return bl;
    }

    protected static boolean displayStringArrayDiff(String string, String[] stringArray, String[] stringArray2, PrintWriter printWriter, int n) {
        if (stringArray.length != stringArray2.length) {
            if (printWriter != null) {
                ElementDef.displayIndent(printWriter, n);
                printWriter.println("Array " + string + ": size mismatch: " + stringArray.length + " vs " + stringArray2.length + ".");
            }
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            bl = bl && ElementDef.displayStringDiff(string + "[" + i + "]", stringArray[i], stringArray2[i], printWriter, n);
        }
        return bl;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.display(printWriter, 0);
        return stringWriter.toString();
    }

    public String toXML() {
        StringWriter stringWriter = new StringWriter();
        XMLOutput xMLOutput = new XMLOutput(stringWriter);
        this.displayXML(xMLOutput, 0);
        return stringWriter.toString();
    }

    public String toCompactXML() {
        StringWriter stringWriter = new StringWriter();
        XMLOutput xMLOutput = new XMLOutput(stringWriter);
        xMLOutput.setCompact(true);
        this.displayXML(xMLOutput, 0);
        return stringWriter.toString();
    }

    public String diff(ElementDef elementDef) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        boolean bl = this.displayDiff(elementDef, printWriter, 0);
        if (!bl) {
            return stringWriter.toString();
        }
        return null;
    }

    public boolean equals(Object object) {
        try {
            return this.displayDiff((ElementDef)object, null, 0);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.toXML().hashCode();
    }

    public void verifyEqual(ElementDef elementDef) throws XOMException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        boolean bl = this.displayDiff(elementDef, printWriter, 1);
        printWriter.println();
        if (!bl) {
            throw new XOMException("Element definition mismatch: " + stringWriter.toString());
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        try {
            return this.deepCopy();
        }
        catch (XOMException xOMException) {
            throw new CloneNotSupportedException("Unable to clone " + this.getClass().getName() + ": " + xOMException.toString());
        }
    }

    public ElementDef deepCopy() throws XOMException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            ElementDef elementDef = (ElementDef)objectInputStream.readObject();
            return elementDef;
        }
        catch (IOException iOException) {
            throw new XOMException(iOException, "Failed to serialize-copy ElementDef");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XOMException(classNotFoundException, "Failed to serialize-copy ElementDef");
        }
    }

    public DOMWrapper getWrapper() {
        try {
            Field field = this.getClass().getField("_def");
            return (DOMWrapper)field.get(this);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException.toString() + " in getWrapper");
        }
    }

    public NodeDef[] getChildren() {
        throw new Error();
    }

    public void addChild(NodeDef nodeDef) throws XOMException {
        XOMUtil.addChild(this, nodeDef);
    }

    public void addChildren(NodeDef[] nodeDefArray) throws XOMException {
        XOMUtil.addChildren(this, nodeDefArray);
    }

    protected static NodeDef[] getMixedChildren_new(DOMWrapper dOMWrapper, Class clazz, String string) throws XOMException {
        DOMWrapper[] dOMWrapperArray = dOMWrapper.getChildren();
        int n = 0;
        block6: for (int i = 0; i < dOMWrapperArray.length; ++i) {
            switch (dOMWrapperArray[i].getType()) {
                case 2: 
                case 3: 
                case 4: {
                    ++n;
                    continue block6;
                }
            }
        }
        NodeDef[] nodeDefArray = new NodeDef[n];
        n = 0;
        block7: for (int i = 0; i < dOMWrapperArray.length; ++i) {
            switch (dOMWrapperArray[i].getType()) {
                case 2: 
                case 3: 
                case 4: {
                    nodeDefArray[n++] = ElementDef.constructElement(dOMWrapperArray[i], clazz, string);
                    continue block7;
                }
            }
        }
        return nodeDefArray;
    }

    protected static NodeDef[] getMixedChildren(DOMWrapper dOMWrapper, Class clazz, String string) throws XOMException {
        DOMWrapper[] dOMWrapperArray = dOMWrapper.getChildren();
        NodeDef[] nodeDefArray = new NodeDef[dOMWrapperArray.length];
        for (int i = 0; i < dOMWrapperArray.length; ++i) {
            nodeDefArray[i] = ElementDef.constructElement(dOMWrapperArray[i], clazz, string);
        }
        return nodeDefArray;
    }

    protected static ElementDef[] getElementChildren(DOMWrapper dOMWrapper, Class clazz, String string) throws XOMException {
        DOMWrapper[] dOMWrapperArray = dOMWrapper.getElementChildren();
        ElementDef[] elementDefArray = new ElementDef[dOMWrapperArray.length];
        for (int i = 0; i < elementDefArray.length; ++i) {
            elementDefArray[i] = (ElementDef)ElementDef.constructElement(dOMWrapperArray[i], clazz, string);
        }
        return elementDefArray;
    }
}

