/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunInfo;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SimpleResolver;
import mondrian.resource.MondrianResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunTableImpl
implements FunTable {
    protected final Map<String, List<Resolver>> mapNameToResolvers = new HashMap<String, List<Resolver>>();
    private final Set<String> reservedWords = new HashSet<String>();
    private final Set<String> propertyWords = new HashSet<String>();
    protected final List<Resolver> resolverList = new ArrayList<Resolver>();
    protected final List<FunInfo> funInfoList = new ArrayList<FunInfo>();

    protected FunTableImpl() {
    }

    public void init() {
        this.defineFunctions();
        this.organizeFunctions();
    }

    protected static String makeResolverKey(String name, Syntax syntax) {
        return name.toUpperCase() + "$" + (Object)((Object)syntax);
    }

    protected void define(FunDef funDef) {
        this.define(new SimpleResolver(funDef));
    }

    protected void define(Resolver resolver) {
        String[] reservedWords;
        this.addFunInfo(resolver);
        if (resolver.getSyntax() == Syntax.Property) {
            this.defineProperty(resolver.getName());
        }
        this.resolverList.add(resolver);
        for (String reservedWord : reservedWords = resolver.getReservedWords()) {
            this.defineReserved(reservedWord);
        }
    }

    protected void addFunInfo(Resolver resolver) {
        this.funInfoList.add(FunInfo.make(resolver));
    }

    @Override
    public FunDef getDef(Exp[] args, Validator validator, String funName, Syntax syntax) {
        String key = FunTableImpl.makeResolverKey(funName, syntax);
        String signature = syntax.getSignature(funName, 0, ExpBase.getTypes(args));
        List<Resolver> resolvers = this.mapNameToResolvers.get(key);
        if (resolvers == null) {
            resolvers = Collections.emptyList();
        }
        int[] conversionCount = new int[]{0};
        int minConversions = Integer.MAX_VALUE;
        int matchCount = 0;
        FunDef matchDef = null;
        for (Resolver resolver : resolvers) {
            conversionCount[0] = 0;
            FunDef def = resolver.resolve(args, validator, conversionCount);
            if (def == null) continue;
            int conversions = conversionCount[0];
            if (conversions < minConversions) {
                minConversions = conversions;
                matchCount = 1;
                matchDef = def;
                continue;
            }
            if (conversions != minConversions) continue;
            ++matchCount;
        }
        switch (matchCount) {
            case 0: {
                throw MondrianResource.instance().NoFunctionMatchesSignature.ex(signature);
            }
            case 1: {
                String matchKey = FunTableImpl.makeResolverKey(matchDef.getName(), matchDef.getSyntax());
                Util.assertTrue(matchKey.equals(key), matchKey);
                return matchDef;
            }
        }
        throw MondrianResource.instance().MoreThanOneFunctionMatchesSignature.ex(signature);
    }

    @Override
    public boolean requiresExpression(UnresolvedFunCall call, int k, Validator validator) {
        String key = FunTableImpl.makeResolverKey(call.getFunName(), call.getSyntax());
        List<Resolver> resolvers = this.mapNameToResolvers.get(key);
        if (resolvers == null) {
            resolvers = Collections.emptyList();
        }
        for (Resolver resolver2 : resolvers) {
            if (resolver2.requiresExpression(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getReservedWords() {
        return new ArrayList<String>(this.reservedWords);
    }

    @Override
    public boolean isReserved(String s) {
        return this.reservedWords.contains(s.toUpperCase());
    }

    protected void defineReserved(String s) {
        this.reservedWords.add(s.toUpperCase());
    }

    @Override
    public List<Resolver> getResolvers() {
        ArrayList<Resolver> list = new ArrayList<Resolver>();
        for (List<Resolver> resolvers : this.mapNameToResolvers.values()) {
            list.addAll(resolvers);
        }
        return list;
    }

    @Override
    public boolean isProperty(String s) {
        return this.propertyWords.contains(s.toUpperCase());
    }

    protected void defineProperty(String s) {
        this.propertyWords.add(s.toUpperCase());
    }

    @Override
    public List<FunInfo> getFunInfoList() {
        return Collections.unmodifiableList(this.funInfoList);
    }

    protected void organizeFunctions() {
        Collections.sort(this.funInfoList);
        for (Resolver resolver : this.resolverList) {
            String key = FunTableImpl.makeResolverKey(resolver.getName(), resolver.getSyntax());
            List<Resolver> list = this.mapNameToResolvers.get(key);
            if (list == null) {
                list = new ArrayList<Resolver>();
                this.mapNameToResolvers.put(key, list);
            }
            list.add(resolver);
        }
    }

    protected abstract void defineFunctions();
}

