/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.CacheControl;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.DataSourceChangeListener;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapStar {
    private static final Logger LOGGER = Logger.getLogger(RolapStar.class);
    private static boolean disableCaching = MondrianProperties.instance().DisableCaching.get();
    private final RolapSchema schema;
    private DataSource dataSource;
    private final Table factTable;
    private final Map<RolapCube, Map<RolapLevel, Column>> cubeToLevelToColumnMapMap;
    private Map<BitKey, Aggregation> aggregations;
    private final ThreadLocal<Map<BitKey, Aggregation>> localAggregations = new ThreadLocal<Map<BitKey, Aggregation>>(){

        @Override
        protected Map<BitKey, Aggregation> initialValue() {
            return new HashMap<BitKey, Aggregation>();
        }
    };
    private final Map<BitKey, Aggregation> pendingAggregations;
    private final List<BitKey> aggregationRequests;
    private final ThreadLocal<List<BitKey>> localAggregationRequests = new ThreadLocal<List<BitKey>>(){

        @Override
        protected List<BitKey> initialValue() {
            return new ArrayList<BitKey>();
        }
    };
    private int columnCount;
    private final SqlQuery.Dialect sqlQueryDialect;
    private boolean cacheAggregations = true;
    private List<AggStar> aggStars;
    private DataSourceChangeListener changeListener;

    RolapStar(RolapSchema schema, DataSource dataSource, MondrianDef.Relation fact) {
        this.schema = schema;
        this.dataSource = dataSource;
        this.factTable = new Table(this, fact, null, null);
        this.cubeToLevelToColumnMapMap = new HashMap<RolapCube, Map<RolapLevel, Column>>();
        this.aggregations = new HashMap<BitKey, Aggregation>();
        this.pendingAggregations = new HashMap<BitKey, Aggregation>();
        this.aggregationRequests = new ArrayList<BitKey>();
        this.clearAggStarList();
        this.sqlQueryDialect = schema.getDialect();
        this.changeListener = schema.getDataSourceChangeListener();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    private int nextColumnCount() {
        return this.columnCount++;
    }

    private int decrementColumnCount() {
        return this.columnCount--;
    }

    public void prepareToLoadAggregates() {
        this.aggStars = Collections.emptyList();
    }

    public void addAggStar(AggStar aggStar) {
        if (this.aggStars == Collections.EMPTY_LIST) {
            this.aggStars = new LinkedList<AggStar>();
        }
        int size = aggStar.getSize();
        ListIterator<AggStar> lit = this.aggStars.listIterator();
        while (lit.hasNext()) {
            AggStar as = lit.next();
            if (as.getSize() < size) continue;
            lit.previous();
            lit.add(aggStar);
            return;
        }
        this.aggStars.add(aggStar);
    }

    void clearAggStarList() {
        this.aggStars = Collections.emptyList();
    }

    public void reOrderAggStarList() {
        List<AggStar> l = this.aggStars;
        this.clearAggStarList();
        for (AggStar aggStar : l) {
            this.addAggStar(aggStar);
        }
    }

    public List<AggStar> getAggStars() {
        return this.aggStars;
    }

    public Table getFactTable() {
        return this.factTable;
    }

    public SqlQuery getSqlQuery() {
        return new SqlQuery(this.getSqlQueryDialect());
    }

    public SqlQuery.Dialect getSqlQueryDialect() {
        return this.sqlQueryDialect;
    }

    Map<RolapLevel, Column> getLevelToColumnMap(RolapCube cube) {
        Map<RolapLevel, Column> levelToColumnMap = this.cubeToLevelToColumnMapMap.get(cube);
        if (levelToColumnMap == null) {
            levelToColumnMap = new HashMap<RolapLevel, Column>();
            this.cubeToLevelToColumnMapMap.put(cube, levelToColumnMap);
        }
        return levelToColumnMap;
    }

    void setCacheAggregations(boolean cacheAggregations) {
        this.cacheAggregations = cacheAggregations;
        this.clearCachedAggregations(false);
    }

    boolean isCacheAggregations() {
        return this.cacheAggregations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCachedAggregations(boolean forced) {
        if (forced || !this.cacheAggregations || disableCaching) {
            if (LOGGER.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder(100);
                buf.append("RolapStar.clearCachedAggregations: schema=");
                buf.append(this.schema.getName());
                buf.append(", star=");
                buf.append(this.getFactTable().getAlias());
                LOGGER.debug((Object)buf.toString());
            }
            if (forced) {
                Map<BitKey, Aggregation> map = this.aggregations;
                synchronized (map) {
                    this.aggregations.clear();
                }
                this.localAggregations.get().clear();
            } else {
                this.localAggregations.get().clear();
            }
        }
    }

    public Aggregation lookupOrCreateAggregation(BitKey bitKey) {
        Aggregation aggregation = this.lookupAggregation(bitKey);
        if (aggregation == null) {
            aggregation = new Aggregation(this, bitKey);
            this.localAggregations.get().put(bitKey, aggregation);
            if (this.cacheAggregations && !disableCaching && this.changeListener != null) {
                Util.discard((boolean)this.changeListener.isAggregationChanged(aggregation));
            }
        }
        return aggregation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregation lookupAggregation(BitKey bitKey) {
        Aggregation aggregation = this.localAggregations.get().get(bitKey);
        if (aggregation != null) {
            return aggregation;
        }
        if (this.cacheAggregations && !disableCaching) {
            Map<BitKey, Aggregation> map = this.aggregations;
            synchronized (map) {
                aggregation = this.aggregations.get(bitKey);
                if (aggregation != null) {
                    this.recordAggregationRequest(bitKey);
                }
            }
        }
        return aggregation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAggregateModifications() {
        this.clearAggregationRequests();
        if (this.changeListener != null && this.cacheAggregations && !disableCaching) {
            Map<BitKey, Aggregation> map = this.aggregations;
            synchronized (map) {
                for (Map.Entry<BitKey, Aggregation> e : this.aggregations.entrySet()) {
                    BitKey bitKey = e.getKey();
                    Aggregation aggregation = e.getValue();
                    if (!this.changeListener.isAggregationChanged(aggregation)) continue;
                    aggregation = new Aggregation(this, bitKey);
                    this.localAggregations.get().put(bitKey, aggregation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAggregateModificationsToGlobalCache() {
        RolapStar rolapStar = this;
        synchronized (rolapStar) {
            if (this.cacheAggregations && !disableCaching) {
                Aggregation aggregation;
                BitKey bitKey;
                Iterator<Map.Entry<BitKey, Aggregation>> it = this.pendingAggregations.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<BitKey, Aggregation> e = it.next();
                    bitKey = e.getKey();
                    aggregation = e.getValue();
                    if (this.isAggregationRequested(bitKey)) continue;
                    this.pushAggregateModification(bitKey, aggregation, this.aggregations);
                    it.remove();
                }
                for (Map.Entry<BitKey, Aggregation> e : this.localAggregations.get().entrySet()) {
                    bitKey = e.getKey();
                    aggregation = e.getValue();
                    if (!this.isAggregationRequested(bitKey)) {
                        this.pushAggregateModification(bitKey, aggregation, this.aggregations);
                        continue;
                    }
                    this.pushAggregateModification(bitKey, aggregation, this.pendingAggregations);
                }
                this.localAggregations.get().clear();
            }
            this.clearAggregationRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAggregateModification(BitKey localBitKey, Aggregation localAggregation, Map<BitKey, Aggregation> destAggregations) {
        if (this.cacheAggregations && !disableCaching) {
            Map<BitKey, Aggregation> map = destAggregations;
            synchronized (map) {
                boolean found = false;
                Iterator<Map.Entry<BitKey, Aggregation>> it = destAggregations.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<BitKey, Aggregation> e = it.next();
                    BitKey bitKey = e.getKey();
                    Aggregation aggregation = e.getValue();
                    if (!localBitKey.equals(bitKey)) continue;
                    if (localAggregation.getCreationTimestamp().after(aggregation.getCreationTimestamp())) {
                        it.remove();
                        break;
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    destAggregations.put(localBitKey, localAggregation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordAggregationRequest(BitKey bitKey) {
        if (!this.localAggregationRequests.get().contains(bitKey)) {
            List<BitKey> list = this.aggregationRequests;
            synchronized (list) {
                this.aggregationRequests.add(bitKey);
            }
            this.localAggregationRequests.get().add(bitKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAggregationRequested(BitKey bitKey) {
        List<BitKey> list = this.aggregationRequests;
        synchronized (list) {
            return this.aggregationRequests.contains(bitKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAggregationRequests() {
        List<BitKey> list = this.aggregationRequests;
        synchronized (list) {
            if (this.localAggregationRequests.get().isEmpty()) {
                return;
            }
            HashSet localAggregationRequestSet = new HashSet(this.localAggregationRequests.get());
            Iterator<BitKey> iter = this.aggregationRequests.iterator();
            while (iter.hasNext()) {
                BitKey bitKey = iter.next();
                if (!localAggregationRequestSet.contains(bitKey)) continue;
                iter.remove();
                localAggregationRequestSet.remove(bitKey);
                if (!localAggregationRequestSet.isEmpty()) continue;
                break;
            }
            this.localAggregationRequests.get().clear();
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static Measure getStarMeasure(Member member) {
        return (Measure)((RolapStoredMeasure)member).getStarMeasure();
    }

    public Column[] lookupColumns(String tableAlias, String columnName) {
        Table table = this.factTable.findDescendant(tableAlias);
        return table == null ? null : table.lookupColumns(columnName);
    }

    public Column lookupColumn(String tableAlias, String columnName) {
        Table table = this.factTable.findDescendant(tableAlias);
        return table == null ? null : table.lookupColumn(columnName);
    }

    public List<String> getAliasList() {
        ArrayList<String> aliasList = new ArrayList<String>();
        if (this.factTable != null) {
            RolapStar.collectAliases(aliasList, this.factTable);
        }
        return aliasList;
    }

    private static void collectAliases(List<String> aliasList, Table table) {
        aliasList.add(table.getAlias());
        for (Table child : table.children) {
            RolapStar.collectAliases(aliasList, child);
        }
    }

    public static void collectColumns(Collection<Column> columnList, Table table, MondrianDef.Column joinColumn) {
        if (joinColumn == null) {
            columnList.addAll(table.columnList);
        }
        for (Table child : table.children) {
            if (joinColumn != null && !child.getJoinCondition().left.equals((Object)joinColumn)) continue;
            RolapStar.collectColumns(columnList, child, null);
        }
    }

    Object getCell(CellRequest request) {
        return this.getCell(request, this.dataSource);
    }

    private Object getCell(CellRequest request, DataSource dataSource) {
        Object[] values;
        Measure measure = request.getMeasure();
        Column[] columns = request.getConstrainedColumns();
        Util.assertTrue(columns.length == (values = request.getSingleValues()).length);
        SqlQuery sqlQuery = this.getSqlQuery();
        Util.assertTrue(measure.getTable() == this.factTable);
        this.factTable.addToFrom(sqlQuery, true, true);
        sqlQuery.addSelect(measure.aggregator.getExpression(measure.generateExprString(sqlQuery)));
        for (int i = 0; i < columns.length; ++i) {
            Column column;
            Table table;
            Object value = values[i];
            if (value == null || (table = (column = columns[i]).getTable()).isFunky()) continue;
            table.addToFrom(sqlQuery, true, true);
        }
        String sql = sqlQuery.toString();
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, "RolapStar.getCell", "while computing single cell");
        try {
            ResultSet resultSet = stmt.getResultSet();
            Object o = null;
            if (resultSet.next()) {
                o = resultSet.getObject(1);
                ++stmt.rowCount;
            }
            if (o == null) {
                o = Util.nullValue;
            }
            Object object = o;
            return object;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    private boolean containsColumn(String tableName, String columnName) {
        Connection jdbcConnection;
        try {
            jdbcConnection = this.dataSource.getConnection();
        }
        catch (SQLException e1) {
            throw Util.newInternal(e1, "Error while creating connection from data source");
        }
        try {
            DatabaseMetaData metaData = jdbcConnection.getMetaData();
            ResultSet columns = metaData.getColumns(null, null, tableName, columnName);
            boolean bl = columns.next();
            return bl;
        }
        catch (SQLException e) {
            throw Util.newInternal("Error while retrieving metadata for table '" + tableName + "', column '" + columnName + "'");
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException e) {}
        }
    }

    public RolapSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, "", true);
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw, String prefix, boolean structure) {
        if (structure) {
            pw.print(prefix);
            pw.println("RolapStar:");
            String subprefix = prefix + "  ";
            this.factTable.print(pw, subprefix);
            for (AggStar aggStar : this.getAggStars()) {
                aggStar.print(pw, subprefix);
            }
        }
        ArrayList<Aggregation> aggregationList = new ArrayList<Aggregation>(this.aggregations.values());
        Collections.sort(aggregationList, new Comparator<Aggregation>(){

            @Override
            public int compare(Aggregation o1, Aggregation o2) {
                return o1.getConstrainedColumnsBitKey().compareTo(o2.getConstrainedColumnsBitKey());
            }
        });
        for (Aggregation aggregation : aggregationList) {
            aggregation.print(pw);
        }
    }

    public void flush(CacheControl cacheControl, CacheControl.CellRegion region) {
        RolapCacheRegion cacheRegion = RolapAggregationManager.makeCacheRegion(this, region);
        for (Aggregation aggregation : this.aggregations.values()) {
            aggregation.flush(cacheControl, cacheRegion);
        }
    }

    public DataSourceChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(DataSourceChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    static {
        MondrianProperties.instance().DisableCaching.addTrigger((Trigger)new TriggerBase(true){

            public void execute(Property property, String value) {
                disableCaching = property.booleanValue();
                if (disableCaching) {
                    RolapSchema.flushAllRolapStarCachedAggregations();
                }
            }
        });
    }

    public static class AliasReplacer {
        private final String oldAlias;
        private final String newAlias;

        public AliasReplacer(String oldAlias, String newAlias) {
            this.oldAlias = oldAlias;
            this.newAlias = newAlias;
        }

        private Condition visit(Condition condition) {
            if (condition == null) {
                return null;
            }
            if (this.newAlias.equals(this.oldAlias)) {
                return condition;
            }
            return new Condition(this.visit(condition.left), this.visit(condition.right));
        }

        public MondrianDef.Expression visit(MondrianDef.Expression expression) {
            if (expression == null) {
                return null;
            }
            if (this.newAlias.equals(this.oldAlias)) {
                return expression;
            }
            if (expression instanceof MondrianDef.Column) {
                MondrianDef.Column column = (MondrianDef.Column)expression;
                return new MondrianDef.Column(this.visit(column.table), column.name);
            }
            throw Util.newInternal("need to implement " + (Object)((Object)expression));
        }

        private String visit(String table) {
            return table.equals(this.oldAlias) ? this.newAlias : table;
        }
    }

    public static class Condition {
        private static final Logger LOGGER = Logger.getLogger(Condition.class);
        private final MondrianDef.Expression left;
        private final MondrianDef.Expression right;
        Table table;

        Condition(MondrianDef.Expression left, MondrianDef.Expression right) {
            assert (left != null);
            assert (right != null);
            if (!(left instanceof MondrianDef.Column)) {
                LOGGER.debug((Object)("Condition.left NOT Column: " + ((Object)((Object)left)).getClass().getName()));
            }
            this.left = left;
            this.right = right;
        }

        public MondrianDef.Expression getLeft() {
            return this.left;
        }

        public MondrianDef.Expression getRight() {
            return this.right;
        }

        public String toString(SqlQuery query) {
            return this.left.getExpression(query) + " = " + this.right.getExpression(query);
        }

        public int hashCode() {
            return this.left.hashCode() ^ this.right.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Condition)) {
                return false;
            }
            Condition that = (Condition)obj;
            return this.left.equals((Object)that.left) && this.right.equals((Object)that.right);
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            SqlQuery sqlQueuy = this.table.getSqlQuery();
            pw.print(prefix);
            pw.println("Condition:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("left=");
            if (this.left instanceof MondrianDef.Column) {
                MondrianDef.Column c = (MondrianDef.Column)this.left;
                Column col = this.table.star.getFactTable().lookupColumn(c.name);
                if (col != null) {
                    pw.print(" (");
                    pw.print(col.getBitPosition());
                    pw.print(") ");
                }
            }
            pw.println(this.left.getExpression(sqlQueuy));
            pw.print(subprefix);
            pw.print("right=");
            pw.println(this.right.getExpression(sqlQueuy));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Table {
        private final RolapStar star;
        private final MondrianDef.Relation relation;
        private final List<Column> columnList;
        private final Table parent;
        private List<Table> children;
        private final Condition joinCondition;
        private final String alias;

        private Table(RolapStar star, MondrianDef.Relation relation, Table parent, Condition joinCondition) {
            this.star = star;
            this.relation = relation;
            Util.assertTrue(relation instanceof MondrianDef.Table || relation instanceof MondrianDef.View, "todo: allow dimension which is not a Table or View, [" + (Object)((Object)relation) + "]");
            this.alias = this.chooseAlias();
            this.parent = parent;
            AliasReplacer aliasReplacer = new AliasReplacer(relation.getAlias(), this.alias);
            this.joinCondition = aliasReplacer.visit(joinCondition);
            if (this.joinCondition != null) {
                this.joinCondition.table = this;
            }
            this.columnList = new ArrayList<Column>();
            this.children = Collections.emptyList();
            Util.assertTrue(parent == null == (joinCondition == null));
        }

        public Condition getJoinCondition() {
            return this.joinCondition;
        }

        public Table getParentTable() {
            return this.parent;
        }

        private void addColumn(Column column) {
            this.columnList.add(column);
        }

        private void collectColumns(BitKey bitKey, List<Column> list) {
            for (Column column : this.getColumns()) {
                if (!bitKey.get(column.getBitPosition())) continue;
                list.add(column);
            }
            for (Table table : this.getChildren()) {
                table.collectColumns(bitKey, list);
            }
        }

        public Column[] lookupColumns(String columnName) {
            ArrayList<Column> l = new ArrayList<Column>();
            for (Column column : this.getColumns()) {
                if (!(column.getExpression() instanceof MondrianDef.Column)) continue;
                MondrianDef.Column columnExpr = (MondrianDef.Column)column.getExpression();
                if (!columnExpr.name.equals(columnName)) continue;
                l.add(column);
            }
            return l.toArray(new Column[0]);
        }

        public Column lookupColumn(String columnName) {
            for (Column column : this.getColumns()) {
                if (!(column.getExpression() instanceof MondrianDef.Column)) continue;
                MondrianDef.Column columnExpr = (MondrianDef.Column)column.getExpression();
                if (!columnExpr.name.equals(columnName)) continue;
                return column;
            }
            return null;
        }

        public Column lookupColumnByExpression(MondrianDef.Expression xmlExpr) {
            for (Column column : this.getColumns()) {
                if (column instanceof Measure || !column.getExpression().equals((Object)xmlExpr)) continue;
                return column;
            }
            return null;
        }

        public boolean containsColumn(Column column) {
            for (Column other : this.getColumns()) {
                if (!column.equals(other)) continue;
                return true;
            }
            return false;
        }

        public Measure lookupMeasureByName(String name) {
            for (Column column : this.getColumns()) {
                Measure measure;
                if (!(column instanceof Measure) || !(measure = (Measure)column).getName().equals(name)) continue;
                return measure;
            }
            return null;
        }

        RolapStar getStar() {
            return this.star;
        }

        private SqlQuery getSqlQuery() {
            return this.getStar().getSqlQuery();
        }

        public MondrianDef.Relation getRelation() {
            return this.relation;
        }

        private String chooseAlias() {
            List<String> aliasList = this.star.getAliasList();
            int i = 0;
            while (true) {
                String candidateAlias = this.relation.getAlias();
                if (i > 0) {
                    candidateAlias = candidateAlias + "_" + i;
                }
                if (!aliasList.contains(candidateAlias)) {
                    return candidateAlias;
                }
                ++i;
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public String getTableName() {
            if (this.relation instanceof MondrianDef.Table) {
                MondrianDef.Table t = (MondrianDef.Table)this.relation;
                return t.name;
            }
            return null;
        }

        synchronized void makeMeasure(RolapBaseCubeMeasure measure) {
            Measure starMeasure = new Measure(measure.getName(), measure.getAggregator(), this, measure.getMondrianDefExpression(), measure.getDatatype());
            measure.setStarMeasure(starMeasure);
            if (this.containsColumn(starMeasure)) {
                this.star.decrementColumnCount();
            } else {
                this.addColumn(starMeasure);
            }
        }

        synchronized Column makeColumns(RolapCube cube, RolapLevel level, Column parentColumn, String usagePrefix) {
            String name;
            Column column;
            Column nameColumn = null;
            if (level.getNameExp() != null) {
                nameColumn = this.makeColumnForLevelExpr(cube, level, level.getName(), level.getNameExp(), SqlQuery.Datatype.String, null, null, null);
            }
            if ((column = this.makeColumnForLevelExpr(cube, level, name = level.getNameExp() == null ? level.getName() : level.getName() + " (Key)", level.getKeyExp(), level.getDatatype(), nameColumn, parentColumn, usagePrefix)) != null) {
                Map<RolapLevel, Column> map = this.star.getLevelToColumnMap(cube);
                map.put(level, column);
            }
            return column;
        }

        private Column makeColumnForLevelExpr(RolapCube cube, RolapLevel level, String name, MondrianDef.Expression xmlExpr, SqlQuery.Datatype datatype, Column nameColumn, Column parentColumn, String usagePrefix) {
            Table table = this;
            if (xmlExpr instanceof MondrianDef.Column) {
                MondrianDef.Column xmlColumn = (MondrianDef.Column)xmlExpr;
                String tableName = xmlColumn.table;
                table = this.findAncestor(tableName);
                if (table == null) {
                    throw Util.newError("Level '" + level.getUniqueName() + "' of cube '" + this + "' is invalid: table '" + tableName + "' is not found in current scope" + Util.nl + ", star:" + Util.nl + this.getStar());
                }
                AliasReplacer aliasReplacer = new AliasReplacer(tableName, table.getAlias());
                xmlExpr = aliasReplacer.visit(xmlExpr);
            }
            Column c = this.lookupColumnByExpression(xmlExpr);
            Column column = null;
            if (c != null) {
                column = c;
            } else {
                column = new Column(name, table, xmlExpr, datatype, nameColumn, parentColumn, usagePrefix);
                this.addColumn(column);
            }
            return column;
        }

        synchronized Table addJoin(MondrianDef.Relation relation, Condition joinCondition) {
            if (relation instanceof MondrianDef.Table || relation instanceof MondrianDef.View) {
                Table starTable = this.findChild(relation, joinCondition);
                if (starTable == null) {
                    starTable = new Table(this.star, relation, this, joinCondition);
                    if (this.children.isEmpty()) {
                        this.children = new ArrayList<Table>();
                    }
                    this.children.add(starTable);
                }
                return starTable;
            }
            if (relation instanceof MondrianDef.Join) {
                MondrianDef.Join join = (MondrianDef.Join)relation;
                Table leftTable = this.addJoin(join.left, joinCondition);
                String leftAlias = join.leftAlias;
                if (leftAlias == null && (leftAlias = join.left.getAlias()) == null) {
                    throw Util.newError("missing leftKeyAlias in " + (Object)((Object)relation));
                }
                assert (leftTable.findAncestor(leftAlias) == leftTable);
                leftAlias = leftTable.getAlias();
                String rightAlias = join.rightAlias;
                if (rightAlias == null && (rightAlias = join.right.getAlias()) == null) {
                    throw Util.newError("missing rightKeyAlias in " + (Object)((Object)relation));
                }
                joinCondition = new Condition(new MondrianDef.Column(leftAlias, join.leftKey), new MondrianDef.Column(rightAlias, join.rightKey));
                Table rightTable = leftTable.addJoin(join.right, joinCondition);
                return rightTable;
            }
            throw Util.newInternal("bad relation type " + (Object)((Object)relation));
        }

        public Table findChild(MondrianDef.Relation relation, Condition joinCondition) {
            for (Table child : this.getChildren()) {
                if (!child.relation.equals((Object)relation)) continue;
                Condition condition = joinCondition;
                if (!Util.equalName(relation.getAlias(), child.alias)) {
                    AliasReplacer aliasReplacer = new AliasReplacer(relation.getAlias(), child.alias);
                    condition = aliasReplacer.visit(joinCondition);
                }
                if (!child.joinCondition.equals(condition)) continue;
                return child;
            }
            return null;
        }

        public Table findDescendant(String seekAlias) {
            if (this.getAlias().equals(seekAlias)) {
                return this;
            }
            for (Table child : this.getChildren()) {
                Table found = child.findDescendant(seekAlias);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public Table findAncestor(String tableName) {
            Table t = this;
            while (t != null) {
                if (t.relation.getAlias().equals(tableName)) {
                    return t;
                }
                t = t.parent;
            }
            return null;
        }

        public boolean equalsTableName(String tableName) {
            if (this.relation instanceof MondrianDef.Table) {
                MondrianDef.Table mt = (MondrianDef.Table)this.relation;
                if (mt.name.equals(tableName)) {
                    return true;
                }
            }
            return false;
        }

        public void addToFrom(SqlQuery query, boolean failIfExists, boolean joinToParent) {
            query.addFrom(this.relation, this.alias, failIfExists);
            Util.assertTrue(this.parent == null == (this.joinCondition == null));
            if (joinToParent) {
                if (this.parent != null) {
                    this.parent.addToFrom(query, failIfExists, joinToParent);
                }
                if (this.joinCondition != null) {
                    query.addWhere(this.joinCondition.toString(query));
                }
            }
        }

        public List<Table> getChildren() {
            return this.children;
        }

        public List<Column> getColumns() {
            return this.columnList;
        }

        public Table findTableWithLeftJoinCondition(String columnName) {
            for (Table child : this.getChildren()) {
                Condition condition = child.joinCondition;
                if (condition == null || !(condition.left instanceof MondrianDef.Column)) continue;
                MondrianDef.Column mcolumn = (MondrianDef.Column)condition.left;
                if (!mcolumn.name.equals(columnName)) continue;
                return child;
            }
            return null;
        }

        public Table findTableWithLeftCondition(MondrianDef.Expression left) {
            for (Table child : this.getChildren()) {
                MondrianDef.Column mcolumn;
                Condition condition = child.joinCondition;
                if (condition == null || !(condition.left instanceof MondrianDef.Column) || !(mcolumn = (MondrianDef.Column)condition.left).equals((Object)left)) continue;
                return child;
            }
            return null;
        }

        public boolean isFunky() {
            return this.relation == null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Table)) {
                return false;
            }
            Table other = (Table)obj;
            return this.getAlias().equals(other.getAlias());
        }

        public int hashCode() {
            return this.getAlias().hashCode();
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("alias=");
            pw.println(this.getAlias());
            if (this.relation != null) {
                pw.print(subprefix);
                pw.print("relation=");
                pw.println((Object)this.relation);
            }
            pw.print(subprefix);
            pw.println("Columns:");
            String subsubprefix = subprefix + "  ";
            for (Column column : this.getColumns()) {
                column.print(pw, subsubprefix);
                pw.println();
            }
            if (this.joinCondition != null) {
                this.joinCondition.print(pw, subprefix);
            }
            for (Table child : this.getChildren()) {
                child.print(pw, subprefix);
            }
        }

        public boolean containsColumn(String columnName) {
            if (this.relation instanceof MondrianDef.Table) {
                return this.star.containsColumn(((MondrianDef.Table)this.relation).name, columnName);
            }
            return false;
        }
    }

    public static class Measure
    extends Column {
        private final RolapAggregator aggregator;

        private Measure(String name, RolapAggregator aggregator, Table table, MondrianDef.Expression expression, SqlQuery.Datatype datatype) {
            super(name, table, expression, datatype);
            this.aggregator = aggregator;
        }

        public RolapAggregator getAggregator() {
            return this.aggregator;
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Measure)) {
                return false;
            }
            Measure other = (Measure)obj;
            return other.aggregator == this.aggregator;
        }

        public void print(PrintWriter pw, String prefix) {
            SqlQuery sqlQuery = this.getSqlQuery();
            pw.print(prefix);
            pw.print(this.getName());
            pw.print(" (");
            pw.print(this.getBitPosition());
            pw.print("): ");
            pw.print(this.aggregator.getExpression(this.generateExprString(sqlQuery)));
        }
    }

    public static class Column {
        private final Table table;
        private final MondrianDef.Expression expression;
        private final SqlQuery.Datatype datatype;
        private final String name;
        private final Column parentColumn;
        private final String usagePrefix;
        private final Column nameColumn;
        private boolean isNameColumn;
        private final int bitPosition;
        private int cardinality = -1;

        private Column(String name, Table table, MondrianDef.Expression expression, SqlQuery.Datatype datatype) {
            this(name, table, expression, datatype, null, null, null);
        }

        private Column(String name, Table table, MondrianDef.Expression expression, SqlQuery.Datatype datatype, Column nameColumn, Column parentColumn, String usagePrefix) {
            this.name = name;
            this.table = table;
            this.expression = expression;
            this.datatype = datatype;
            this.bitPosition = table.star.nextColumnCount();
            this.nameColumn = nameColumn;
            this.parentColumn = parentColumn;
            this.usagePrefix = usagePrefix;
            if (nameColumn != null) {
                nameColumn.isNameColumn = true;
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Column)) {
                return false;
            }
            Column other = (Column)obj;
            return other.table == this.table && other.expression.equals((Object)this.expression) && other.datatype == this.datatype && other.name.equals(this.name);
        }

        public String getName() {
            return this.name;
        }

        public int getBitPosition() {
            return this.bitPosition;
        }

        public RolapStar getStar() {
            return this.table.star;
        }

        public Table getTable() {
            return this.table;
        }

        public SqlQuery getSqlQuery() {
            return this.getTable().getStar().getSqlQuery();
        }

        public Column getNameColumn() {
            return this.nameColumn;
        }

        public Column getParentColumn() {
            return this.parentColumn;
        }

        public String getUsagePrefix() {
            return this.usagePrefix;
        }

        public boolean isNameColumn() {
            return this.isNameColumn;
        }

        public MondrianDef.Expression getExpression() {
            return this.expression;
        }

        public String generateExprString(SqlQuery query) {
            return this.getExpression().getExpression(query);
        }

        public int getCardinality() {
            if (this.cardinality == -1) {
                this.cardinality = this.getCardinality(this.getStar().getDataSource());
            }
            return this.cardinality;
        }

        private int getCardinality(DataSource dataSource) {
            SqlQuery sqlQuery = this.getSqlQuery();
            if (sqlQuery.getDialect().allowsCountDistinct()) {
                sqlQuery.addSelect("count(distinct " + this.generateExprString(sqlQuery) + ")");
                this.table.addToFrom(sqlQuery, true, false);
            } else if (sqlQuery.getDialect().allowsFromQuery()) {
                SqlQuery inner = sqlQuery.cloneEmpty();
                inner.setDistinct(true);
                inner.addSelect(this.generateExprString(inner));
                boolean failIfExists = true;
                boolean joinToParent = false;
                this.table.addToFrom(inner, failIfExists, joinToParent);
                sqlQuery.addSelect("count(*)");
                sqlQuery.addFrom(inner, "init", failIfExists);
            } else {
                throw Util.newInternal("Cannot compute cardinality: this database neither supports COUNT DISTINCT nor SELECT in the FROM clause.");
            }
            String sql = sqlQuery.toString();
            SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, "RolapStar.Column.getCardinality", "while counting distinct values of column '" + this.expression.getGenericExpression());
            try {
                ResultSet resultSet = stmt.getResultSet();
                Util.assertTrue(resultSet.next());
                ++stmt.rowCount;
                int n = resultSet.getInt(1);
                return n;
            }
            catch (SQLException e) {
                throw stmt.handle(e);
            }
            finally {
                stmt.close();
            }
        }

        public static String createInExpr(String expr, StarColumnPredicate predicate, SqlQuery.Datatype datatype, SqlQuery.Dialect dialect) {
            if (predicate instanceof ValueColumnPredicate) {
                ValueColumnPredicate valuePredicate = (ValueColumnPredicate)predicate;
                Object key = valuePredicate.getValue();
                if (key == RolapUtil.sqlNullValue) {
                    return expr + " is null";
                }
                StringBuilder buf = new StringBuilder(64);
                buf.append(expr);
                buf.append(" = ");
                dialect.quote(buf, key, datatype);
                return buf.toString();
            }
            if (predicate instanceof ListColumnPredicate) {
                ListColumnPredicate valueListColumnPredicate = (ListColumnPredicate)predicate;
                List<StarColumnPredicate> predicates = valueListColumnPredicate.getPredicates();
                if (predicates.size() == 1) {
                    return Column.createInExpr(expr, predicates.get(0), datatype, dialect);
                }
                int notNullCount = 0;
                StringBuilder sb = new StringBuilder(expr);
                ValueColumnPredicate firstNotNull = null;
                sb.append(" in (");
                for (StarColumnPredicate predicate1 : predicates) {
                    ValueColumnPredicate predicate2 = (ValueColumnPredicate)predicate1;
                    Object key = predicate2.getValue();
                    if (key == RolapUtil.sqlNullValue) continue;
                    if (notNullCount > 0) {
                        sb.append(", ");
                    } else {
                        firstNotNull = predicate2;
                    }
                    ++notNullCount;
                    dialect.quote(sb, key, datatype);
                }
                sb.append(')');
                if (notNullCount < predicates.size()) {
                    StringBuilder buf;
                    switch (notNullCount) {
                        case 0: {
                            return expr + " is null";
                        }
                        case 1: {
                            assert (firstNotNull != null);
                            buf = new StringBuilder(64);
                            buf.append('(');
                            buf.append(expr);
                            buf.append(" = ");
                            dialect.quote(buf, firstNotNull.getValue(), datatype);
                            buf.append(" or ");
                            buf.append(expr);
                            buf.append(" is null)");
                            return buf.toString();
                        }
                    }
                    buf = new StringBuilder(64);
                    buf.append('(');
                    buf.append(sb.toString());
                    buf.append(" or ");
                    buf.append(expr);
                    buf.append(" is null)");
                    return buf.toString();
                }
                return sb.toString();
            }
            if (predicate instanceof LiteralStarPredicate) {
                return predicate.toString();
            }
            throw Util.newInternal("Unexpected constraint type: " + predicate);
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            SqlQuery sqlQuery = this.getSqlQuery();
            pw.print(prefix);
            pw.print(this.getName());
            pw.print(" (");
            pw.print(this.getBitPosition());
            pw.print("): ");
            pw.print(this.generateExprString(sqlQuery));
        }

        public SqlQuery.Datatype getDatatype() {
            return this.datatype;
        }
    }
}

