/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.IRFont;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.PdfEncoding;
import it.businesslogic.ireport.gui.JNumberComboBox;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class JRFontDialog
extends JDialog {
    private IReportFont iReportFont = new IReportFont();
    private boolean init = false;
    private boolean reportFontMode = true;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonResetAllToDefault;
    private JCheckBox jCheckBoxBold;
    private JCheckBox jCheckBoxDefaultFont;
    private JCheckBox jCheckBoxItalic;
    private JCheckBox jCheckBoxPDFEmbedded;
    private JCheckBox jCheckBoxStrokeTrough;
    private JCheckBox jCheckBoxUnderline;
    private JComboBox jComboBoxFontName;
    private JComboBox jComboBoxPDFFontName;
    private JComboBox jComboBoxPdfEncoding;
    private JComboBox jComboBoxReportFonts;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel27;
    private JLabel jLabel32;
    private JNumberComboBox jNumberComboBoxSize;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanelFont;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextField jTextFieldReportFont;
    private int dialogResult;

    public JRFontDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(420, 344);
        this.applyI18n();
        Misc.centerFrame(this);
        this.jNumberComboBoxSize.addEntry("3", 3.0);
        this.jNumberComboBoxSize.addEntry("5", 5.0);
        this.jNumberComboBoxSize.addEntry("8", 8.0);
        this.jNumberComboBoxSize.addEntry("10", 10.0);
        this.jNumberComboBoxSize.addEntry("12", 12.0);
        this.jNumberComboBoxSize.addEntry("14", 14.0);
        this.jNumberComboBoxSize.addEntry("18", 18.0);
        this.jNumberComboBoxSize.addEntry("24", 24.0);
        this.jNumberComboBoxSize.addEntry("36", 36.0);
        this.jNumberComboBoxSize.addEntry("48", 48.0);
        this.jNumberComboBoxSize.setSelectedIndex(3);
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1250", "CP1250 (Central European)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1251", "CP1251 (Cyrillic)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1252", "CP1252 (Western European ANSI aka WinAnsi)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1253", "CP1253 (Greek)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1254", "CP1254 (Turkish)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1255", "CP1255 (Hebrew)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1256", "CP1256 (Arabic)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1257", "CP1257 (Baltic)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1258", "CP1258 (Vietnamese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-H", "UniGB-UCS2-H (Chinese Simplified)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-V", "UniGB-UCS2-V (Chinese Simplified)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-H", "UniCNS-UCS2-H (Chinese traditional)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-V", "UniCNS-UCS2-V (Chinese traditional)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-H", "UniJIS-UCS2-H (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-V", "UniJIS-UCS2-V (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-H", "UniKS-UCS2-H (Korean)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-V", "UniKS-UCS2-V (Korean)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-H", "Identity-H (Unicode with horizontal writing)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-V", "Identity-V (Unicode with vertical writing)"));
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            this.jComboBoxFontName.addItem(fontFamilies[i]);
        }
        this.jComboBoxReportFonts.setVisible(false);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRFontDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jPanelFont = new JPanel();
        this.jLabel23 = new JLabel();
        this.jTextFieldReportFont = new JTextField();
        this.jLabel24 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jComboBoxFontName = new JComboBox();
        this.jNumberComboBoxSize = new JNumberComboBox();
        this.jLabel25 = new JLabel();
        this.jComboBoxPDFFontName = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jCheckBoxBold = new JCheckBox();
        this.jCheckBoxUnderline = new JCheckBox();
        this.jCheckBoxItalic = new JCheckBox();
        this.jCheckBoxStrokeTrough = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jCheckBoxPDFEmbedded = new JCheckBox();
        this.jCheckBoxDefaultFont = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jLabel32 = new JLabel();
        this.jComboBoxPdfEncoding = new JComboBox();
        this.jSeparator3 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonResetAllToDefault = new JButton();
        this.jComboBoxReportFonts = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify report font");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRFontDialog.this.closeDialog(evt);
            }
        });
        this.jPanelFont.setLayout(new GridBagLayout());
        this.jLabel23.setText("Report font");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jLabel23, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jTextFieldReportFont, gridBagConstraints);
        this.jLabel24.setText("Font name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel27.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanelFont.add((Component)this.jLabel27, gridBagConstraints);
        this.jComboBoxFontName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jComboBoxFontNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanelFont.add((Component)this.jComboBoxFontName, gridBagConstraints);
        this.jNumberComboBoxSize.setMinimumSize(new Dimension(70, 22));
        this.jNumberComboBoxSize.setPreferredSize(new Dimension(70, 22));
        this.jNumberComboBoxSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jNumberComboBoxSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelFont.add((Component)this.jNumberComboBoxSize, gridBagConstraints);
        this.jLabel25.setText("PDF font name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jLabel25, gridBagConstraints);
        this.jComboBoxPDFFontName.setEditable(true);
        this.jComboBoxPDFFontName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jComboBoxPDFFontNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jComboBoxPDFFontName, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jCheckBoxBold.setText("Bold");
        this.jCheckBoxBold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jCheckBoxBoldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jCheckBoxBold, gridBagConstraints);
        this.jCheckBoxUnderline.setText("Underline");
        this.jCheckBoxUnderline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jCheckBoxUnderlineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jCheckBoxUnderline, gridBagConstraints);
        this.jCheckBoxItalic.setText("Italic");
        this.jCheckBoxItalic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jCheckBoxItalicActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jCheckBoxItalic, gridBagConstraints);
        this.jCheckBoxStrokeTrough.setText("Strike Trough");
        this.jCheckBoxStrokeTrough.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jCheckBoxStrokeTroughActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jCheckBoxStrokeTrough, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelFont.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jCheckBoxPDFEmbedded.setText("PDF Embedded");
        this.jCheckBoxPDFEmbedded.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jCheckBoxPDFEmbeddedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jCheckBoxPDFEmbedded, gridBagConstraints);
        this.jCheckBoxDefaultFont.setLabel("Default");
        this.jCheckBoxDefaultFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jCheckBoxDefaultFontActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jCheckBoxDefaultFont, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel32.setText("PDF Encoding");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jLabel32, gridBagConstraints);
        this.jComboBoxPdfEncoding.setEditable(true);
        this.jComboBoxPdfEncoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jComboBoxPdfEncodingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jComboBoxPdfEncoding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelFont.add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jButtonResetAllToDefault.setMnemonic('d');
        this.jButtonResetAllToDefault.setText("Set all to default");
        this.jButtonResetAllToDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jButtonOKActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonResetAllToDefault, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelFont.add((Component)this.jPanel6, gridBagConstraints);
        this.jComboBoxReportFonts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jComboBoxReportFontsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jComboBoxReportFonts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanelFont, gridBagConstraints);
        this.pack();
    }

    private void jComboBoxPdfEncodingActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        if (this.jComboBoxPdfEncoding.getSelectedItem() instanceof PdfEncoding) {
            this.iReportFont.setPdfEncoding(((PdfEncoding)this.jComboBoxPdfEncoding.getSelectedItem()).getEncoding());
        }
    }

    private void jCheckBoxPDFEmbeddedActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.iReportFont.setPdfEmbedded(this.jCheckBoxPDFEmbedded.isSelected());
    }

    private void jCheckBoxDefaultFontActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.iReportFont.setDefaultFont(this.jCheckBoxDefaultFont.isSelected());
    }

    private void jCheckBoxStrokeTroughActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.iReportFont.setStrikeTrought(this.jCheckBoxStrokeTrough.isSelected());
    }

    private void jCheckBoxItalicActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.iReportFont.setItalic(this.jCheckBoxItalic.isSelected());
    }

    private void jCheckBoxUnderlineActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.iReportFont.setUnderline(this.jCheckBoxUnderline.isSelected());
    }

    private void jCheckBoxBoldActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.iReportFont.setBold(this.jCheckBoxBold.isSelected());
    }

    private void jNumberComboBoxSizeActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.iReportFont.setFontSize((int)this.jNumberComboBoxSize.getValue());
    }

    private void jComboBoxFontNameActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.getIReportFont().setFontName(this.jComboBoxFontName.getSelectedItem() + "");
    }

    private void jButtonOKActionPerformed1(ActionEvent evt) {
        IReportFont ifont = new IReportFont();
        this.setIReportFont(ifont, this.jTextFieldReportFont.isVisible());
    }

    private void jComboBoxReportFontsActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        if (this.jComboBoxReportFonts.getSelectedItem() != null && this.jComboBoxReportFonts.getSelectedItem() instanceof IReportFont) {
            IReportFont ifont = (IReportFont)((IReportFont)this.jComboBoxReportFonts.getSelectedItem()).clone();
            this.setIReportFont(ifont, false);
            ifont.getBeanProperties().clear();
            ifont.setReportFont(this.jComboBoxReportFonts.getSelectedItem() + "");
        }
    }

    private void jComboBoxPDFFontNameActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        if (this.jComboBoxPDFFontName.getSelectedItem() == null || (this.jComboBoxPDFFontName.getSelectedItem() + "").equals("")) {
            return;
        }
        Object obj = this.jComboBoxPDFFontName.getSelectedItem();
        String fontName = "" + obj;
        fontName = obj instanceof Tag ? "" + ((Tag)obj).getValue() : "" + obj;
        this.iReportFont.setPropertyValue("PDFFontName", fontName.length() > 0 ? fontName : null);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldReportFont.getText().trim().length() <= 0 && this.isReportFontMode()) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRFontDialog.notValidReportFontName", "Please insert a valid report font name!"), I18n.getString("messages.jRFontDialog.notValidReportFontNameCaption", "Invalid report font name!"), 2);
            return;
        }
        if (this.isReportFontMode()) {
            this.iReportFont.setReportFont(this.jTextFieldReportFont.getText());
        } else if (this.jComboBoxReportFonts.isVisible() && this.jComboBoxReportFonts.getSelectedItem() != null) {
            this.iReportFont.setReportFont(this.jComboBoxReportFonts.getSelectedItem() + "");
        }
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public IReportFont getIReportFont() {
        return this.iReportFont;
    }

    public void setIReportFont(IReportFont iReportFont) {
        this.setIReportFont(iReportFont, true);
    }

    public void setIReportFont(IReportFont iReportFont, boolean reportFontToo) {
        this.init = true;
        if (iReportFont == null) {
            iReportFont = new IReportFont();
        }
        this.iReportFont = iReportFont;
        if (reportFontToo) {
            this.jTextFieldReportFont.setText(new String(iReportFont.getReportFont()));
            if (iReportFont.getReportFont() != null && iReportFont.getReportFont().length() > 0) {
                for (int i = 0; i < this.jComboBoxReportFonts.getItemCount(); ++i) {
                    if (!(this.jComboBoxReportFonts.getItemAt(i) + "").equals(iReportFont.getReportFont())) continue;
                    this.jComboBoxReportFonts.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.jCheckBoxBold.setSelected(iReportFont.isBold());
        this.jCheckBoxItalic.setSelected(iReportFont.isItalic());
        this.jCheckBoxStrokeTrough.setSelected(iReportFont.isStrikeTrought());
        this.jCheckBoxPDFEmbedded.setSelected(iReportFont.isPdfEmbedded());
        this.jCheckBoxUnderline.setSelected(iReportFont.isUnderline());
        this.jCheckBoxDefaultFont.setSelected(iReportFont.isDefaultFont());
        this.setComboBoxText(true, iReportFont.getFontName(), this.jComboBoxFontName);
        this.setMixedTagComboBox(true, iReportFont.getPDFFontName(), this.jComboBoxPDFFontName);
        this.setElementComboNumber(true, iReportFont.getFontSize(), this.jNumberComboBoxSize);
        this.setPdfEncodingComboBox(true, iReportFont.getPdfEncoding(), this.jComboBoxPdfEncoding);
        this.init = false;
    }

    public void updateFonts(Vector iRFonts) {
        Vector<Tag> fontsVec = new Vector<Tag>();
        fontsVec.addElement(new Tag("Helvetica"));
        fontsVec.addElement(new Tag("Helvetica-Bold"));
        fontsVec.addElement(new Tag("Helvetica-BoldOblique"));
        fontsVec.addElement(new Tag("Helvetica-Oblique"));
        fontsVec.addElement(new Tag("Courier"));
        fontsVec.addElement(new Tag("Courier-Bold"));
        fontsVec.addElement(new Tag("Courier-BoldOblique"));
        fontsVec.addElement(new Tag("Courier-Oblique"));
        fontsVec.addElement(new Tag("Symbol"));
        fontsVec.addElement(new Tag("Times-Roman"));
        fontsVec.addElement(new Tag("Times-Bold"));
        fontsVec.addElement(new Tag("Times-BoldItalic"));
        fontsVec.addElement(new Tag("Times-Italic"));
        fontsVec.addElement(new Tag("ZapfDingbats"));
        fontsVec.addElement(new Tag("STSong-Light"));
        fontsVec.addElement(new Tag("MHei-Medium"));
        fontsVec.addElement(new Tag("MSung-Light"));
        fontsVec.addElement(new Tag("HeiseiKakuGo-W5"));
        fontsVec.addElement(new Tag("HeiseiMin-W3"));
        fontsVec.addElement(new Tag("HYGoThic-Medium"));
        fontsVec.addElement(new Tag("HYSMyeongJo-Medium"));
        Vector iRfonts = MainFrame.getMainInstance().getTtfFonts();
        for (int i_f = 0; i_f < iRfonts.size(); ++i_f) {
            fontsVec.addElement(new Tag(((IRFont)iRfonts.elementAt(i_f)).getFile(), iRfonts.elementAt(i_f) + ""));
        }
        Misc.updateComboBox(this.jComboBoxPDFFontName, fontsVec);
    }

    protected boolean setComboBoxText(boolean firstTime, String value, JComboBox comboField) {
        if (!firstTime && !Misc.nvl(comboField.getSelectedItem(), "").equalsIgnoreCase(value)) {
            comboField.setSelectedIndex(0);
            return false;
        }
        try {
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setMixedTagComboBox(boolean firstTime, Object value, JComboBox comboField) {
        if (firstTime) {
            try {
                for (int i = 0; i < comboField.getItemCount(); ++i) {
                    if (!(comboField.getItemAt(i) instanceof Tag) || !((Tag)comboField.getItemAt(i)).getValue().equals(value)) continue;
                    comboField.setSelectedIndex(i);
                    return true;
                }
                comboField.setSelectedItem(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Object selectedValue = comboField.getSelectedItem();
        if (selectedValue == null && value == null) {
            return true;
        }
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Tag) {
            selectedValue = ((Tag)selectedValue).getValue();
        }
        return selectedValue.equals(value);
    }

    protected boolean setPdfEncodingComboBox(boolean firstTime, String value, JComboBox comboField) {
        if (!(firstTime || comboField.getSelectedItem() != null && (comboField.getSelectedItem() instanceof PdfEncoding && ((PdfEncoding)comboField.getSelectedItem()).getEncoding().equalsIgnoreCase(value) || (comboField.getSelectedItem() + "").equals(value)))) {
            if (comboField.getItemCount() > 0) {
                comboField.setSelectedIndex(0);
            }
            return false;
        }
        try {
            for (int i = 0; i < comboField.getItemCount(); ++i) {
                if (!(comboField.getItemAt(i) instanceof PdfEncoding) || !((PdfEncoding)comboField.getItemAt(i)).getEncoding().equals(value)) continue;
                comboField.setSelectedIndex(i);
                return true;
            }
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setElementComboNumber(boolean firstTime, double value, JNumberComboBox numberField) {
        if (!firstTime && numberField.getValue() != value) {
            numberField.setSelectedItem("");
            return false;
        }
        try {
            numberField.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public boolean isReportFontMode() {
        return this.reportFontMode;
    }

    public void setReportFontMode(boolean reportFontMode) {
        this.setReportFontMode(reportFontMode ? 1 : 0);
    }

    public void setReportFontMode(int reportFontMode) {
        this.reportFontMode = reportFontMode == 1;
        this.jComboBoxReportFonts.setVisible(reportFontMode == 0);
        this.jTextFieldReportFont.setVisible(reportFontMode == 1);
        this.jCheckBoxDefaultFont.setEnabled(reportFontMode == 1);
        this.jLabel23.setVisible(reportFontMode != 3);
        if (this.jComboBoxReportFonts.getItemCount() == 0 && MainFrame.getMainInstance().getActiveReportFrame() != null) {
            Misc.updateComboBox(this.jComboBoxReportFonts, MainFrame.getMainInstance().getActiveReportFrame().getReport().getFonts(), true);
        }
    }

    public void applyI18n() {
        this.jCheckBoxBold.setText(I18n.getString("jRFontDialog.checkBoxBold", "Bold"));
        this.jCheckBoxItalic.setText(I18n.getString("jRFontDialog.checkBoxItalic", "Italic"));
        this.jCheckBoxPDFEmbedded.setText(I18n.getString("jRFontDialog.checkBoxPDFEmbedded", "PDF Embedded"));
        this.jCheckBoxStrokeTrough.setText(I18n.getString("jRFontDialog.checkBoxStrokeTrough", "Strike Trough"));
        this.jCheckBoxUnderline.setText(I18n.getString("jRFontDialog.checkBoxUnderline", "Underline"));
        this.jButtonCancel.setText(I18n.getString("jRFontDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("jRFontDialog.buttonOK", "OK"));
        this.jButtonResetAllToDefault.setText(I18n.getString("jRFontDialog.buttonResetAllToDefault", "Set all to default"));
        this.jLabel23.setText(I18n.getString("jRFontDialog.label23", "Report font"));
        this.jLabel24.setText(I18n.getString("jRFontDialog.label24", "Font name"));
        this.jLabel25.setText(I18n.getString("jRFontDialog.label25", "PDF font name"));
        this.jLabel27.setText(I18n.getString("jRFontDialog.label27", "Size"));
        this.jLabel32.setText(I18n.getString("jRFontDialog.label32", "PDF Encoding"));
        this.setTitle(I18n.getString("jRFontDialog.title", "Add/modify report font"));
        this.jButtonCancel.setMnemonic(I18n.getString("jRFontDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOK.setMnemonic(I18n.getString("jRFontDialog.buttonOKMnemonic", "o").charAt(0));
        this.jCheckBoxDefaultFont.setText(I18n.getString("jRFontDialog.checkBoxDefaultFont", "Default"));
    }
}

