/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXButton
extends JButton {
    private static JDialog invisibleParent = new JDialog();
    private static JStampButton stamp = new JStampButton();
    private static final Painter DEFAULT_BACKGROUND_PAINTER;
    private static final Painter DEFAULT_FOREGROUND_PAINTER;
    private Painter fgPainter = DEFAULT_FOREGROUND_PAINTER;
    private Painter bgPainter = DEFAULT_BACKGROUND_PAINTER;

    public JXButton() {
    }

    public JXButton(String text) {
        super(text);
    }

    public Painter getBackgroundPainter() {
        return this.bgPainter;
    }

    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        this.bgPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter getForegroundPainter() {
        return this.fgPainter;
    }

    public void setForegroundPainter(Painter p) {
        Painter old = this.getForegroundPainter();
        this.fgPainter = p;
        this.firePropertyChange("foregroundPainter", old, this.getForegroundPainter());
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Painter bgPainter = this.getBackgroundPainter();
        Painter fgPainter = this.getForegroundPainter();
        if (bgPainter == null && fgPainter == null) {
            super.paintComponent(g);
        } else {
            if (bgPainter != null) {
                bgPainter.paint((Graphics2D)g, this, this.getWidth(), this.getHeight());
            }
            if (fgPainter != null) {
                fgPainter.paint((Graphics2D)g, this, this.getWidth(), this.getHeight());
            }
        }
    }

    private static void copySettings(JButton src, JStampButton dest) {
        dest.setBounds(src.getBounds());
        dest.setText(src.getText());
        dest.setBackground(src.getBackground());
        dest.setForeground(src.getForeground());
        dest.setBorder(src.getBorder());
        dest.setBorderPainted(src.isBorderPainted());
        dest.setDefaultButton(src.isDefaultButton());
        dest.setDefaultCapable(src.isDefaultCapable());
        dest.setSelected(src.isSelected());
        dest.setMargin(src.getMargin());
        dest.setIcon(src.getIcon());
        dest.setPressedIcon(src.getPressedIcon());
        dest.setSelectedIcon(src.getSelectedIcon());
        dest.setRolloverIcon(src.getRolloverIcon());
        dest.setRolloverSelectedIcon(src.getRolloverSelectedIcon());
        dest.setDisabledIcon(src.getDisabledIcon());
        dest.setDisabledSelectedIcon(src.getDisabledSelectedIcon());
        dest.setVerticalAlignment(src.getVerticalAlignment());
        dest.setHorizontalAlignment(src.getHorizontalAlignment());
        dest.setVerticalTextPosition(src.getVerticalTextPosition());
        dest.setHorizontalTextPosition(src.getHorizontalTextPosition());
        dest.setIconTextGap(src.getIconTextGap());
        dest.setFocusPainted(src.isFocusPainted());
        dest.setContentAreaFilled(src.isContentAreaFilled());
        dest.setRolloverEnabled(src.isRolloverEnabled());
        dest.setMnemonic(src.getMnemonic());
        dest.setDisplayedMnemonicIndex(src.getDisplayedMnemonicIndex());
        dest.setModel(src.getModel());
        dest.setAlignmentY(src.getAlignmentY());
        dest.setAlignmentX(src.getAlignmentX());
    }

    static {
        invisibleParent.add(stamp);
        invisibleParent.setSize(1, 1);
        DEFAULT_BACKGROUND_PAINTER = new DefaultBackgroundPainter();
        DEFAULT_FOREGROUND_PAINTER = new DefaultForegroundPainter();
    }

    private static final class JStampButton
    extends JButton {
        private boolean isDefault = false;

        private JStampButton() {
        }

        public void setDefaultButton(boolean b) {
            this.isDefault = b;
        }

        public boolean isDefaultButton() {
            return this.isDefault;
        }

        public void setModel(final ButtonModel delegate) {
            super.setModel(new ButtonModel(){

                public boolean isArmed() {
                    return delegate.isArmed();
                }

                public boolean isSelected() {
                    return delegate.isSelected();
                }

                public boolean isEnabled() {
                    return delegate.isEnabled();
                }

                public boolean isPressed() {
                    return delegate.isPressed();
                }

                public boolean isRollover() {
                    return delegate.isRollover();
                }

                public void setArmed(boolean b) {
                }

                public void setSelected(boolean b) {
                }

                public void setEnabled(boolean b) {
                }

                public void setPressed(boolean b) {
                }

                public void setRollover(boolean b) {
                }

                public void setMnemonic(int i) {
                }

                public int getMnemonic() {
                    return delegate.getMnemonic();
                }

                public void setActionCommand(String string) {
                }

                public String getActionCommand() {
                    return delegate.getActionCommand();
                }

                public void setGroup(ButtonGroup buttonGroup) {
                }

                public void addActionListener(ActionListener actionListener) {
                }

                public void removeActionListener(ActionListener actionListener) {
                }

                public Object[] getSelectedObjects() {
                    return delegate.getSelectedObjects();
                }

                public void addItemListener(ItemListener itemListener) {
                }

                public void removeItemListener(ItemListener itemListener) {
                }

                public void addChangeListener(ChangeListener changeListener) {
                }

                public void removeChangeListener(ChangeListener changeListener) {
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultForegroundPainter
    extends AbstractPainter<JButton> {
        private DefaultForegroundPainter() {
        }

        @Override
        protected void doPaint(Graphics2D g, JButton b, int width, int height) {
            JXButton.copySettings(b, stamp);
            stamp.setSize(b.getWidth(), b.getHeight());
            stamp.setText(b.getText());
            stamp.setBorderPainted(false);
            stamp.setContentAreaFilled(false);
            stamp.paint(g);
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultBackgroundPainter
    extends AbstractPainter<JButton> {
        private DefaultBackgroundPainter() {
        }

        @Override
        protected void doPaint(Graphics2D g, JButton b, int width, int height) {
            JXButton.copySettings(b, stamp);
            stamp.setSize(b.getWidth(), b.getHeight());
            stamp.setText("");
            stamp.setBorderPainted(true);
            stamp.setContentAreaFilled(true);
            stamp.paint(g);
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }
}

