/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXLabel
extends JLabel {
    private Painter foregroundPainter;
    private Painter backgroundPainter;

    public JXLabel() {
        this.initPainterSupport();
    }

    public JXLabel(String text) {
        super(text);
        this.initPainterSupport();
    }

    private void initPainterSupport() {
        this.foregroundPainter = new AbstractPainter<JXLabel>(){

            @Override
            protected void doPaint(Graphics2D g, JXLabel component, int width, int height) {
                JXLabel.super.paintComponent(g);
            }
        };
    }

    public Painter getForegroundPainter() {
        return this.foregroundPainter;
    }

    public void setForegroundPainter(Painter painter) {
        Painter old = this.getForegroundPainter();
        this.foregroundPainter = painter;
        this.firePropertyChange("foregroundPainter", old, this.getForegroundPainter());
        this.repaint();
    }

    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        this.backgroundPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2;
        if (this.getBackgroundPainter() != null) {
            g2 = (Graphics2D)g.create();
            this.getBackgroundPainter().paint(g2, this, this.getWidth(), this.getHeight());
            g2.dispose();
        }
        if (this.getForegroundPainter() != null) {
            g2 = (Graphics2D)g.create();
            this.getForegroundPainter().paint(g2, this, this.getWidth(), this.getHeight());
            g2.dispose();
        }
        if (this.getBackgroundPainter() == null && this.getForegroundPainter() == null) {
            super.paintComponent(g);
        }
    }
}

