/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SizeRequirements;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.HeaderUI;
import org.jdesktop.swingx.plaf.PainterUIResource;

public class BasicHeaderUI
extends HeaderUI {
    protected JLabel titleLabel;
    protected JXEditorPane descriptionPane;
    protected JLabel imagePanel;
    private PropertyChangeListener propListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicHeaderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.installDefaults(header);
        this.titleLabel = new JLabel("Title For Header Goes Here");
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.descriptionPane = new JXEditorPane();
        String type = "text/plain";
        this.descriptionPane.setEditorKitForContentType(type, new WrappingPlainEditorKit());
        this.descriptionPane.setContentType(type);
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.setText("The description for the header goes here.\nExample: Click the Copy Code button to generate the corresponding Java code.");
        this.imagePanel = new JLabel();
        this.imagePanel.setIcon(UIManager.getIcon("Header.defaultIcon"));
        this.installComponents(header);
        this.installListeners(header);
    }

    public void uninstallUI(JComponent c) {
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.uninstallDefaults(header);
        this.uninstallListeners(header);
        this.uninstallComponents(header);
        this.titleLabel = null;
        this.descriptionPane = null;
        this.imagePanel = null;
    }

    protected void installDefaults(JXHeader h) {
        Painter p = h.getBackgroundPainter();
        if (p == null || p instanceof PainterUIResource) {
            h.setBackgroundPainter(this.createBackgroundPainter());
        }
    }

    protected void uninstallDefaults(JXHeader h) {
    }

    protected void installListeners(final JXHeader h) {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BasicHeaderUI.this.onPropertyChange(h, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        h.addPropertyChangeListener(this.propListener);
    }

    protected void uninstallListeners(JXHeader h) {
        h.removePropertyChangeListener(this.propListener);
    }

    protected void onPropertyChange(JXHeader h, String propertyName, Object oldValue, Object newValue) {
        if ("title".equals(propertyName)) {
            this.titleLabel.setText(h.getTitle());
        } else if ("description".equals(propertyName)) {
            this.descriptionPane.setText(h.getDescription());
        } else if ("icon".equals(propertyName)) {
            this.imagePanel.setIcon(h.getIcon());
        } else if ("enabled".equals(propertyName)) {
            boolean enabled = h.isEnabled();
            this.titleLabel.setEnabled(enabled);
            this.descriptionPane.setEnabled(enabled);
            this.imagePanel.setEnabled(enabled);
        } else if ("titleFont".equals(propertyName)) {
            this.titleLabel.setFont((Font)newValue);
        } else if ("descriptionFont".equals(propertyName)) {
            this.descriptionPane.setFont((Font)newValue);
        }
    }

    protected void installComponents(JXHeader h) {
        h.setLayout(new GridBagLayout());
        h.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
        h.add((Component)this.descriptionPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 24, 12, 11), 0, 0));
        h.add((Component)this.imagePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 0, 11, 11), 0, 0));
    }

    protected void uninstallComponents(JXHeader h) {
        h.remove(this.titleLabel);
        h.remove(this.descriptionPane);
        h.remove(this.imagePanel);
    }

    protected Painter createBackgroundPainter() {
        MattePainter p = new MattePainter(new GradientPaint(0.0f, 0.0f, Color.WHITE, 1.0f, 0.0f, UIManager.getColor("control")));
        p.setPaintStretched(true);
        return new PainterUIResource(p);
    }

    static class WrappingPlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        WrappingPlainEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return this;
        }

        public View create(Element elem) {
            Document doc = elem.getDocument();
            Object i18nFlag = doc.getProperty("i18n");
            if (i18nFlag != null && i18nFlag.equals(Boolean.TRUE)) {
                return this.createI18N(elem);
            }
            return new WrappedPlainView(elem, true);
        }

        View createI18N(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new PlainParagraph(elem);
                }
                if (kind.equals("paragraph")) {
                    return new BoxView(elem, 1);
                }
            }
            return null;
        }

        static class PlainParagraph
        extends ParagraphView {
            PlainParagraph(Element elem) {
                super(elem);
                this.layoutPool = new LogicalView(elem);
                this.layoutPool.setParent(this);
            }

            protected void setPropertiesFromAttributes() {
                Container c = this.getContainer();
                if (c != null && !c.getComponentOrientation().isLeftToRight()) {
                    this.setJustification(2);
                } else {
                    this.setJustification(0);
                }
            }

            public int getFlowSpan(int index) {
                JTextArea area;
                Container c = this.getContainer();
                if (c instanceof JTextArea && !(area = (JTextArea)c).getLineWrap()) {
                    return Integer.MAX_VALUE;
                }
                return super.getFlowSpan(index);
            }

            protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
                JTextArea area;
                SizeRequirements req = super.calculateMinorAxisRequirements(axis, r);
                Container c = this.getContainer();
                if (c instanceof JTextArea && !(area = (JTextArea)c).getLineWrap()) {
                    req.minimum = req.preferred;
                }
                return req;
            }

            static class LogicalView
            extends CompositeView {
                LogicalView(Element elem) {
                    super(elem);
                }

                protected int getViewIndexAtPosition(int pos) {
                    Element elem = this.getElement();
                    if (elem.getElementCount() > 0) {
                        return elem.getElementIndex(pos);
                    }
                    return 0;
                }

                protected boolean updateChildren(DocumentEvent.ElementChange ec, DocumentEvent e, ViewFactory f) {
                    return false;
                }

                protected void loadChildren(ViewFactory f) {
                    Element elem = this.getElement();
                    if (elem.getElementCount() > 0) {
                        super.loadChildren(f);
                    } else {
                        GlyphView v = new GlyphView(elem);
                        this.append(v);
                    }
                }

                public float getPreferredSpan(int axis) {
                    if (this.getViewCount() != 1) {
                        throw new Error("One child view is assumed.");
                    }
                    View v = this.getView(0);
                    return v.getPreferredSpan(axis);
                }

                protected void forwardUpdateToView(View v, DocumentEvent e, Shape a, ViewFactory f) {
                    v.setParent(this);
                    super.forwardUpdateToView(v, e, a, f);
                }

                public void paint(Graphics g, Shape allocation) {
                }

                protected boolean isBefore(int x, int y, Rectangle alloc) {
                    return false;
                }

                protected boolean isAfter(int x, int y, Rectangle alloc) {
                    return false;
                }

                protected View getViewAtPoint(int x, int y, Rectangle alloc) {
                    return null;
                }

                protected void childAllocation(int index, Rectangle a) {
                }
            }
        }
    }
}

