/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.beans.PropertyEditor;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

public class CustomEditorConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Map customEditors;
    static /* synthetic */ Class class$java$beans$PropertyEditor;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setCustomEditors(Map customEditors) {
        this.customEditors = customEditors;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.customEditors != null) {
            Iterator it = this.customEditors.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Class requiredType = null;
                if (key instanceof Class) {
                    requiredType = (Class)key;
                } else if (key instanceof String) {
                    String className = (String)key;
                    try {
                        requiredType = ClassUtils.forName(className);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new BeanInitializationException("Could not load required type [" + className + "] for custom editor", ex);
                    }
                } else {
                    throw new BeanInitializationException("Invalid key [" + key + "] for custom editor - needs to be Class or String");
                }
                Object value = this.customEditors.get(key);
                if (!(value instanceof PropertyEditor)) {
                    throw new BeanInitializationException("Mapped value [" + value + "] for custom editor key [" + key + "] is not of required type [" + (class$java$beans$PropertyEditor == null ? (class$java$beans$PropertyEditor = CustomEditorConfigurer.class$("java.beans.PropertyEditor")) : class$java$beans$PropertyEditor).getName() + "]");
                }
                beanFactory.registerCustomEditor(requiredType, (PropertyEditor)value);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

