/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;

public class FileEditor
extends PropertyEditorSupport {
    private final ResourceEditor resourceEditor;

    public FileEditor() {
        this.resourceEditor = new ResourceEditor();
    }

    public FileEditor(ResourceEditor resourceEditor) {
        this.resourceEditor = resourceEditor;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.resourceEditor.setAsText(text);
        Resource resource = (Resource)this.resourceEditor.getValue();
        try {
            this.setValue(resource != null ? resource.getFile() : null);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not retrieve File for " + resource + ": " + ex.getMessage());
        }
    }

    public String getAsText() {
        File value = (File)this.getValue();
        return value != null ? value.getPath() : "";
    }
}

