/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.gui.JRPropertyDialog;
import it.businesslogic.ireport.gui.table.CustomColumnControlButton;
import it.businesslogic.ireport.gui.table.JDragTable;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.icon.ColumnControlIcon;

public class PropertiesDialog
extends JDialog {
    private int dialogResult = 2;
    private List properties = null;
    private JButton jButtonCancel;
    private JButton jButtonDeleteProperty;
    private JButton jButtonModifyProperty;
    private JButton jButtonNewProperty;
    private JButton jButtonOk;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelButtons2;
    private JPanel jPanelFields;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JDragTable jTableProperties;

    public PropertiesDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public PropertiesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.setSize(420, 250);
        this.jTableProperties.setColumnControl((JComponent)((Object)new CustomColumnControlButton(this.jTableProperties, (Icon)new ColumnControlIcon())));
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableProperties.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PropertiesDialog.this.jTablePropertiesListSelectionValueChanged(e);
            }
        });
        this.applyI18n();
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PropertiesDialog.this.jButtonOkActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOk);
    }

    public void jTablePropertiesListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableProperties.getSelectedRowCount() > 0) {
            this.jButtonModifyProperty.setEnabled(true);
            this.jButtonDeleteProperty.setEnabled(true);
        } else {
            this.jButtonModifyProperty.setEnabled(false);
            this.jButtonDeleteProperty.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelFields = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableProperties = new JDragTable();
        this.jPanelButtons2 = new JPanel();
        this.jButtonNewProperty = new JButton();
        this.jButtonModifyProperty = new JButton();
        this.jButtonDeleteProperty = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("Values");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PropertiesDialog.this.closeDialog(evt);
            }
        });
        this.jPanelFields.setLayout(new BorderLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jScrollPane3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PropertiesDialog.this.jScrollPane3MouseClicked(evt);
            }
        });
        this.jTableProperties.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableProperties.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PropertiesDialog.this.jTablePropertiesMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView((Component)((Object)this.jTableProperties));
        this.jPanelFields.add((Component)this.jScrollPane3, "Center");
        this.jPanelButtons2.setLayout(new GridBagLayout());
        this.jPanelButtons2.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons2.setPreferredSize(new Dimension(100, 100));
        this.jButtonNewProperty.setText("New");
        this.jButtonNewProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertiesDialog.this.jButtonNewPropertyActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonNewProperty, gridBagConstraints);
        this.jButtonModifyProperty.setText("Modify");
        this.jButtonModifyProperty.setEnabled(false);
        this.jButtonModifyProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertiesDialog.this.jButtonModifyPropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonModifyProperty, gridBagConstraints);
        this.jButtonDeleteProperty.setText("Delete");
        this.jButtonDeleteProperty.setEnabled(false);
        this.jButtonDeleteProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertiesDialog.this.jButtonDeletePropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelButtons2.add((Component)this.jButtonDeleteProperty, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanelButtons2.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanelFields.add((Component)this.jPanelButtons2, "East");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.jButtonOk.setMnemonic('o');
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertiesDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertiesDialog.this.jButtonCloseActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jPanelFields.add((Component)this.jPanel2, "South");
        this.getContentPane().add((Component)this.jPanelFields, "Center");
        this.pack();
    }

    private void jButtonCloseActionPerformed1(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        this.properties = new ArrayList();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            this.properties.add(dtm.getValueAt(i, 0));
        }
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    private void jScrollPane3MouseClicked(MouseEvent evt) {
    }

    private void jTablePropertiesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableProperties.getSelectedRow() >= 0) {
                this.jButtonModifyPropertyActionPerformed(new ActionEvent(this.jButtonModifyProperty, 0, ""));
            }
        }
    }

    private void jButtonNewPropertyActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        JRPropertyDialog jrpd = new JRPropertyDialog(parent, true);
        jrpd.setVisible(true);
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        if (jrpd.getDialogResult() == 0) {
            JRProperty property = jrpd.getProperty();
            dtm.addRow(new Object[]{property, property.getValue()});
            this.jTableProperties.updateUI();
        }
    }

    private void jButtonModifyPropertyActionPerformed(ActionEvent evt) {
        int index = this.jTableProperties.getSelectedRow();
        index = this.jTableProperties.convertRowIndexToModel(index);
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        JRProperty property = (JRProperty)dtm.getValueAt(index, 0);
        Frame parent = Misc.frameFromComponent(this);
        JRPropertyDialog jrpd = new JRPropertyDialog(parent, true);
        jrpd.setProperty(property);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            property.setName(jrpd.getProperty().getName());
            property.setValue(jrpd.getProperty().getValue());
            dtm.setValueAt(property, index, 0);
            dtm.setValueAt(property.getValue(), index, 1);
            this.jTableProperties.updateUI();
        }
    }

    private void jButtonDeletePropertyActionPerformed(ActionEvent evt) {
        int[] rows = this.jTableProperties.getSelectedRows();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        for (int i = rows.length - 1; i >= 0; --i) {
            dtm.removeRow(this.jTableProperties.convertRowIndexToModel(rows[i]));
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public void setProperties(List properties) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        dtm.setRowCount(0);
        for (JRProperty property : properties) {
            JRProperty property2 = property.cloneMe();
            Vector<Object> row = new Vector<Object>();
            row.addElement(property2);
            row.addElement(property2.getValue());
            dtm.addRow(row);
        }
    }

    public void applyI18n() {
        this.jButtonNewProperty.setText(I18n.getString("new", "New"));
        this.jButtonModifyProperty.setText(I18n.getString("modify", "Modify"));
        this.jButtonDeleteProperty.setText(I18n.getString("delete", "Delete"));
        this.jButtonCancel.setText(I18n.getString("jRFieldDialog.buttonCancel", "Cancel"));
        this.jButtonOk.setText(I18n.getString("jRFieldDialog.buttonOK", "OK"));
        this.jTableProperties.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("propertiesDialog.tablecolumn.name", "Name"));
        this.jTableProperties.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("propertiesDialog.tablecolumn.value", "Value"));
        this.setTitle(I18n.getString("propertiesDialog.title", "Properties"));
        this.jButtonCancel.setMnemonic(I18n.getString("jRFieldDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOk.setMnemonic(I18n.getString("jRFieldDialog.buttonOKMnemonic", "o").charAt(0));
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public List getProperties() {
        return this.properties;
    }
}

