/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.babylon;

import com.jaspersoft.babylon.JasperBabylonException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class JasperBabylonClient {
    private String appId = "1";
    private String jasperBabylonUrl = "http://127.0.0.1/jasperbabylon";
    private String username = "";
    private String password = "";

    public List listLocales() throws JasperBabylonException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (!this.jasperBabylonUrl.endsWith("/")) {
                this.jasperBabylonUrl = this.jasperBabylonUrl + "/";
            }
            URL url = new URL(this.jasperBabylonUrl + "listlocales.php?appid=" + this.getAppId());
            URLConnection uConn = url.openConnection();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(uConn.getInputStream()));
            String s = null;
            while ((s = lnr.readLine()) != null) {
                if (s.startsWith("-")) {
                    throw new JasperBabylonException(s.substring(1));
                }
                if (s.trim().length() == 0) continue;
                list.add(s);
            }
        }
        catch (JasperBabylonException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JasperBabylonException(ex.getMessage());
        }
        return list;
    }

    public Properties getLocale(String localeId) throws JasperBabylonException {
        Properties props = new Properties();
        try {
            if (!this.jasperBabylonUrl.endsWith("/")) {
                this.jasperBabylonUrl = this.jasperBabylonUrl + "/";
            }
            URL url = new URL(this.jasperBabylonUrl + "getlocale.php?appid=" + this.getAppId() + "&lang=" + localeId);
            URLConnection uConn = url.openConnection();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(uConn.getInputStream(), "UTF-8"));
            String s = null;
            String lastkey = "";
            while ((s = lnr.readLine()) != null) {
                if (s.startsWith("-")) {
                    throw new JasperBabylonException(s.substring(1));
                }
                if (s.trim().length() == 0) continue;
                if (s.indexOf("=") <= 0) {
                    throw new JasperBabylonException("Invalid locale entry:\n\n" + s + " before entry: " + lastkey);
                }
                int pstop = s.indexOf("=");
                String key = s.substring(0, pstop);
                String value = s.substring(pstop + 1);
                props.setProperty(key, value);
                lastkey = key;
            }
        }
        catch (JasperBabylonException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JasperBabylonException(ex.getMessage());
        }
        return props;
    }

    public String putLocale(String localeId, Properties props) throws JasperBabylonException {
        String message = "";
        try {
            if (!this.jasperBabylonUrl.endsWith("/")) {
                this.jasperBabylonUrl = this.jasperBabylonUrl + "/";
            }
            URL url = new URL(this.jasperBabylonUrl + "sendkeys.php");
            String data = "";
            data = URLEncoder.encode("appid", "UTF-8") + "=" + URLEncoder.encode(this.getAppId(), "UTF-8");
            data = data + "&" + URLEncoder.encode("language", "UTF-8") + "=" + URLEncoder.encode(localeId, "UTF-8");
            data = data + "&" + URLEncoder.encode("email", "UTF-8") + "=" + URLEncoder.encode(this.getUsername(), "UTF-8");
            data = data + "&" + URLEncoder.encode("password", "UTF-8") + "=" + URLEncoder.encode(this.getPassword(), "UTF-8");
            Enumeration<Object> kenum = props.keys();
            int i = 1;
            while (kenum.hasMoreElements()) {
                String key = "" + kenum.nextElement();
                String value = props.getProperty(key);
                value.replace("\n", "\\n");
                value.replace("\r", "\\r");
                data = data + "&" + URLEncoder.encode("key" + i, "UTF-8") + "=" + URLEncoder.encode(key, "UTF-8");
                data = data + "&" + URLEncoder.encode("value" + i, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
                ++i;
            }
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String s = null;
            while ((s = lnr.readLine()) != null) {
                if (s.startsWith("-")) {
                    throw new JasperBabylonException(s.substring(1));
                }
                if (s.trim().length() == 0) continue;
                message = message + s;
            }
            wr.close();
            lnr.close();
        }
        catch (JasperBabylonException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JasperBabylonException(ex.getMessage());
        }
        return message;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getJasperBabylonUrl() {
        return this.jasperBabylonUrl;
    }

    public void setJasperBabylonUrl(String jasperBabylonUrl) {
        this.jasperBabylonUrl = jasperBabylonUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

