/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.swtgui;

import net.charabia.jsmoothgen.application.swtgui.JSmoothResources;
import net.charabia.jsmoothgen.application.swtgui.Util;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProjectFileWizardPage
extends WizardPage {
    private static final String STR_BROWSE = "Browse...";
    private static final String STR_DESCRIPTION_MESSAGE = "Create a new JSmooth project.";
    private Text txtProjectFile;
    private Button btnBrowse;

    public ProjectFileWizardPage() {
        super("wizard.project_file");
        this.setTitle("JSmooth Project");
        this.setMessage(STR_DESCRIPTION_MESSAGE);
        String key = "img.new_project_wizban";
        this.setImageDescriptor(JSmoothResources.getDescriptor(key));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Project file:");
        GridData layoutData = new GridData(4);
        label.setLayoutData((Object)layoutData);
        this.txtProjectFile = new Text(composite, 2048);
        layoutData = new GridData(768);
        this.txtProjectFile.setLayoutData((Object)layoutData);
        this.txtProjectFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectFileWizardPage.this.projectFileModified();
            }
        });
        this.btnBrowse = new Button(composite, 0);
        this.btnBrowse.setSize(Util.computeWidth((Control)this.btnBrowse, STR_BROWSE), -1);
        this.btnBrowse.setText(STR_BROWSE);
        layoutData = new GridData(4);
        layoutData.widthHint = this.btnBrowse.getSize().x;
        this.btnBrowse.setLayoutData((Object)layoutData);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectFileWizardPage.this.browseSelected();
            }
        });
        this.setPageComplete(!this.isFileEmpty());
        this.setControl((Control)composite);
    }

    private void projectFileModified() {
        this.setPageComplete(!this.isFileEmpty());
        this.setNewProjectWizardMessage();
    }

    private void browseSelected() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        String file = dialog.open();
        if (file != null) {
            this.txtProjectFile.setText(file);
        }
    }

    private boolean isFileEmpty() {
        String fileText = this.txtProjectFile.getText();
        return fileText.trim().length() == 0;
    }

    private void setNewProjectWizardMessage() {
        if (this.isFileEmpty()) {
            this.setMessage("File name must be specified.");
        } else {
            this.setMessage(STR_DESCRIPTION_MESSAGE);
        }
    }
}

