/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.Cursor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.sql.Date;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.ContentView;
import nickyb.sqleonardo.environment.ctrl.content.JumpManager;
import nickyb.sqleonardo.environment.ctrl.content.LineNumberView;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public class ContentPopup
extends JPopupMenu
implements MouseListener {
    private ContentView view;
    private boolean bAllCols;
    private boolean bAllRows;

    ContentPopup(ContentView view) {
        this.view = view;
        this.add(new ActionCopySpecial());
        this.addSeparator();
        this.add(new ActionCopy());
        this.add(new ActionPaste());
        this.addSeparator();
        this.add(new ActionSetNull());
        this.add(new ActionSetToday());
        this.add(new ActionResetOldValue());
        this.add(new ActionTrim());
        this.addSeparator();
        this.add(new ActionClone());
        JMenuItem iRi = this.add(view.getControl().getActionMap().get("record-insert"));
        JMenuItem iRd = this.add(view.getControl().getActionMap().get("record-delete"));
        this.addSeparator();
        this.add("save record").setEnabled(false);
        this.addSeparator();
        this.add(new ActionJump());
        this.addSeparator();
        this.add(new ActionSortAsc());
        this.add(new ActionSortDesc());
        iRi.setToolTipText(null);
        iRi.setIcon(null);
        iRd.setToolTipText(null);
        iRd.setIcon(null);
    }

    protected MenuElement getSubElementsAt(int index) {
        return this.getSubElements()[index];
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        if (me.getSource() instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)me.getSource();
            int row = this.view.getCurrentRow() == -1 && this.view.getRowCount() > 0 ? 0 : this.view.getCurrentRow();
            int col = header.columnAtPoint(me.getPoint());
            if (row == -1 || col == -1) {
                return;
            }
            this.view.setSelectedCell(row, col);
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (this.view.getControl().isBusy()) {
            return;
        }
        this.bAllCols = false;
        this.bAllRows = false;
        if (SwingUtilities.isRightMouseButton(me)) {
            int row = -1;
            int col = -1;
            if (me.getSource() instanceof JTable) {
                JTable jtable = (JTable)me.getSource();
                row = jtable.rowAtPoint(me.getPoint());
                col = jtable.columnAtPoint(me.getPoint());
                this.bAllCols = jtable instanceof LineNumberView;
            } else if (me.getSource() instanceof JTableHeader) {
                JTableHeader header = (JTableHeader)me.getSource();
                row = this.view.getCurrentRow();
                col = header.columnAtPoint(me.getPoint());
                this.bAllRows = true;
            } else {
                row = this.view.getCurrentRow();
                col = this.view.getCurrentColumn();
            }
            if (row == -1 || col == -1) {
                return;
            }
            this.view.setSelectedCell(row, col);
            this.getComponent(9).setVisible(this.bAllCols);
            this.getComponent(10).setVisible(this.bAllCols);
            this.getComponent(11).setVisible(this.bAllCols);
            this.getComponent(12).setVisible(this.bAllCols);
            this.getComponent(13).setVisible(this.bAllCols);
            this.getComponent(14).setVisible(this.bAllCols);
            this.getComponent(15).setVisible(!this.bAllCols && !this.bAllRows);
            this.getComponent(16).setVisible(!this.bAllCols && !this.bAllRows);
            this.getComponent(17).setVisible(this.bAllRows);
            this.getComponent(18).setVisible(this.bAllRows);
            this.getComponent(19).setVisible(this.bAllRows);
            this.show((JComponent)me.getSource(), me.getX(), me.getY());
        }
    }

    private class ActionJump
    extends AbstractAction {
        ActionJump() {
            this.putValue("Name", "jump...");
            this.setEnabled(!ContentPopup.this.view.getControl().isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            JumpManager.perform(ContentPopup.this.view.getControl());
        }
    }

    private class ActionSortDesc
    extends AbstractActionSort {
        ActionSortDesc() {
            super("sort descending");
        }

        short getType() {
            return 1;
        }
    }

    private class ActionSortAsc
    extends AbstractActionSort {
        ActionSortAsc() {
            super("sort ascending");
        }

        short getType() {
            return 0;
        }
    }

    private abstract class AbstractActionSort
    extends AbstractAction {
        AbstractActionSort(String name) {
            this.putValue("Name", name);
        }

        abstract short getType();

        public void actionPerformed(ActionEvent ae) {
            ContentPopup.this.view.getControl().setCursor(new Cursor(3));
            ContentPopup.this.view.sort(ContentPopup.this.view.getCurrentColumn(), this.getType());
            ContentPopup.this.view.onTableChanged(true);
            ContentPopup.this.view.getControl().setCursor(new Cursor(0));
        }
    }

    private class ActionResetOldValue
    extends AbstractAction {
        ActionResetOldValue() {
            this.putValue("Name", "reset <old-value>");
            this.setEnabled(!ContentPopup.this.view.getControl().isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            int col = ContentPopup.this.view.getCurrentColumn();
            int row = ContentPopup.this.view.getCurrentRow();
            if (ContentPopup.this.bAllCols) {
                for (int i = 0; i < ContentPopup.this.view.getColumnCount(); ++i) {
                    ContentPopup.this.view.resetFlatValueAt(row, i);
                }
            } else if (ContentPopup.this.bAllRows) {
                for (int i = 0; i < ContentPopup.this.view.getFlatRowCount(); ++i) {
                    ContentPopup.this.view.resetFlatValueAt(i, col);
                }
            } else {
                ContentPopup.this.view.resetCellValue();
            }
            if (ContentPopup.this.bAllCols || ContentPopup.this.bAllRows) {
                ContentPopup.this.view.onTableChanged(true);
                ContentPopup.this.view.setSelectedCell(row, col);
            }
        }
    }

    private class ActionSetToday
    extends AbstractActionSet {
        ActionSetToday() {
            super("set <today>");
        }

        Object getValue() {
            return new Date(System.currentTimeMillis());
        }
    }

    private class ActionSetNull
    extends AbstractActionSet {
        ActionSetNull() {
            super("set <null>");
        }

        Object getValue() {
            return null;
        }
    }

    private abstract class AbstractActionSet
    extends AbstractAction {
        AbstractActionSet(String name) {
            this.putValue("Name", name);
            this.setEnabled(!ContentPopup.this.view.getControl().isReadOnly());
        }

        abstract Object getValue();

        public void actionPerformed(ActionEvent ae) {
            int col = ContentPopup.this.view.getCurrentColumn();
            int row = ContentPopup.this.view.getCurrentRow();
            if (ContentPopup.this.bAllCols) {
                for (int i = 0; i < ContentPopup.this.view.getColumnCount(); ++i) {
                    ContentPopup.this.view.setValueAt(this.getValue(), row, i);
                }
            } else if (ContentPopup.this.bAllRows) {
                for (int i = 0; i < ContentPopup.this.view.getFlatRowCount(); ++i) {
                    ContentPopup.this.view.setFlatValueAt(this.getValue(), i, col);
                }
            } else {
                ContentPopup.this.view.setCellValue(this.getValue());
            }
            if (ContentPopup.this.bAllCols || ContentPopup.this.bAllRows) {
                ContentPopup.this.view.onTableChanged(true);
                ContentPopup.this.view.setSelectedCell(row, col);
            }
        }
    }

    private class ActionTrim
    extends AbstractAction {
        ActionTrim() {
            this.putValue("Name", "trim trailing spaces");
            this.setEnabled(!ContentPopup.this.view.getControl().isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            int col = ContentPopup.this.view.getCurrentColumn();
            int row = ContentPopup.this.view.getCurrentRow();
            if (ContentPopup.this.bAllCols) {
                for (int i = 0; i < ContentPopup.this.view.getColumnCount(); ++i) {
                    Object cell = ContentPopup.this.view.getValueAt(row, i);
                    cell = cell == null ? null : cell.toString().trim();
                    ContentPopup.this.view.setValueAt(cell, row, i);
                }
            } else if (ContentPopup.this.bAllRows) {
                for (int i = 0; i < ContentPopup.this.view.getFlatRowCount(); ++i) {
                    Object cell = ContentPopup.this.view.getFlatValueAt(i, col);
                    cell = cell == null ? null : cell.toString().trim();
                    ContentPopup.this.view.setFlatValueAt(cell, i, col);
                }
            } else {
                Object cell = ContentPopup.this.view.getCellValue();
                cell = cell == null ? null : cell.toString().trim();
                ContentPopup.this.view.setCellValue(cell);
            }
            if (ContentPopup.this.bAllCols || ContentPopup.this.bAllRows) {
                ContentPopup.this.view.onTableChanged(true);
                ContentPopup.this.view.setSelectedCell(row, col);
            }
        }
    }

    private class ActionClone
    extends AbstractAction {
        ActionClone() {
            this.putValue("Name", "clone record");
            this.setEnabled(!ContentPopup.this.view.getControl().isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            int row = ContentPopup.this.view.getCurrentRow();
            ContentPopup.this.view.insertRow(++row);
            for (int i = 0; i < ContentPopup.this.view.getColumnCount(); ++i) {
                Object source = ContentPopup.this.view.getValueAt(row - 1, i);
                String clone = source == null ? null : new String(source.toString());
                ContentPopup.this.view.setValueAt(clone, row, i);
            }
        }
    }

    private class ActionPaste
    extends AbstractActionSet {
        ActionPaste() {
            super("paste");
            this.setEnabled(!ContentPopup.this.view.getControl().isReadOnly());
        }

        Object getValue() {
            try {
                Clipboard cb = ContentPopup.this.getToolkit().getSystemClipboard();
                return cb.getContents(null).getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ufe) {
                Application.println(ufe, false);
            }
            catch (IOException ioe) {
                Application.println(ioe, false);
            }
            return null;
        }
    }

    private class ActionCopy
    extends AbstractAction {
        ActionCopy() {
            super("copy");
        }

        public void actionPerformed(ActionEvent ae) {
            Object cell;
            int i;
            int col = ContentPopup.this.view.getCurrentColumn();
            int row = ContentPopup.this.view.getCurrentRow();
            Object value = ContentPopup.this.view.getValueAt(row, col);
            if (ContentPopup.this.bAllCols) {
                for (i = 0; i < ContentPopup.this.view.getColumnCount(); ++i) {
                    cell = ContentPopup.this.view.getValueAt(row, i);
                    value = i == 0 ? cell : value + "\t" + cell;
                }
            } else if (ContentPopup.this.bAllRows) {
                for (i = 0; i < ContentPopup.this.view.getFlatRowCount(); ++i) {
                    cell = ContentPopup.this.view.getFlatValueAt(i, col);
                    value = i == 0 ? cell : value + "\n" + cell;
                }
            }
            if (value == null) {
                return;
            }
            Clipboard cb = ContentPopup.this.getToolkit().getSystemClipboard();
            StringSelection contents = new StringSelection(value.toString());
            cb.setContents(contents, Application.defaultClipboardOwner);
        }
    }

    private class ActionCopySpecial
    extends AbstractAction {
        ActionCopySpecial() {
            this.putValue("Name", "copy special");
        }

        public void actionPerformed(ActionEvent ae) {
            int col = ContentPopup.this.view.getCurrentColumn();
            int row = ContentPopup.this.view.getCurrentRow();
            String value = this.getValueAt(row, col);
            if (ContentPopup.this.bAllCols) {
                String fields = new String();
                String values = new String();
                for (int i = 0; i < ContentPopup.this.view.getColumnCount(); ++i) {
                    fields = i == 0 ? ContentPopup.this.view.getColumnName(i) : fields + "," + ContentPopup.this.view.getColumnName(i);
                    values = i == 0 ? this.getValueAt(row, i) : values + "," + this.getValueAt(row, i);
                }
                value = "INSERT INTO <tablename> (" + fields + ") VALUES (" + values + ");";
            } else if (ContentPopup.this.bAllRows) {
                for (int i = 0; i < ContentPopup.this.view.getFlatRowCount(); ++i) {
                    String cell = this.getFlatValueAt(i, col);
                    value = i == 0 ? cell : value + "," + cell;
                }
            }
            if (value == null) {
                return;
            }
            Clipboard cb = ContentPopup.this.getToolkit().getSystemClipboard();
            StringSelection contents = new StringSelection(value.toString());
            cb.setContents(contents, Application.defaultClipboardOwner);
        }

        String getValueAt(int row, int col) {
            Object cell = ContentPopup.this.view.getValueAt(row, col);
            return this.toJdbcValue(cell, col);
        }

        String getFlatValueAt(int row, int col) {
            Object cell = ContentPopup.this.view.getFlatValueAt(row, col);
            return this.toJdbcValue(cell, col);
        }

        private String toJdbcValue(Object value, int col) {
            return SQLFormatter.toJdbcValue(value, ContentPopup.this.view.getColumnType(col));
        }
    }
}

