/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder.syntax;

import java.util.ArrayList;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public class QuerySpecification {
    public static final short ALL = 1;
    public static final short DISTINCT = 2;
    public static final short NONE = 0;
    private short quantifier = 0;
    private boolean asterisk = false;
    private ArrayList selectList = new ArrayList();
    private ArrayList fromClause = new ArrayList();
    private ArrayList whereClause = new ArrayList();
    private ArrayList groupClause = new ArrayList();
    private ArrayList havingClause = new ArrayList();

    public void addSelectList(QueryTokens._Expression token) {
        this.asterisk = false;
        this.selectList.add(token);
    }

    public void addFromClause(QueryTokens._TableReference token) {
        this.fromClause.add(token);
    }

    public void addWhereClause(QueryTokens.Condition token) {
        this.whereClause.add(token);
    }

    public void addGroupByClause(QueryTokens.Group token) {
        this.groupClause.add(token);
    }

    public void addHavingClause(QueryTokens.Condition token) {
        this.havingClause.add(token);
    }

    public QueryTokens._Expression[] getSelectList() {
        QueryTokens._Expression[] a = new QueryTokens._Expression[this.selectList.size()];
        return this.selectList.toArray(a);
    }

    public QueryTokens._TableReference[] getFromClause() {
        QueryTokens._TableReference[] a = new QueryTokens._TableReference[this.fromClause.size()];
        return this.fromClause.toArray(a);
    }

    public QueryTokens.Condition[] getWhereClause() {
        QueryTokens.Condition[] a = new QueryTokens.Condition[this.whereClause.size()];
        return this.whereClause.toArray(a);
    }

    public QueryTokens.Group[] getGroupByClause() {
        QueryTokens.Group[] a = new QueryTokens.Group[this.groupClause.size()];
        return this.groupClause.toArray(a);
    }

    public QueryTokens.Condition[] getHavingClause() {
        QueryTokens.Condition[] a = new QueryTokens.Condition[this.havingClause.size()];
        return this.havingClause.toArray(a);
    }

    public void removeSelectList(QueryTokens._Expression token) {
        this.selectList.remove(token);
    }

    public void removeFromClause(QueryTokens._TableReference token) {
        this.fromClause.remove(token);
    }

    public void removeWhereClause(QueryTokens.Condition token) {
        this.whereClause.remove(token);
    }

    public void removeGroupByClause(QueryTokens.Group token) {
        this.groupClause.remove(token);
    }

    public void removeHavingClause(QueryTokens.Condition token) {
        this.havingClause.remove(token);
    }

    public boolean isAsteriskSet() {
        return this.asterisk;
    }

    public void setAsterisk(boolean b) {
        this.asterisk = b;
    }

    public short getQuantifier() {
        return this.quantifier;
    }

    public void setQuantifier(short q) {
        this.quantifier = q;
    }

    public String toString(boolean wrap) {
        String concat = wrap ? String.valueOf('\n') : String.valueOf(' ');
        String syntax = "SELECT";
        if (this.quantifier == 1) {
            syntax = syntax + ' ' + "ALL";
        } else if (this.quantifier == 2) {
            syntax = syntax + ' ' + "DISTINCT";
        }
        if (this.selectList.size() > 0) {
            syntax = syntax + concat + SQLFormatter.concat(this.getSelectList(), wrap);
        } else if (this.isAsteriskSet()) {
            syntax = syntax + ' ' + "*";
        }
        if (this.fromClause.size() > 0) {
            syntax = syntax + concat + "FROM" + concat + SQLFormatter.concat(this.getFromClause(), wrap);
        }
        if (this.whereClause.size() > 0) {
            syntax = syntax + concat + "WHERE" + concat + SQLFormatter.concat(this.getWhereClause(), wrap);
        }
        if (this.groupClause.size() > 0) {
            syntax = syntax + concat + "GROUP BY" + concat + SQLFormatter.concat(this.getGroupByClause(), wrap);
        }
        if (this.havingClause.size() > 0) {
            syntax = syntax + concat + "HAVING" + concat + SQLFormatter.concat(this.getHavingClause(), wrap);
        }
        return syntax;
    }

    public String toString() {
        return this.toString(false);
    }
}

